/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.quotas.GlobalQuotaSettings;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestMasterObserver {
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterObserver.class);
    public static CountDownLatch tableCreationLatch = new CountDownLatch(1);
    public static CountDownLatch tableDeletionLatch = new CountDownLatch(1);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static byte[] TEST_SNAPSHOT = Bytes.toBytes((String)"observed_snapshot");
    private static TableName TEST_CLONE = TableName.valueOf((String)"observed_clone");
    private static byte[] TEST_FAMILY = Bytes.toBytes((String)"fam1");
    private static byte[] TEST_FAMILY2 = Bytes.toBytes((String)"fam2");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.coprocessor.master.classes", CPMasterObserver.class.getName());
        UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test(timeout=180000L)
    public void testStarted() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        Assert.assertTrue((String)"Master should be active", (boolean)master.isActiveMaster());
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        Assert.assertNotNull((String)"CoprocessorHost should not be null", (Object)host);
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class);
        Assert.assertNotNull((String)"CPMasterObserver coprocessor not found or not installed!", (Object)cp);
        Assert.assertTrue((String)"MasterObserver should have been started", (boolean)cp.wasStarted());
        Assert.assertTrue((String)"preMasterInitialization() hook should have been called", (boolean)cp.wasMasterInitializationCalled());
        Assert.assertTrue((String)"postStartMaster() hook should have been called", (boolean)cp.wasStartMasterCalled());
    }

    @Test(timeout=180000L)
    public void testTableOperations() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class);
        cp.resetStates();
        Assert.assertFalse((String)"No table created yet", (boolean)cp.wasCreateTableCalled());
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
        try (Connection connection = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
             Admin admin = connection.getAdmin();){
            tableCreationLatch = new CountDownLatch(1);
            admin.createTable((TableDescriptor)htd, (byte[][])Arrays.copyOfRange(HBaseTestingUtility.KEYS, 1, HBaseTestingUtility.KEYS.length));
            Assert.assertTrue((String)"Test table should be created", (boolean)cp.wasCreateTableCalled());
            tableCreationLatch.await();
            Assert.assertTrue((String)"Table pre create handler called.", (boolean)cp.wasPreCreateTableActionCalled());
            Assert.assertTrue((String)"Table create handler should be called.", (boolean)cp.wasCreateTableActionCalled());
            RegionLocator regionLocator = connection.getRegionLocator(htd.getTableName());
            List regions = regionLocator.getAllRegionLocations();
            admin.mergeRegionsAsync(((HRegionLocation)regions.get(0)).getRegionInfo().getEncodedNameAsBytes(), ((HRegionLocation)regions.get(1)).getRegionInfo().getEncodedNameAsBytes(), true);
            Assert.assertTrue((String)"Coprocessor should have been called on region merge", (boolean)cp.wasMergeRegionsCalled());
            tableCreationLatch = new CountDownLatch(1);
            admin.disableTable(tableName);
            Assert.assertTrue((boolean)admin.isTableDisabled(tableName));
            Assert.assertTrue((String)"Coprocessor should have been called on table disable", (boolean)cp.wasDisableTableCalled());
            Assert.assertTrue((String)"Disable table handler should be called.", (boolean)cp.wasDisableTableActionCalled());
            Assert.assertFalse((boolean)cp.wasEnableTableCalled());
            admin.enableTable(tableName);
            Assert.assertTrue((boolean)admin.isTableEnabled(tableName));
            Assert.assertTrue((String)"Coprocessor should have been called on table enable", (boolean)cp.wasEnableTableCalled());
            Assert.assertTrue((String)"Enable table handler should be called.", (boolean)cp.wasEnableTableActionCalled());
            admin.disableTable(tableName);
            Assert.assertTrue((boolean)admin.isTableDisabled(tableName));
            htd.setMaxFileSize(0x20000000L);
            this.modifyTableSync(admin, tableName, htd);
            Assert.assertTrue((String)"Test table should have been modified", (boolean)cp.wasModifyTableCalled());
            admin.truncateTable(tableName, false);
            admin.disableTable(tableName);
            Assert.assertTrue((boolean)admin.isTableDisabled(tableName));
            this.deleteTable(admin, tableName);
            Assert.assertFalse((String)"Test table should have been deleted", (boolean)admin.tableExists(tableName));
            Assert.assertTrue((String)"Coprocessor should have been called on table delete", (boolean)cp.wasDeleteTableCalled());
            Assert.assertTrue((String)"Delete table handler should be called.", (boolean)cp.wasDeleteTableActionCalled());
            cp.resetStates();
            admin.createTable((TableDescriptor)htd);
            Assert.assertTrue((String)"Test table should be created", (boolean)cp.wasCreateTableCalled());
            tableCreationLatch.await();
            Assert.assertTrue((String)"Table pre create handler called.", (boolean)cp.wasPreCreateTableActionCalled());
            Assert.assertTrue((String)"Table create handler should be called.", (boolean)cp.wasCreateTableActionCalled());
            Assert.assertFalse((boolean)cp.wasDisableTableCalled());
            Assert.assertFalse((boolean)cp.wasDisableTableActionCalled());
            admin.disableTable(tableName);
            Assert.assertTrue((boolean)admin.isTableDisabled(tableName));
            Assert.assertTrue((String)"Coprocessor should have been called on table disable", (boolean)cp.wasDisableTableCalled());
            Assert.assertTrue((String)"Disable table handler should be called.", (boolean)cp.wasDisableTableActionCalled());
            htd.setMaxFileSize(0x20000000L);
            this.modifyTableSync(admin, tableName, htd);
            Assert.assertTrue((String)"Test table should have been modified", (boolean)cp.wasModifyTableCalled());
            Assert.assertFalse((boolean)cp.wasEnableTableCalled());
            Assert.assertFalse((boolean)cp.wasEnableTableActionCalled());
            admin.enableTable(tableName);
            Assert.assertTrue((boolean)admin.isTableEnabled(tableName));
            Assert.assertTrue((String)"Coprocessor should have been called on table enable", (boolean)cp.wasEnableTableCalled());
            Assert.assertTrue((String)"Enable table handler should be called.", (boolean)cp.wasEnableTableActionCalled());
            admin.disableTable(tableName);
            Assert.assertTrue((boolean)admin.isTableDisabled(tableName));
            Assert.assertFalse((String)"No table deleted yet", (boolean)cp.wasDeleteTableCalled());
            Assert.assertFalse((String)"Delete table handler should not be called.", (boolean)cp.wasDeleteTableActionCalled());
            this.deleteTable(admin, tableName);
            Assert.assertFalse((String)"Test table should have been deleted", (boolean)admin.tableExists(tableName));
            Assert.assertTrue((String)"Coprocessor should have been called on table delete", (boolean)cp.wasDeleteTableCalled());
            Assert.assertTrue((String)"Delete table handler should be called.", (boolean)cp.wasDeleteTableActionCalled());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testSnapshotOperations() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class);
        cp.resetStates();
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
        Admin admin = UTIL.getAdmin();
        tableCreationLatch = new CountDownLatch(1);
        admin.createTable((TableDescriptor)htd);
        tableCreationLatch.await();
        tableCreationLatch = new CountDownLatch(1);
        admin.disableTable(tableName);
        Assert.assertTrue((boolean)admin.isTableDisabled(tableName));
        try {
            Assert.assertFalse((String)"Coprocessor should not have been called yet", (boolean)cp.wasSnapshotCalled());
            admin.snapshot(TEST_SNAPSHOT, tableName);
            Assert.assertTrue((String)"Coprocessor should have been called on snapshot", (boolean)cp.wasSnapshotCalled());
            admin.listSnapshots();
            Assert.assertTrue((String)"Coprocessor should have been called on snapshot list", (boolean)cp.wasListSnapshotCalled());
            admin.cloneSnapshot(TEST_SNAPSHOT, TEST_CLONE);
            Assert.assertTrue((String)"Coprocessor should have been called on snapshot clone", (boolean)cp.wasCloneSnapshotCalled());
            Assert.assertFalse((String)"Coprocessor restore should not have been called on snapshot clone", (boolean)cp.wasRestoreSnapshotCalled());
            admin.disableTable(TEST_CLONE);
            Assert.assertTrue((boolean)admin.isTableDisabled(tableName));
            this.deleteTable(admin, TEST_CLONE);
            cp.resetStates();
            admin.restoreSnapshot(TEST_SNAPSHOT);
            Assert.assertTrue((String)"Coprocessor should have been called on snapshot restore", (boolean)cp.wasRestoreSnapshotCalled());
            Assert.assertFalse((String)"Coprocessor clone should not have been called on snapshot restore", (boolean)cp.wasCloneSnapshotCalled());
            admin.deleteSnapshot(TEST_SNAPSHOT);
            Assert.assertTrue((String)"Coprocessor should have been called on snapshot delete", (boolean)cp.wasDeleteSnapshotCalled());
        }
        finally {
            this.deleteTable(admin, tableName);
        }
    }

    @Test(timeout=180000L)
    public void testNamespaceOperations() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        String testNamespace = "observed_ns";
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class);
        Admin admin = UTIL.getAdmin();
        admin.createNamespace(NamespaceDescriptor.create((String)testNamespace).build());
        Assert.assertTrue((String)"Test namespace should be created", (boolean)cp.wasCreateNamespaceCalled());
        Assert.assertNotNull((Object)admin.getNamespaceDescriptor(testNamespace));
        Assert.assertTrue((String)"Test namespace descriptor should have been called", (boolean)cp.wasGetNamespaceDescriptorCalled());
    }

    private void modifyTableSync(Admin admin, TableName tableName, HTableDescriptor htd) throws IOException {
        HTableDescriptor td;
        admin.modifyTable(tableName, (TableDescriptor)htd);
        for (int t = 0; t < 100 && !(td = admin.getTableDescriptor(htd.getTableName())).equals((Object)htd); ++t) {
            Threads.sleep((long)100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testRegionTransitionOperations() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class);
        cp.resetStates();
        Table table = UTIL.createMultiRegionTable(tableName, TEST_FAMILY);
        try (RegionLocator r = UTIL.getConnection().getRegionLocator(tableName);){
            UTIL.waitUntilAllRegionsAssigned(tableName);
            List regions = r.getAllRegionLocations();
            HRegionLocation firstGoodPair = null;
            for (HRegionLocation e : regions) {
                if (e.getServerName() == null) continue;
                firstGoodPair = e;
                break;
            }
            Assert.assertNotNull((String)"Found a non-null entry", firstGoodPair);
            LOG.info("Found " + firstGoodPair.toString());
            Set servers = master.getClusterMetrics().getLiveServerMetrics().keySet();
            String destName = null;
            String serverNameForFirstRegion = firstGoodPair.getServerName().toString();
            LOG.info("serverNameForFirstRegion=" + serverNameForFirstRegion);
            ServerName masterServerName = master.getServerName();
            boolean found = false;
            for (ServerName info : servers) {
                LOG.info("ServerName=" + info);
                if (serverNameForFirstRegion.equals(info.getServerName()) || masterServerName.equals((Object)info)) continue;
                destName = info.toString();
                found = true;
                break;
            }
            Assert.assertTrue((String)"Found server", (boolean)found);
            LOG.info("Found " + destName);
            master.getMasterRpcServices().moveRegion(null, RequestConverter.buildMoveRegionRequest((byte[])firstGoodPair.getRegionInfo().getEncodedNameAsBytes(), (ServerName)ServerName.valueOf(destName)));
            Assert.assertTrue((String)"Coprocessor should have been called on region move", (boolean)cp.wasMoveCalled());
            master.balanceSwitch(true);
            Assert.assertTrue((String)"Coprocessor should have been called on balance switch", (boolean)cp.wasBalanceSwitchCalled());
            master.balanceSwitch(false);
            UTIL.waitUntilNoRegionsInTransition();
            HRegionServer rs = cluster.getRegionServer(0);
            byte[] destRS = Bytes.toBytes((String)cluster.getRegionServer(1).getServerName().toString());
            UTIL.waitUntilNoRegionsInTransition();
            List openRegions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices());
            int moveCnt = openRegions.size() / 2;
            for (int i = 0; i < moveCnt; ++i) {
                RegionInfo info = (RegionInfo)openRegions.get(i);
                if (info.isMetaRegion()) continue;
                master.getMasterRpcServices().moveRegion(null, RequestConverter.buildMoveRegionRequest((byte[])((RegionInfo)openRegions.get(i)).getEncodedNameAsBytes(), (ServerName)ServerName.valueOf((String)Bytes.toString((byte[])destRS))));
            }
            UTIL.waitUntilNoRegionsInTransition();
            master.balanceSwitch(true);
            boolean balanceRun = master.balance();
            Assert.assertTrue((String)"Coprocessor should be called on region rebalancing", (boolean)cp.wasBalanceCalled());
        }
        finally {
            Admin admin = UTIL.getAdmin();
            admin.disableTable(tableName);
            this.deleteTable(admin, tableName);
        }
    }

    @Test(timeout=180000L)
    public void testTableDescriptorsEnumeration() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class);
        cp.resetStates();
        MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest((List)null);
        master.getMasterRpcServices().getTableDescriptors(null, req);
        Assert.assertTrue((String)"Coprocessor should be called on table descriptors request", (boolean)cp.wasGetTableDescriptorsCalled());
    }

    @Test(timeout=180000L)
    public void testTableNamesEnumeration() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class);
        cp.resetStates();
        master.getMasterRpcServices().getTableNames(null, MasterProtos.GetTableNamesRequest.newBuilder().build());
        Assert.assertTrue((String)"Coprocessor should be called on table names request", (boolean)cp.wasGetTableNamesCalled());
    }

    @Test(timeout=180000L)
    public void testAbortProcedureOperation() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class);
        cp.resetStates();
        master.abortProcedure(1L, true);
        Assert.assertTrue((String)"Coprocessor should be called on abort procedure request", (boolean)cp.wasAbortProcedureCalled());
    }

    @Test(timeout=180000L)
    public void testGetProceduresOperation() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class);
        cp.resetStates();
        master.getProcedures();
        Assert.assertTrue((String)"Coprocessor should be called on get procedures request", (boolean)cp.wasGetProceduresCalled());
    }

    @Test(timeout=180000L)
    public void testGetLocksOperation() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        CPMasterObserver cp = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class);
        cp.resetStates();
        master.getLocks();
        Assert.assertTrue((String)"Coprocessor should be called on get locks request", (boolean)cp.wasGetLocksCalled());
    }

    private void deleteTable(Admin admin, TableName tableName) throws Exception {
        tableDeletionLatch = new CountDownLatch(1);
        admin.deleteTable(tableName);
        tableDeletionLatch.await();
        tableDeletionLatch = new CountDownLatch(1);
    }

    @Test
    public void testQueueLockAndLockHeartbeatOperations() throws Exception {
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        CPMasterObserver cp = (CPMasterObserver)master.getMasterCoprocessorHost().findCoprocessor(CPMasterObserver.class);
        cp.resetStates();
        TableName tableName = TableName.valueOf((String)"testLockedTable");
        long procId = master.getLockManager().remoteLocks().requestTableLock(tableName, LockType.EXCLUSIVE, "desc", null);
        master.getLockManager().remoteLocks().lockHeartbeat(procId, false);
        Assert.assertTrue((boolean)cp.preAndPostForQueueLockAndHeartbeatLockCalled());
        ProcedureTestingUtility.waitNoProcedureRunning((ProcedureExecutor)master.getMasterProcedureExecutor());
        ProcedureTestingUtility.assertProcNotFailed((ProcedureExecutor)master.getMasterProcedureExecutor(), (long)procId);
    }

    public static class CPMasterObserver
    implements MasterCoprocessor,
    MasterObserver {
        private boolean preCreateTableCalled;
        private boolean postCreateTableCalled;
        private boolean preDeleteTableCalled;
        private boolean postDeleteTableCalled;
        private boolean preTruncateTableCalled;
        private boolean postTruncateTableCalled;
        private boolean preModifyTableCalled;
        private boolean postModifyTableCalled;
        private boolean preCreateNamespaceCalled;
        private boolean postCreateNamespaceCalled;
        private boolean preDeleteNamespaceCalled;
        private boolean postDeleteNamespaceCalled;
        private boolean preModifyNamespaceCalled;
        private boolean postModifyNamespaceCalled;
        private boolean preGetNamespaceDescriptorCalled;
        private boolean postGetNamespaceDescriptorCalled;
        private boolean preListNamespaceDescriptorsCalled;
        private boolean postListNamespaceDescriptorsCalled;
        private boolean preAddColumnCalled;
        private boolean postAddColumnCalled;
        private boolean preModifyColumnCalled;
        private boolean postModifyColumnCalled;
        private boolean preDeleteColumnCalled;
        private boolean postDeleteColumnCalled;
        private boolean preEnableTableCalled;
        private boolean postEnableTableCalled;
        private boolean preDisableTableCalled;
        private boolean postDisableTableCalled;
        private boolean preAbortProcedureCalled;
        private boolean postAbortProcedureCalled;
        private boolean preGetProceduresCalled;
        private boolean postGetProceduresCalled;
        private boolean preGetLocksCalled;
        private boolean postGetLocksCalled;
        private boolean preMoveCalled;
        private boolean postMoveCalled;
        private boolean preAssignCalled;
        private boolean postAssignCalled;
        private boolean preUnassignCalled;
        private boolean postUnassignCalled;
        private boolean preRegionOfflineCalled;
        private boolean postRegionOfflineCalled;
        private boolean preBalanceCalled;
        private boolean postBalanceCalled;
        private boolean preBalanceSwitchCalled;
        private boolean postBalanceSwitchCalled;
        private boolean preShutdownCalled;
        private boolean preStopMasterCalled;
        private boolean preMasterInitializationCalled;
        private boolean postStartMasterCalled;
        private boolean startCalled;
        private boolean stopCalled;
        private boolean preSnapshotCalled;
        private boolean postSnapshotCalled;
        private boolean preListSnapshotCalled;
        private boolean postListSnapshotCalled;
        private boolean preCloneSnapshotCalled;
        private boolean postCloneSnapshotCalled;
        private boolean preRestoreSnapshotCalled;
        private boolean postRestoreSnapshotCalled;
        private boolean preDeleteSnapshotCalled;
        private boolean postDeleteSnapshotCalled;
        private boolean preCreateTableActionCalled;
        private boolean postCompletedCreateTableActionCalled;
        private boolean preDeleteTableActionCalled;
        private boolean postCompletedDeleteTableActionCalled;
        private boolean preTruncateTableActionCalled;
        private boolean postCompletedTruncateTableActionCalled;
        private boolean preAddColumnFamilyActionCalled;
        private boolean postCompletedAddColumnFamilyActionCalled;
        private boolean preModifyColumnFamilyActionCalled;
        private boolean postCompletedModifyColumnFamilyActionCalled;
        private boolean preDeleteColumnFamilyActionCalled;
        private boolean postCompletedDeleteColumnFamilyActionCalled;
        private boolean preEnableTableActionCalled;
        private boolean postCompletedEnableTableActionCalled;
        private boolean preDisableTableActionCalled;
        private boolean postCompletedDisableTableActionCalled;
        private boolean preModifyTableActionCalled;
        private boolean postCompletedModifyTableActionCalled;
        private boolean preGetTableDescriptorsCalled;
        private boolean postGetTableDescriptorsCalled;
        private boolean postGetTableNamesCalled;
        private boolean preGetTableNamesCalled;
        private boolean preMergeRegionsCalled;
        private boolean postMergeRegionsCalled;
        private boolean preRequestLockCalled;
        private boolean postRequestLockCalled;
        private boolean preLockHeartbeatCalled;
        private boolean postLockHeartbeatCalled;

        public void resetStates() {
            this.preCreateTableCalled = false;
            this.postCreateTableCalled = false;
            this.preDeleteTableCalled = false;
            this.postDeleteTableCalled = false;
            this.preTruncateTableCalled = false;
            this.postTruncateTableCalled = false;
            this.preModifyTableCalled = false;
            this.postModifyTableCalled = false;
            this.preCreateNamespaceCalled = false;
            this.postCreateNamespaceCalled = false;
            this.preDeleteNamespaceCalled = false;
            this.postDeleteNamespaceCalled = false;
            this.preModifyNamespaceCalled = false;
            this.postModifyNamespaceCalled = false;
            this.preGetNamespaceDescriptorCalled = false;
            this.postGetNamespaceDescriptorCalled = false;
            this.preListNamespaceDescriptorsCalled = false;
            this.postListNamespaceDescriptorsCalled = false;
            this.preAddColumnCalled = false;
            this.postAddColumnCalled = false;
            this.preModifyColumnCalled = false;
            this.postModifyColumnCalled = false;
            this.preDeleteColumnCalled = false;
            this.postDeleteColumnCalled = false;
            this.preEnableTableCalled = false;
            this.postEnableTableCalled = false;
            this.preDisableTableCalled = false;
            this.postDisableTableCalled = false;
            this.preAbortProcedureCalled = false;
            this.postAbortProcedureCalled = false;
            this.preGetProceduresCalled = false;
            this.postGetProceduresCalled = false;
            this.preGetLocksCalled = false;
            this.postGetLocksCalled = false;
            this.preMoveCalled = false;
            this.postMoveCalled = false;
            this.preAssignCalled = false;
            this.postAssignCalled = false;
            this.preUnassignCalled = false;
            this.postUnassignCalled = false;
            this.preRegionOfflineCalled = false;
            this.postRegionOfflineCalled = false;
            this.preBalanceCalled = false;
            this.postBalanceCalled = false;
            this.preBalanceSwitchCalled = false;
            this.postBalanceSwitchCalled = false;
            this.preShutdownCalled = false;
            this.preStopMasterCalled = false;
            this.preSnapshotCalled = false;
            this.postSnapshotCalled = false;
            this.preListSnapshotCalled = false;
            this.postListSnapshotCalled = false;
            this.preCloneSnapshotCalled = false;
            this.postCloneSnapshotCalled = false;
            this.preRestoreSnapshotCalled = false;
            this.postRestoreSnapshotCalled = false;
            this.preDeleteSnapshotCalled = false;
            this.postDeleteSnapshotCalled = false;
            this.preCreateTableActionCalled = false;
            this.postCompletedCreateTableActionCalled = false;
            this.preDeleteTableActionCalled = false;
            this.postCompletedDeleteTableActionCalled = false;
            this.preTruncateTableActionCalled = false;
            this.postCompletedTruncateTableActionCalled = false;
            this.preModifyTableActionCalled = false;
            this.postCompletedModifyTableActionCalled = false;
            this.preAddColumnFamilyActionCalled = false;
            this.postCompletedAddColumnFamilyActionCalled = false;
            this.preModifyColumnFamilyActionCalled = false;
            this.postCompletedModifyColumnFamilyActionCalled = false;
            this.preDeleteColumnFamilyActionCalled = false;
            this.postCompletedDeleteColumnFamilyActionCalled = false;
            this.preEnableTableActionCalled = false;
            this.postCompletedEnableTableActionCalled = false;
            this.preDisableTableActionCalled = false;
            this.postCompletedDisableTableActionCalled = false;
            this.preGetTableDescriptorsCalled = false;
            this.postGetTableDescriptorsCalled = false;
            this.postGetTableNamesCalled = false;
            this.preGetTableNamesCalled = false;
            this.preMergeRegionsCalled = false;
            this.postMergeRegionsCalled = false;
            this.preRequestLockCalled = false;
            this.postRequestLockCalled = false;
            this.preLockHeartbeatCalled = false;
            this.postLockHeartbeatCalled = false;
        }

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void preMergeRegions(ObserverContext<MasterCoprocessorEnvironment> ctx, RegionInfo[] regionsToMerge) throws IOException {
            this.preMergeRegionsCalled = true;
        }

        public void postMergeRegions(ObserverContext<MasterCoprocessorEnvironment> ctx, RegionInfo[] regionsToMerge) throws IOException {
            this.postMergeRegionsCalled = true;
        }

        public boolean wasMergeRegionsCalled() {
            return this.preMergeRegionsCalled && this.postMergeRegionsCalled;
        }

        public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> env, TableDescriptor desc, RegionInfo[] regions) throws IOException {
            this.preCreateTableCalled = true;
        }

        public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> env, TableDescriptor desc, RegionInfo[] regions) throws IOException {
            this.postCreateTableCalled = true;
        }

        public boolean wasCreateTableCalled() {
            return this.preCreateTableCalled && this.postCreateTableCalled;
        }

        public boolean preCreateTableCalledOnly() {
            return this.preCreateTableCalled && !this.postCreateTableCalled;
        }

        public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            this.preDeleteTableCalled = true;
        }

        public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            this.postDeleteTableCalled = true;
        }

        public boolean wasDeleteTableCalled() {
            return this.preDeleteTableCalled && this.postDeleteTableCalled;
        }

        public boolean preDeleteTableCalledOnly() {
            return this.preDeleteTableCalled && !this.postDeleteTableCalled;
        }

        public void preTruncateTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            this.preTruncateTableCalled = true;
        }

        public void postTruncateTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            this.postTruncateTableCalled = true;
        }

        public boolean wasTruncateTableCalled() {
            return this.preTruncateTableCalled && this.postTruncateTableCalled;
        }

        public boolean preTruncateTableCalledOnly() {
            return this.preTruncateTableCalled && !this.postTruncateTableCalled;
        }

        public void postSetSplitOrMergeEnabled(ObserverContext<MasterCoprocessorEnvironment> ctx, boolean newValue, MasterSwitchType switchType) throws IOException {
        }

        public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName, TableDescriptor htd) throws IOException {
            this.preModifyTableCalled = true;
        }

        public void postModifyTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName, TableDescriptor htd) throws IOException {
            this.postModifyTableCalled = true;
        }

        public boolean wasModifyTableCalled() {
            return this.preModifyTableCalled && this.postModifyTableCalled;
        }

        public boolean preModifyTableCalledOnly() {
            return this.preModifyTableCalled && !this.postModifyTableCalled;
        }

        public void preCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> env, NamespaceDescriptor ns) throws IOException {
            this.preCreateNamespaceCalled = true;
        }

        public void postCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> env, NamespaceDescriptor ns) throws IOException {
            this.postCreateNamespaceCalled = true;
        }

        public boolean wasCreateNamespaceCalled() {
            return this.preCreateNamespaceCalled && this.postCreateNamespaceCalled;
        }

        public boolean preCreateNamespaceCalledOnly() {
            return this.preCreateNamespaceCalled && !this.postCreateNamespaceCalled;
        }

        public void preDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> env, String name) throws IOException {
            this.preDeleteNamespaceCalled = true;
        }

        public void postDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> env, String name) throws IOException {
            this.postDeleteNamespaceCalled = true;
        }

        public boolean wasDeleteNamespaceCalled() {
            return this.preDeleteNamespaceCalled && this.postDeleteNamespaceCalled;
        }

        public boolean preDeleteNamespaceCalledOnly() {
            return this.preDeleteNamespaceCalled && !this.postDeleteNamespaceCalled;
        }

        public void preModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> env, NamespaceDescriptor ns) throws IOException {
            this.preModifyNamespaceCalled = true;
        }

        public void postModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> env, NamespaceDescriptor ns) throws IOException {
            this.postModifyNamespaceCalled = true;
        }

        public boolean wasModifyNamespaceCalled() {
            return this.preModifyNamespaceCalled && this.postModifyNamespaceCalled;
        }

        public boolean preModifyNamespaceCalledOnly() {
            return this.preModifyNamespaceCalled && !this.postModifyNamespaceCalled;
        }

        public void preGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
            this.preGetNamespaceDescriptorCalled = true;
        }

        public void postGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
            this.postGetNamespaceDescriptorCalled = true;
        }

        public boolean wasGetNamespaceDescriptorCalled() {
            return this.preGetNamespaceDescriptorCalled && this.postGetNamespaceDescriptorCalled;
        }

        public void preListNamespaceDescriptors(ObserverContext<MasterCoprocessorEnvironment> env, List<NamespaceDescriptor> descriptors) throws IOException {
            this.preListNamespaceDescriptorsCalled = true;
        }

        public void postListNamespaceDescriptors(ObserverContext<MasterCoprocessorEnvironment> env, List<NamespaceDescriptor> descriptors) throws IOException {
            this.postListNamespaceDescriptorsCalled = true;
        }

        public boolean wasListNamespaceDescriptorsCalled() {
            return this.preListNamespaceDescriptorsCalled && this.postListNamespaceDescriptorsCalled;
        }

        public boolean preListNamespaceDescriptorsCalledOnly() {
            return this.preListNamespaceDescriptorsCalled && !this.postListNamespaceDescriptorsCalled;
        }

        public void preEnableTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            this.preEnableTableCalled = true;
        }

        public void postEnableTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            this.postEnableTableCalled = true;
        }

        public boolean wasEnableTableCalled() {
            return this.preEnableTableCalled && this.postEnableTableCalled;
        }

        public boolean preEnableTableCalledOnly() {
            return this.preEnableTableCalled && !this.postEnableTableCalled;
        }

        public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            this.preDisableTableCalled = true;
        }

        public void postDisableTable(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            this.postDisableTableCalled = true;
        }

        public boolean wasDisableTableCalled() {
            return this.preDisableTableCalled && this.postDisableTableCalled;
        }

        public boolean preDisableTableCalledOnly() {
            return this.preDisableTableCalled && !this.postDisableTableCalled;
        }

        public void preAbortProcedure(ObserverContext<MasterCoprocessorEnvironment> ctx, long procId) throws IOException {
            this.preAbortProcedureCalled = true;
        }

        public void postAbortProcedure(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
            this.postAbortProcedureCalled = true;
        }

        public boolean wasAbortProcedureCalled() {
            return this.preAbortProcedureCalled && this.postAbortProcedureCalled;
        }

        public boolean wasPreAbortProcedureCalledOnly() {
            return this.preAbortProcedureCalled && !this.postAbortProcedureCalled;
        }

        public void preGetProcedures(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
            this.preGetProceduresCalled = true;
        }

        public void postGetProcedures(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
            this.postGetProceduresCalled = true;
        }

        public boolean wasGetProceduresCalled() {
            return this.preGetProceduresCalled && this.postGetProceduresCalled;
        }

        public boolean wasPreGetProceduresCalledOnly() {
            return this.preGetProceduresCalled && !this.postGetProceduresCalled;
        }

        public void preGetLocks(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
            this.preGetLocksCalled = true;
        }

        public void postGetLocks(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
            this.postGetLocksCalled = true;
        }

        public boolean wasGetLocksCalled() {
            return this.preGetLocksCalled && this.postGetLocksCalled;
        }

        public boolean wasPreGetLocksCalledOnly() {
            return this.preGetLocksCalled && !this.postGetLocksCalled;
        }

        public void preMove(ObserverContext<MasterCoprocessorEnvironment> env, RegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
            this.preMoveCalled = true;
        }

        public void postMove(ObserverContext<MasterCoprocessorEnvironment> env, RegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
            this.postMoveCalled = true;
        }

        public boolean wasMoveCalled() {
            return this.preMoveCalled && this.postMoveCalled;
        }

        public boolean preMoveCalledOnly() {
            return this.preMoveCalled && !this.postMoveCalled;
        }

        public void preAssign(ObserverContext<MasterCoprocessorEnvironment> env, RegionInfo regionInfo) throws IOException {
            this.preAssignCalled = true;
        }

        public void postAssign(ObserverContext<MasterCoprocessorEnvironment> env, RegionInfo regionInfo) throws IOException {
            this.postAssignCalled = true;
        }

        public boolean wasAssignCalled() {
            return this.preAssignCalled && this.postAssignCalled;
        }

        public boolean preAssignCalledOnly() {
            return this.preAssignCalled && !this.postAssignCalled;
        }

        public void preUnassign(ObserverContext<MasterCoprocessorEnvironment> env, RegionInfo regionInfo, boolean force) throws IOException {
            this.preUnassignCalled = true;
        }

        public void postUnassign(ObserverContext<MasterCoprocessorEnvironment> env, RegionInfo regionInfo, boolean force) throws IOException {
            this.postUnassignCalled = true;
        }

        public boolean wasUnassignCalled() {
            return this.preUnassignCalled && this.postUnassignCalled;
        }

        public boolean preUnassignCalledOnly() {
            return this.preUnassignCalled && !this.postUnassignCalled;
        }

        public void preRegionOffline(ObserverContext<MasterCoprocessorEnvironment> env, RegionInfo regionInfo) throws IOException {
            this.preRegionOfflineCalled = true;
        }

        public void postRegionOffline(ObserverContext<MasterCoprocessorEnvironment> env, RegionInfo regionInfo) throws IOException {
            this.postRegionOfflineCalled = true;
        }

        public boolean wasRegionOfflineCalled() {
            return this.preRegionOfflineCalled && this.postRegionOfflineCalled;
        }

        public boolean preRegionOfflineCalledOnly() {
            return this.preRegionOfflineCalled && !this.postRegionOfflineCalled;
        }

        public void preBalance(ObserverContext<MasterCoprocessorEnvironment> env) throws IOException {
            this.preBalanceCalled = true;
        }

        public void postBalance(ObserverContext<MasterCoprocessorEnvironment> env, List<RegionPlan> plans) throws IOException {
            this.postBalanceCalled = true;
        }

        public boolean wasBalanceCalled() {
            return this.preBalanceCalled && this.postBalanceCalled;
        }

        public boolean preBalanceCalledOnly() {
            return this.preBalanceCalled && !this.postBalanceCalled;
        }

        public void preBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> env, boolean b) throws IOException {
            this.preBalanceSwitchCalled = true;
        }

        public void postBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> env, boolean oldValue, boolean newValue) throws IOException {
            this.postBalanceSwitchCalled = true;
        }

        public boolean wasBalanceSwitchCalled() {
            return this.preBalanceSwitchCalled && this.postBalanceSwitchCalled;
        }

        public boolean preBalanceSwitchCalledOnly() {
            return this.preBalanceSwitchCalled && !this.postBalanceSwitchCalled;
        }

        public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> env) throws IOException {
            this.preShutdownCalled = true;
        }

        public boolean wasShutdownCalled() {
            return this.preShutdownCalled;
        }

        public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> env) throws IOException {
            this.preStopMasterCalled = true;
        }

        public boolean wasStopMasterCalled() {
            return this.preStopMasterCalled;
        }

        public void preMasterInitialization(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
            this.preMasterInitializationCalled = true;
        }

        public boolean wasMasterInitializationCalled() {
            return this.preMasterInitializationCalled;
        }

        public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
            this.postStartMasterCalled = true;
        }

        public boolean wasStartMasterCalled() {
            return this.postStartMasterCalled;
        }

        public void start(CoprocessorEnvironment env) throws IOException {
            this.startCalled = true;
        }

        public void stop(CoprocessorEnvironment env) throws IOException {
            this.stopCalled = true;
        }

        public boolean wasStarted() {
            return this.startCalled;
        }

        public boolean wasStopped() {
            return this.stopCalled;
        }

        public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
            this.preSnapshotCalled = true;
        }

        public void postSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
            this.postSnapshotCalled = true;
        }

        public boolean wasSnapshotCalled() {
            return this.preSnapshotCalled && this.postSnapshotCalled;
        }

        public void preListSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot) throws IOException {
            this.preListSnapshotCalled = true;
        }

        public void postListSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot) throws IOException {
            this.postListSnapshotCalled = true;
        }

        public boolean wasListSnapshotCalled() {
            return this.preListSnapshotCalled && this.postListSnapshotCalled;
        }

        public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
            this.preCloneSnapshotCalled = true;
        }

        public void postCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
            this.postCloneSnapshotCalled = true;
        }

        public boolean wasCloneSnapshotCalled() {
            return this.preCloneSnapshotCalled && this.postCloneSnapshotCalled;
        }

        public void preRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
            this.preRestoreSnapshotCalled = true;
        }

        public void postRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
            this.postRestoreSnapshotCalled = true;
        }

        public boolean wasRestoreSnapshotCalled() {
            return this.preRestoreSnapshotCalled && this.postRestoreSnapshotCalled;
        }

        public void preDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot) throws IOException {
            this.preDeleteSnapshotCalled = true;
        }

        public void postDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot) throws IOException {
            this.postDeleteSnapshotCalled = true;
        }

        public boolean wasDeleteSnapshotCalled() {
            return this.preDeleteSnapshotCalled && this.postDeleteSnapshotCalled;
        }

        public void preCreateTableAction(ObserverContext<MasterCoprocessorEnvironment> env, TableDescriptor desc, RegionInfo[] regions) throws IOException {
            this.preCreateTableActionCalled = true;
        }

        public void postCompletedCreateTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
            this.postCompletedCreateTableActionCalled = true;
            tableCreationLatch.countDown();
        }

        public boolean wasPreCreateTableActionCalled() {
            return this.preCreateTableActionCalled;
        }

        public boolean wasCreateTableActionCalled() {
            return this.preCreateTableActionCalled && this.postCompletedCreateTableActionCalled;
        }

        public boolean wasCreateTableActionCalledOnly() {
            return this.preCreateTableActionCalled && !this.postCompletedCreateTableActionCalled;
        }

        public void preDeleteTableAction(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            this.preDeleteTableActionCalled = true;
        }

        public void postCompletedDeleteTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            this.postCompletedDeleteTableActionCalled = true;
            tableDeletionLatch.countDown();
        }

        public boolean wasDeleteTableActionCalled() {
            return this.preDeleteTableActionCalled && this.postCompletedDeleteTableActionCalled;
        }

        public boolean wasDeleteTableActionCalledOnly() {
            return this.preDeleteTableActionCalled && !this.postCompletedDeleteTableActionCalled;
        }

        public void preTruncateTableAction(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName) throws IOException {
            this.preTruncateTableActionCalled = true;
        }

        public void postCompletedTruncateTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            this.postCompletedTruncateTableActionCalled = true;
        }

        public boolean wasTruncateTableActionCalled() {
            return this.preTruncateTableActionCalled && this.postCompletedTruncateTableActionCalled;
        }

        public boolean wasTruncateTableActionCalledOnly() {
            return this.preTruncateTableActionCalled && !this.postCompletedTruncateTableActionCalled;
        }

        public void preModifyTableAction(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName, TableDescriptor htd) throws IOException {
            this.preModifyTableActionCalled = true;
        }

        public void postCompletedModifyTableAction(ObserverContext<MasterCoprocessorEnvironment> env, TableName tableName, TableDescriptor htd) throws IOException {
            this.postCompletedModifyTableActionCalled = true;
        }

        public boolean wasModifyTableActionCalled() {
            return this.preModifyTableActionCalled && this.postCompletedModifyTableActionCalled;
        }

        public boolean wasModifyTableActionCalledOnly() {
            return this.preModifyTableActionCalled && !this.postCompletedModifyTableActionCalled;
        }

        public void preEnableTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            this.preEnableTableActionCalled = true;
        }

        public void postCompletedEnableTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            this.postCompletedEnableTableActionCalled = true;
        }

        public boolean wasEnableTableActionCalled() {
            return this.preEnableTableActionCalled && this.postCompletedEnableTableActionCalled;
        }

        public boolean preEnableTableActionCalledOnly() {
            return this.preEnableTableActionCalled && !this.postCompletedEnableTableActionCalled;
        }

        public void preDisableTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            this.preDisableTableActionCalled = true;
        }

        public void postCompletedDisableTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            this.postCompletedDisableTableActionCalled = true;
        }

        public boolean wasDisableTableActionCalled() {
            return this.preDisableTableActionCalled && this.postCompletedDisableTableActionCalled;
        }

        public boolean preDisableTableActionCalledOnly() {
            return this.preDisableTableActionCalled && !this.postCompletedDisableTableActionCalled;
        }

        public void preGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<TableDescriptor> descriptors, String regex) throws IOException {
            this.preGetTableDescriptorsCalled = true;
        }

        public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<TableDescriptor> descriptors, String regex) throws IOException {
            this.postGetTableDescriptorsCalled = true;
        }

        public boolean wasGetTableDescriptorsCalled() {
            return this.preGetTableDescriptorsCalled && this.postGetTableDescriptorsCalled;
        }

        public void preGetTableNames(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableDescriptor> descriptors, String regex) throws IOException {
            this.preGetTableNamesCalled = true;
        }

        public void postGetTableNames(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableDescriptor> descriptors, String regex) throws IOException {
            this.postGetTableNamesCalled = true;
        }

        public boolean wasGetTableNamesCalled() {
            return this.preGetTableNamesCalled && this.postGetTableNamesCalled;
        }

        public void preTableFlush(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        }

        public void postTableFlush(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        }

        public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, GlobalQuotaSettings quotas) throws IOException {
        }

        public void postSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, GlobalQuotaSettings quotas) throws IOException {
        }

        public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, TableName tableName, GlobalQuotaSettings quotas) throws IOException {
        }

        public void postSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, TableName tableName, GlobalQuotaSettings quotas) throws IOException {
        }

        public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, String namespace, GlobalQuotaSettings quotas) throws IOException {
        }

        public void postSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, String namespace, GlobalQuotaSettings quotas) throws IOException {
        }

        public void preSetTableQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, GlobalQuotaSettings quotas) throws IOException {
        }

        public void postSetTableQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, GlobalQuotaSettings quotas) throws IOException {
        }

        public void preSetNamespaceQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, GlobalQuotaSettings quotas) throws IOException {
        }

        public void postSetNamespaceQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, GlobalQuotaSettings quotas) throws IOException {
        }

        public void preMoveServersAndTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, Set<TableName> tables, String targetGroup) throws IOException {
        }

        public void postMoveServersAndTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, Set<TableName> tables, String targetGroup) throws IOException {
        }

        public void preMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, String targetGroup) throws IOException {
        }

        public void postMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, String targetGroup) throws IOException {
        }

        public void preMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroupGroup) throws IOException {
        }

        public void postMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroup) throws IOException {
        }

        public void preAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
        }

        public void postAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
        }

        public void preRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
        }

        public void postRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
        }

        public void preBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName) throws IOException {
        }

        public void postBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName, boolean balancerRan) throws IOException {
        }

        public void preRequestLock(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, TableName tableName, RegionInfo[] regionInfos, String description) throws IOException {
            this.preRequestLockCalled = true;
        }

        public void postRequestLock(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, TableName tableName, RegionInfo[] regionInfos, String description) throws IOException {
            this.postRequestLockCalled = true;
        }

        public void preLockHeartbeat(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tn, String description) throws IOException {
            this.preLockHeartbeatCalled = true;
        }

        public void postLockHeartbeat(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
            this.postLockHeartbeatCalled = true;
        }

        public boolean preAndPostForQueueLockAndHeartbeatLockCalled() {
            return this.preRequestLockCalled && this.postRequestLockCalled && this.preLockHeartbeatCalled && this.postLockHeartbeatCalled;
        }

        public void preSplitRegion(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, byte[] splitRow) throws IOException {
        }

        public void preSplitRegionAction(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, byte[] splitRow) throws IOException {
        }

        public void postCompletedSplitRegionAction(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo regionInfoA, RegionInfo regionInfoB) throws IOException {
        }

        public void preSplitRegionBeforeMETAAction(ObserverContext<MasterCoprocessorEnvironment> ctx, byte[] splitKey, List<Mutation> metaEntries) throws IOException {
        }

        public void preSplitRegionAfterMETAAction(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        }

        public void postRollBackSplitRegionAction(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        }

        public void preMergeRegionsAction(ObserverContext<MasterCoprocessorEnvironment> ctx, RegionInfo[] regionsToMerge) throws IOException {
        }

        public void postCompletedMergeRegionsAction(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo[] regionsToMerge, RegionInfo mergedRegion) throws IOException {
        }

        public void preMergeRegionsCommitAction(ObserverContext<MasterCoprocessorEnvironment> ctx, RegionInfo[] regionsToMerge, List<Mutation> metaEntries) throws IOException {
        }

        public void postMergeRegionsCommitAction(ObserverContext<MasterCoprocessorEnvironment> ctx, RegionInfo[] regionsToMerge, RegionInfo mergedRegion) throws IOException {
        }

        public void postRollBackMergeRegionsAction(ObserverContext<MasterCoprocessorEnvironment> ctx, RegionInfo[] regionsToMerge) throws IOException {
        }
    }
}

