/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestRegionObserverBypass {
    private static HBaseTestingUtility util;
    private static final TableName tableName;
    private static final byte[] dummy;
    private static final byte[] row1;
    private static final byte[] row2;
    private static final byte[] row3;
    private static final byte[] test;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setStrings("hbase.coprocessor.user.region.classes", new String[]{TestCoprocessor.class.getName(), TestCoprocessor2.class.getName(), TestCoprocessor3.class.getName()});
        util = new HBaseTestingUtility(conf);
        util.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        Admin admin = util.getAdmin();
        if (admin.tableExists(tableName)) {
            if (admin.isTableEnabled(tableName)) {
                admin.disableTable(tableName);
            }
            admin.deleteTable(tableName);
        }
        util.createTable(tableName, (byte[][])new byte[][]{dummy, test});
        TestCoprocessor.PREPUT_BYPASSES.set(0);
        TestCoprocessor.PREPUT_INVOCATIONS.set(0);
    }

    @Test
    public void testSimple() throws Exception {
        Table t = util.getConnection().getTable(tableName);
        Put p = new Put(row1);
        p.addColumn(test, dummy, dummy);
        t.put(p);
        this.checkRowAndDelete(t, row1, 0);
        t.close();
    }

    @Test
    public void testMulti() throws Exception {
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
        Table t = util.getConnection().getTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>();
        Put p = new Put(row1);
        p.addColumn(dummy, dummy, dummy);
        puts.add(p);
        p = new Put(row2);
        p.addColumn(test, dummy, dummy);
        puts.add(p);
        p = new Put(row3);
        p.addColumn(test, dummy, dummy);
        puts.add(p);
        t.put(puts);
        this.checkRowAndDelete(t, row1, 1);
        this.checkRowAndDelete(t, row2, 0);
        this.checkRowAndDelete(t, row3, 0);
        puts.clear();
        p = new Put(row1);
        p.addColumn(test, dummy, dummy);
        puts.add(p);
        p = new Put(row2);
        p.addColumn(test, dummy, dummy);
        puts.add(p);
        p = new Put(row3);
        p.addColumn(test, dummy, dummy);
        puts.add(p);
        t.put(puts);
        this.checkRowAndDelete(t, row1, 0);
        this.checkRowAndDelete(t, row2, 0);
        this.checkRowAndDelete(t, row3, 0);
        puts.clear();
        p = new Put(row1);
        p.addColumn(test, dummy, dummy);
        puts.add(p);
        p = new Put(row2);
        p.addColumn(test, dummy, dummy);
        puts.add(p);
        p = new Put(row3);
        p.addColumn(dummy, dummy, dummy);
        puts.add(p);
        t.put(puts);
        this.checkRowAndDelete(t, row1, 0);
        this.checkRowAndDelete(t, row2, 0);
        this.checkRowAndDelete(t, row3, 1);
        puts.clear();
        p = new Put(row1);
        p.addColumn(dummy, dummy, dummy);
        puts.add(p);
        p = new Put(row2);
        p.addColumn(test, dummy, dummy);
        puts.add(p);
        p = new Put(row3);
        p.addColumn(dummy, dummy, dummy);
        puts.add(p);
        t.put(puts);
        this.checkRowAndDelete(t, row1, 1);
        this.checkRowAndDelete(t, row2, 0);
        this.checkRowAndDelete(t, row3, 1);
        puts.clear();
        p = new Put(row1);
        p.addColumn(test, dummy, dummy);
        puts.add(p);
        p = new Put(row2);
        p.addColumn(dummy, dummy, dummy);
        puts.add(p);
        p = new Put(row3);
        p.addColumn(test, dummy, dummy);
        puts.add(p);
        t.put(puts);
        this.checkRowAndDelete(t, row1, 0);
        this.checkRowAndDelete(t, row2, 1);
        this.checkRowAndDelete(t, row3, 0);
        t.close();
        EnvironmentEdgeManager.reset();
    }

    private void checkRowAndDelete(Table t, byte[] row, int count) throws IOException {
        Get g = new Get(row);
        Result r = t.get(g);
        Assert.assertEquals((int)count, (int)r.size());
        Delete d = new Delete(row);
        t.delete(d);
    }

    @Test
    public void testBypassAlsoCompletes() throws IOException {
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
        Table t = util.getConnection().getTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>();
        Put p = new Put(row1);
        p.addColumn(dummy, dummy, dummy);
        puts.add(p);
        p = new Put(row2);
        p.addColumn(test, dummy, dummy);
        puts.add(p);
        p = new Put(row3);
        p.addColumn(test, dummy, dummy);
        puts.add(p);
        t.put(puts);
        this.checkRowAndDelete(t, row1, 1);
        this.checkRowAndDelete(t, row2, 0);
        this.checkRowAndDelete(t, row3, 0);
        Assert.assertEquals((String)"Total CP invocation count", (int)5, (int)TestCoprocessor.PREPUT_INVOCATIONS.get());
        Assert.assertEquals((String)"Total CP bypasses", (int)2, (int)TestCoprocessor.PREPUT_BYPASSES.get());
    }

    static {
        tableName = TableName.valueOf((String)"test");
        dummy = Bytes.toBytes((String)"dummy");
        row1 = Bytes.toBytes((String)"r1");
        row2 = Bytes.toBytes((String)"r2");
        row3 = Bytes.toBytes((String)"r3");
        test = Bytes.toBytes((String)"test");
    }

    public static class TestCoprocessor3
    extends TestCoprocessor {
    }

    public static class TestCoprocessor2
    extends TestCoprocessor {
    }

    public static class TestCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        static AtomicInteger PREPUT_INVOCATIONS = new AtomicInteger(0);
        static AtomicInteger PREPUT_BYPASSES = new AtomicInteger(0);

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            PREPUT_INVOCATIONS.incrementAndGet();
            NavigableMap familyMap = put.getFamilyCellMap();
            if (familyMap.containsKey(test)) {
                PREPUT_BYPASSES.incrementAndGet();
                e.bypass();
            }
        }
    }
}

