/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.math.BigDecimal;
import org.apache.hadoop.hbase.filter.BigDecimalComparator;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={FilterTests.class, SmallTests.class})
public class TestBigDecimalComparator {
    @Test
    public void testObjectEquals() {
        BigDecimal bd = new BigDecimal(Double.MIN_VALUE);
        BigDecimalComparator bdc = new BigDecimalComparator(bd);
        Assert.assertTrue((boolean)bdc.equals((Object)bdc));
        Assert.assertEquals((long)bdc.hashCode(), (long)bdc.hashCode());
        BigDecimalComparator bdc1 = new BigDecimalComparator(bd);
        BigDecimalComparator bdc2 = new BigDecimalComparator(bd);
        Assert.assertTrue((boolean)bdc1.equals((Object)bdc2));
        Assert.assertEquals((long)bdc1.hashCode(), (long)bdc2.hashCode());
        BigDecimalComparator bdc3 = new BigDecimalComparator(bd);
        BigDecimalComparator bdc4 = new BigDecimalComparator(new BigDecimal(Long.MIN_VALUE));
        Assert.assertFalse((boolean)bdc3.equals((Object)bdc4));
        Assert.assertNotEquals((long)bdc3.hashCode(), (long)bdc4.hashCode());
        BigDecimalComparator bdc5 = new BigDecimalComparator(bd);
        Assert.assertFalse((boolean)bdc5.equals((Object)0));
    }

    @Test
    public void testEqualsValue() {
        BigDecimal bd1 = new BigDecimal(Double.MAX_VALUE);
        BigDecimal bd2 = new BigDecimal(Double.MIN_VALUE);
        byte[] value1 = Bytes.toBytes((BigDecimal)bd1);
        byte[] value2 = Bytes.toBytes((BigDecimal)bd2);
        BigDecimalComparator comparator1 = new BigDecimalComparator(bd1);
        BigDecimalComparator comparator2 = new BigDecimalComparator(bd2);
        int comp1 = comparator1.compareTo(value1);
        int comp2 = comparator2.compareTo(value2);
        Assert.assertEquals((long)0L, (long)comp1);
        Assert.assertEquals((long)0L, (long)comp2);
    }

    @Test
    public void testGreaterThanValue() {
        byte[] val1 = Bytes.toBytes((BigDecimal)new BigDecimal("1000000000000000000000000000000.9999999999999999"));
        byte[] val2 = Bytes.toBytes((BigDecimal)new BigDecimal(0));
        byte[] val3 = Bytes.toBytes((BigDecimal)new BigDecimal(Double.MIN_VALUE));
        BigDecimal bd = new BigDecimal(Double.MAX_VALUE);
        BigDecimalComparator comparator = new BigDecimalComparator(bd);
        int comp1 = comparator.compareTo(val1);
        int comp2 = comparator.compareTo(val2);
        int comp3 = comparator.compareTo(val3);
        Assert.assertEquals((long)1L, (long)comp1);
        Assert.assertEquals((long)1L, (long)comp2);
        Assert.assertEquals((long)1L, (long)comp3);
    }

    @Test
    public void testLessThanValue() {
        byte[] val1 = Bytes.toBytes((BigDecimal)new BigDecimal("-1000000000000000000000000000000"));
        byte[] val2 = Bytes.toBytes((BigDecimal)new BigDecimal(0));
        byte[] val3 = Bytes.toBytes((BigDecimal)new BigDecimal(1));
        BigDecimal bd = new BigDecimal("-1000000000000000000000000000000.0000000000000001");
        BigDecimalComparator comparator = new BigDecimalComparator(bd);
        int comp1 = comparator.compareTo(val1);
        int comp2 = comparator.compareTo(val2);
        int comp3 = comparator.compareTo(val3);
        Assert.assertEquals((long)-1L, (long)comp1);
        Assert.assertEquals((long)-1L, (long)comp2);
        Assert.assertEquals((long)-1L, (long)comp3);
    }
}

