/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class, FilterTests.class})
public class TestFilterListOnMini {
    private static final Logger LOG = LoggerFactory.getLogger(TestFilterListOnMini.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testFiltersWithOR() throws Exception {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        Table table = TEST_UTIL.createTable(tn, new String[]{"cf1", "cf2"});
        byte[] CF1 = Bytes.toBytes((String)"cf1");
        byte[] CF2 = Bytes.toBytes((String)"cf2");
        Put put1 = new Put(Bytes.toBytes((String)"0"));
        put1.addColumn(CF1, Bytes.toBytes((String)"col_a"), Bytes.toBytes((int)0));
        table.put(put1);
        Put put2 = new Put(Bytes.toBytes((String)"0"));
        put2.addColumn(CF2, Bytes.toBytes((String)"col_b"), Bytes.toBytes((int)0));
        table.put(put2);
        FamilyFilter filterCF1 = new FamilyFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(CF1));
        FamilyFilter filterCF2 = new FamilyFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(CF2));
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        filterList.addFilter((Filter)filterCF1);
        filterList.addFilter((Filter)filterCF2);
        Scan scan = new Scan();
        scan.setFilter((Filter)filterList);
        ResultScanner scanner = table.getScanner(scan);
        LOG.info("Filter list: " + filterList);
        Result rr = scanner.next();
        while (rr != null) {
            Assert.assertEquals((long)2L, (long)rr.size());
            rr = scanner.next();
        }
    }
}

