/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, LargeTests.class})
public class TestChangingEncoding {
    private static final Logger LOG = LoggerFactory.getLogger(TestChangingEncoding.class);
    static final String CF = "EncodingTestCF";
    static final byte[] CF_BYTES = Bytes.toBytes((String)"EncodingTestCF");
    private static final int NUM_ROWS_PER_BATCH = 100;
    private static final int NUM_COLS_PER_ROW = 20;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Configuration conf = TEST_UTIL.getConfiguration();
    private static final int TIMEOUT_MS = 600000;
    private HColumnDescriptor hcd;
    private TableName tableName;
    private static final List<DataBlockEncoding> ENCODINGS_TO_ITERATE = TestChangingEncoding.createEncodingsToIterate();
    private int numBatchesWritten;

    private static final List<DataBlockEncoding> createEncodingsToIterate() {
        ArrayList<DataBlockEncoding> encodings = new ArrayList<DataBlockEncoding>(Arrays.asList(DataBlockEncoding.values()));
        encodings.add(DataBlockEncoding.NONE);
        return Collections.unmodifiableList(encodings);
    }

    private void prepareTest(String testId) throws IOException {
        this.tableName = TableName.valueOf((String)("test_table_" + testId));
        HTableDescriptor htd = new HTableDescriptor(this.tableName);
        this.hcd = new HColumnDescriptor(CF);
        htd.addFamily(this.hcd);
        try (Admin admin = TEST_UTIL.getConnection().getAdmin();){
            admin.createTable((TableDescriptor)htd);
        }
        this.numBatchesWritten = 0;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf.setInt("hbase.hregion.memstore.flush.size", 0x100000);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private static byte[] getRowKey(int batchId, int i) {
        return Bytes.toBytes((String)("batch" + batchId + "_row" + i));
    }

    private static byte[] getQualifier(int j) {
        return Bytes.toBytes((String)("col" + j));
    }

    private static byte[] getValue(int batchId, int i, int j) {
        return Bytes.toBytes((String)("value_for_" + Bytes.toString((byte[])TestChangingEncoding.getRowKey(batchId, i)) + "_col" + j));
    }

    static void writeTestDataBatch(TableName tableName, int batchId) throws Exception {
        LOG.debug("Writing test data batch " + batchId);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < 100; ++i) {
            Put put = new Put(TestChangingEncoding.getRowKey(batchId, i));
            for (int j = 0; j < 20; ++j) {
                put.addColumn(CF_BYTES, TestChangingEncoding.getQualifier(j), TestChangingEncoding.getValue(batchId, i, j));
            }
            put.setDurability(Durability.SKIP_WAL);
            puts.add(put);
        }
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
             Table table = conn.getTable(tableName);){
            table.put(puts);
        }
    }

    static void verifyTestDataBatch(TableName tableName, int batchId) throws Exception {
        LOG.debug("Verifying test data batch " + batchId);
        Table table = TEST_UTIL.getConnection().getTable(tableName);
        for (int i = 0; i < 100; ++i) {
            Get get = new Get(TestChangingEncoding.getRowKey(batchId, i));
            Result result = table.get(get);
            for (int j = 0; j < 20; ++j) {
                Cell kv = result.getColumnLatestCell(CF_BYTES, TestChangingEncoding.getQualifier(j));
                if (kv == null) continue;
                Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)kv, (byte[])TestChangingEncoding.getValue(batchId, i, j)));
            }
        }
        table.close();
    }

    private void writeSomeNewData() throws Exception {
        TestChangingEncoding.writeTestDataBatch(this.tableName, this.numBatchesWritten);
        ++this.numBatchesWritten;
    }

    private void verifyAllData() throws Exception {
        for (int i = 0; i < this.numBatchesWritten; ++i) {
            TestChangingEncoding.verifyTestDataBatch(this.tableName, i);
        }
    }

    private void setEncodingConf(DataBlockEncoding encoding, boolean onlineChange) throws Exception {
        LOG.debug("Setting CF encoding to " + encoding + " (ordinal=" + encoding.ordinal() + "), onlineChange=" + onlineChange);
        this.hcd.setDataBlockEncoding(encoding);
        try (Admin admin = TEST_UTIL.getConnection().getAdmin();){
            if (!onlineChange) {
                admin.disableTable(this.tableName);
            }
            admin.modifyColumnFamily(this.tableName, (ColumnFamilyDescriptor)this.hcd);
            if (!onlineChange) {
                admin.enableTable(this.tableName);
            }
        }
        TEST_UTIL.waitUntilNoRegionsInTransition(600000L);
    }

    @Test(timeout=600000L)
    public void testChangingEncoding() throws Exception {
        this.prepareTest("ChangingEncoding");
        for (boolean onlineChange : new boolean[]{false, true}) {
            for (DataBlockEncoding encoding : ENCODINGS_TO_ITERATE) {
                this.setEncodingConf(encoding, onlineChange);
                this.writeSomeNewData();
                this.verifyAllData();
            }
        }
    }

    @Test(timeout=600000L)
    public void testChangingEncodingWithCompaction() throws Exception {
        this.prepareTest("ChangingEncodingWithCompaction");
        for (boolean onlineChange : new boolean[]{false, true}) {
            for (DataBlockEncoding encoding : ENCODINGS_TO_ITERATE) {
                this.setEncodingConf(encoding, onlineChange);
                this.writeSomeNewData();
                this.verifyAllData();
                this.compactAndWait();
                this.verifyAllData();
            }
        }
    }

    private void compactAndWait() throws IOException, InterruptedException {
        boolean cont;
        LOG.debug("Compacting table " + this.tableName);
        HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
        Admin admin = TEST_UTIL.getAdmin();
        admin.majorCompact(this.tableName);
        long maxWaitime = System.currentTimeMillis() + 500L;
        do {
            cont = rs.compactSplitThread.getCompactionQueueSize() == 0;
            Threads.sleep((long)1L);
        } while (cont && System.currentTimeMillis() < maxWaitime);
        while (rs.compactSplitThread.getCompactionQueueSize() > 0) {
            Threads.sleep((long)1L);
        }
        LOG.debug("Compaction queue size reached 0, continuing");
    }

    @Test
    public void testCrazyRandomChanges() throws Exception {
        this.prepareTest("RandomChanges");
        Random rand = new Random(2934298742974297L);
        for (int i = 0; i < 10; ++i) {
            int encodingOrdinal = rand.nextInt(DataBlockEncoding.values().length);
            DataBlockEncoding encoding = DataBlockEncoding.values()[encodingOrdinal];
            this.setEncodingConf(encoding, rand.nextBoolean());
            this.writeSomeNewData();
            this.verifyAllData();
        }
    }
}

