/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockCacheUtil;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.io.hfile.TestCacheConfig;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, SmallTests.class})
public class TestBlockCacheReporting {
    private static final Logger LOG = LoggerFactory.getLogger(TestBlockCacheReporting.class);
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        CacheConfig.clearGlobalInstances();
        this.conf = HBaseConfiguration.create();
    }

    @After
    public void tearDown() throws Exception {
        CacheConfig.clearGlobalInstances();
    }

    private void addDataAndHits(BlockCache bc, int count) {
        TestCacheConfig.DataCacheEntry dce = new TestCacheConfig.DataCacheEntry();
        TestCacheConfig.IndexCacheEntry ice = new TestCacheConfig.IndexCacheEntry();
        for (int i = 0; i < count; ++i) {
            BlockCacheKey bckd = new BlockCacheKey("f", (long)i);
            BlockCacheKey bcki = new BlockCacheKey("f", (long)(i + count));
            bc.getBlock(bckd, true, false, true);
            bc.cacheBlock(bckd, (Cacheable)dce);
            bc.cacheBlock(bcki, (Cacheable)ice);
            bc.getBlock(bckd, true, false, true);
            bc.getBlock(bcki, true, false, true);
        }
        Assert.assertEquals((long)(2 * count), (long)bc.getStats().getHitCount());
        BlockCacheKey bckd = new BlockCacheKey("f", 0L);
        BlockCacheKey bcki = new BlockCacheKey("f", (long)(0 + count));
        bc.evictBlock(bckd);
        bc.evictBlock(bcki);
        bc.getStats().getEvictedCount();
    }

    @Test
    public void testBucketCache() throws JsonGenerationException, JsonMappingException, IOException {
        this.conf.set("hbase.bucketcache.ioengine", "offheap");
        this.conf.setInt("hbase.bucketcache.size", 100);
        CacheConfig cc = new CacheConfig(this.conf);
        Assert.assertTrue((boolean)(cc.getBlockCache() instanceof CombinedBlockCache));
        this.logPerBlock(cc.getBlockCache());
        int count = 3;
        this.addDataAndHits(cc.getBlockCache(), 3);
        LOG.info(Objects.toString(cc.getBlockCache().getStats()));
        BlockCacheUtil.CachedBlocksByFile cbsbf = this.logPerBlock(cc.getBlockCache());
        LOG.info(Objects.toString(cbsbf));
        this.logPerFile(cbsbf);
        this.bucketCacheReport(cc.getBlockCache());
        LOG.info(BlockCacheUtil.toJSON((BlockCacheUtil.CachedBlocksByFile)cbsbf));
    }

    @Test
    public void testLruBlockCache() throws JsonGenerationException, JsonMappingException, IOException {
        CacheConfig cc = new CacheConfig(this.conf);
        Assert.assertTrue((boolean)cc.isBlockCacheEnabled());
        Assert.assertTrue((false == cc.isInMemory() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(cc.getBlockCache() instanceof LruBlockCache));
        this.logPerBlock(cc.getBlockCache());
        this.addDataAndHits(cc.getBlockCache(), 3);
        BlockCache bc = cc.getBlockCache();
        LOG.info("count=" + bc.getBlockCount() + ", currentSize=" + bc.getCurrentSize() + ", freeSize=" + bc.getFreeSize());
        LOG.info(Objects.toString(cc.getBlockCache().getStats()));
        BlockCacheUtil.CachedBlocksByFile cbsbf = this.logPerBlock(cc.getBlockCache());
        LOG.info(Objects.toString(cbsbf));
        this.logPerFile(cbsbf);
        this.bucketCacheReport(cc.getBlockCache());
        LOG.info(BlockCacheUtil.toJSON((BlockCacheUtil.CachedBlocksByFile)cbsbf));
    }

    private void bucketCacheReport(BlockCache bc) {
        LOG.info(bc.getClass().getSimpleName() + ": " + bc.getStats());
        BlockCache[] bcs = bc.getBlockCaches();
        if (bcs != null) {
            for (BlockCache sbc : bc.getBlockCaches()) {
                LOG.info(bc.getClass().getSimpleName() + ": " + sbc.getStats());
            }
        }
    }

    private void logPerFile(BlockCacheUtil.CachedBlocksByFile cbsbf) throws JsonGenerationException, JsonMappingException, IOException {
        for (Map.Entry e : cbsbf.getCachedBlockStatsByFile().entrySet()) {
            int count = 0;
            long size = 0L;
            int countData = 0;
            long sizeData = 0L;
            for (CachedBlock cb : (NavigableSet)e.getValue()) {
                ++count;
                size += cb.getSize();
                BlockType bt = cb.getBlockType();
                if (bt == null || !bt.isData()) continue;
                ++countData;
                sizeData += cb.getSize();
            }
            LOG.info("filename=" + (String)e.getKey() + ", count=" + count + ", countData=" + countData + ", size=" + size + ", sizeData=" + sizeData);
            LOG.info(BlockCacheUtil.toJSON((String)((String)e.getKey()), (NavigableSet)((NavigableSet)e.getValue())));
        }
    }

    private BlockCacheUtil.CachedBlocksByFile logPerBlock(BlockCache bc) throws JsonGenerationException, JsonMappingException, IOException {
        BlockCacheUtil.CachedBlocksByFile cbsbf = new BlockCacheUtil.CachedBlocksByFile();
        for (CachedBlock cb : bc) {
            LOG.info(cb.toString());
            LOG.info(BlockCacheUtil.toJSON((BlockCache)bc));
            cbsbf.update(cb);
        }
        return cbsbf;
    }
}

