/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.nio.ByteBuffer;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import org.apache.hadoop.hbase.io.hfile.LruCachedBlock;
import org.apache.hadoop.hbase.io.hfile.LruCachedBlockQueue;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestCachedBlockQueue
extends TestCase {
    public void testQueue() throws Exception {
        CachedBlock cb1 = new CachedBlock(1000L, "cb1", 1L);
        CachedBlock cb2 = new CachedBlock(1500L, "cb2", 2L);
        CachedBlock cb3 = new CachedBlock(1000L, "cb3", 3L);
        CachedBlock cb4 = new CachedBlock(1500L, "cb4", 4L);
        CachedBlock cb5 = new CachedBlock(1000L, "cb5", 5L);
        CachedBlock cb6 = new CachedBlock(1750L, "cb6", 6L);
        CachedBlock cb7 = new CachedBlock(1000L, "cb7", 7L);
        CachedBlock cb8 = new CachedBlock(1500L, "cb8", 8L);
        CachedBlock cb9 = new CachedBlock(1000L, "cb9", 9L);
        CachedBlock cb10 = new CachedBlock(1500L, "cb10", 10L);
        LruCachedBlockQueue queue = new LruCachedBlockQueue(10000L, 1000L);
        queue.add((LruCachedBlock)cb1);
        queue.add((LruCachedBlock)cb2);
        queue.add((LruCachedBlock)cb3);
        queue.add((LruCachedBlock)cb4);
        queue.add((LruCachedBlock)cb5);
        queue.add((LruCachedBlock)cb6);
        queue.add((LruCachedBlock)cb7);
        queue.add((LruCachedBlock)cb8);
        queue.add((LruCachedBlock)cb9);
        queue.add((LruCachedBlock)cb10);
        long expectedSize = cb1.heapSize() + cb2.heapSize() + cb3.heapSize() + cb4.heapSize() + cb5.heapSize() + cb6.heapSize() + cb7.heapSize() + cb8.heapSize();
        TestCachedBlockQueue.assertEquals((long)queue.heapSize(), (long)expectedSize);
        for (int i = 1; i <= 8; ++i) {
            TestCachedBlockQueue.assertEquals((String)queue.pollLast().getCacheKey().getHfileName(), (String)("cb" + i));
        }
    }

    public void testQueueSmallBlockEdgeCase() throws Exception {
        CachedBlock cb1 = new CachedBlock(1000L, "cb1", 1L);
        CachedBlock cb2 = new CachedBlock(1500L, "cb2", 2L);
        CachedBlock cb3 = new CachedBlock(1000L, "cb3", 3L);
        CachedBlock cb4 = new CachedBlock(1500L, "cb4", 4L);
        CachedBlock cb5 = new CachedBlock(1000L, "cb5", 5L);
        CachedBlock cb6 = new CachedBlock(1750L, "cb6", 6L);
        CachedBlock cb7 = new CachedBlock(1000L, "cb7", 7L);
        CachedBlock cb8 = new CachedBlock(1500L, "cb8", 8L);
        CachedBlock cb9 = new CachedBlock(1000L, "cb9", 9L);
        CachedBlock cb10 = new CachedBlock(1500L, "cb10", 10L);
        LruCachedBlockQueue queue = new LruCachedBlockQueue(10000L, 1000L);
        queue.add((LruCachedBlock)cb1);
        queue.add((LruCachedBlock)cb2);
        queue.add((LruCachedBlock)cb3);
        queue.add((LruCachedBlock)cb4);
        queue.add((LruCachedBlock)cb5);
        queue.add((LruCachedBlock)cb6);
        queue.add((LruCachedBlock)cb7);
        queue.add((LruCachedBlock)cb8);
        queue.add((LruCachedBlock)cb9);
        queue.add((LruCachedBlock)cb10);
        CachedBlock cb0 = new CachedBlock(10L + CachedBlock.PER_BLOCK_OVERHEAD, "cb0", 0L);
        queue.add((LruCachedBlock)cb0);
        long expectedSize = cb1.heapSize() + cb2.heapSize() + cb3.heapSize() + cb4.heapSize() + cb5.heapSize() + cb6.heapSize() + cb7.heapSize() + cb8.heapSize() + cb0.heapSize();
        TestCachedBlockQueue.assertEquals((long)queue.heapSize(), (long)expectedSize);
        for (int i = 0; i <= 8; ++i) {
            TestCachedBlockQueue.assertEquals((String)queue.pollLast().getCacheKey().getHfileName(), (String)("cb" + i));
        }
    }

    private static class CachedBlock
    extends LruCachedBlock {
        public CachedBlock(final long heapSize, String name, long accessTime) {
            super(new BlockCacheKey(name, 0L), new Cacheable(){

                public long heapSize() {
                    return (int)(heapSize - PER_BLOCK_OVERHEAD);
                }

                public int getSerializedLength() {
                    return 0;
                }

                public void serialize(ByteBuffer destination) {
                }

                public CacheableDeserializer<Cacheable> getDeserializer() {
                    return null;
                }

                public BlockType getBlockType() {
                    return BlockType.DATA;
                }

                public Cacheable.MemoryType getMemoryType() {
                    return Cacheable.MemoryType.EXCLUSIVE;
                }
            }, accessTime, false);
        }
    }
}

