/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import org.apache.hadoop.hbase.io.hfile.bucket.FileIOEngine;
import org.apache.hadoop.hbase.io.hfile.bucket.TestByteBufferIOEngine;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestFileIOEngine {
    private static final long TOTAL_CAPACITY = 0x600000L;
    private static final String[] FILE_PATHS;
    private static final long SIZE_PER_FILE;
    private static final List<Long> boundaryStartPositions;
    private static final List<Long> boundaryStopPositions;
    private FileIOEngine fileIOEngine;

    @Before
    public void setUp() throws IOException {
        this.fileIOEngine = new FileIOEngine(0x600000L, false, FILE_PATHS);
    }

    @After
    public void cleanUp() {
        this.fileIOEngine.shutdown();
        for (String filePath : FILE_PATHS) {
            File file = new File(filePath);
            if (!file.exists()) continue;
            file.delete();
        }
    }

    @Test
    public void testFileIOEngine() throws IOException {
        for (int i = 0; i < 500; ++i) {
            int len = (int)Math.floor(Math.random() * 100.0) + 1;
            long offset = (long)Math.floor(Math.random() * 6291456.0 % (double)(0x600000L - (long)len));
            if (i < boundaryStartPositions.size()) {
                offset = boundaryStartPositions.get(i);
            } else if (i - boundaryStartPositions.size() < boundaryStopPositions.size()) {
                offset = boundaryStopPositions.get(i - boundaryStartPositions.size()) - (long)len + 1L;
            } else if (i % 2 == 0) {
                offset = (long)Math.max(1, i % FILE_PATHS.length) * SIZE_PER_FILE - (long)(len / 2);
            }
            byte[] data1 = new byte[len];
            for (int j = 0; j < data1.length; ++j) {
                data1[j] = (byte)(Math.random() * 255.0);
            }
            this.fileIOEngine.write(ByteBuffer.wrap(data1), offset);
            TestByteBufferIOEngine.BufferGrabbingDeserializer deserializer = new TestByteBufferIOEngine.BufferGrabbingDeserializer();
            this.fileIOEngine.read(offset, len, (CacheableDeserializer)deserializer);
            ByteBuff data2 = deserializer.getDeserializedByteBuff();
            Assert.assertArrayEquals((byte[])data1, (byte[])data2.array());
        }
    }

    @Test
    public void testFileIOEngineHandlesZeroLengthInput() throws IOException {
        byte[] data1 = new byte[]{};
        this.fileIOEngine.write(ByteBuffer.wrap(data1), 0L);
        TestByteBufferIOEngine.BufferGrabbingDeserializer deserializer = new TestByteBufferIOEngine.BufferGrabbingDeserializer();
        this.fileIOEngine.read(0L, 0, (CacheableDeserializer)deserializer);
        ByteBuff data2 = deserializer.getDeserializedByteBuff();
        Assert.assertArrayEquals((byte[])data1, (byte[])data2.array());
    }

    @Test
    public void testClosedChannelException() throws IOException {
        this.fileIOEngine.closeFileChannels();
        int len = 5;
        long offset = 0L;
        byte[] data1 = new byte[len];
        for (int j = 0; j < data1.length; ++j) {
            data1[j] = (byte)(Math.random() * 255.0);
        }
        this.fileIOEngine.write(ByteBuffer.wrap(data1), offset);
        TestByteBufferIOEngine.BufferGrabbingDeserializer deserializer = new TestByteBufferIOEngine.BufferGrabbingDeserializer();
        this.fileIOEngine.read(offset, len, (CacheableDeserializer)deserializer);
        ByteBuff data2 = deserializer.getDeserializedByteBuff();
        Assert.assertArrayEquals((byte[])data1, (byte[])data2.array());
    }

    static {
        int i;
        FILE_PATHS = new String[]{"testFileIOEngine1", "testFileIOEngine2", "testFileIOEngine3"};
        SIZE_PER_FILE = 0x600000L / (long)FILE_PATHS.length;
        boundaryStartPositions = new ArrayList<Long>();
        boundaryStopPositions = new ArrayList<Long>();
        boundaryStartPositions.add(0L);
        for (i = 1; i < FILE_PATHS.length; ++i) {
            boundaryStartPositions.add(SIZE_PER_FILE * (long)i - 1L);
            boundaryStartPositions.add(SIZE_PER_FILE * (long)i);
            boundaryStartPositions.add(SIZE_PER_FILE * (long)i + 1L);
        }
        for (i = 1; i < FILE_PATHS.length; ++i) {
            boundaryStopPositions.add(SIZE_PER_FILE * (long)i - 1L);
            boundaryStopPositions.add(SIZE_PER_FILE * (long)i);
            boundaryStopPositions.add(SIZE_PER_FILE * (long)i + 1L);
        }
        boundaryStopPositions.add(SIZE_PER_FILE * (long)FILE_PATHS.length - 1L);
    }
}

