/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.ipc.AbstractTestIPC;
import org.apache.hadoop.hbase.ipc.BlockingRpcClient;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerFactory;
import org.apache.hadoop.hbase.ipc.SimpleRpcServer;
import org.apache.hadoop.hbase.ipc.SimpleServerRpcConnection;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.experimental.categories.Category;

@Category(value={RPCTests.class, SmallTests.class})
public class TestBlockingIPC
extends AbstractTestIPC {
    @Override
    protected RpcServer createRpcServer(Server server, String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler) throws IOException {
        return RpcServerFactory.createRpcServer((Server)server, (String)name, services, (InetSocketAddress)bindAddress, (Configuration)conf, (RpcScheduler)scheduler);
    }

    protected BlockingRpcClient createRpcClientNoCodec(Configuration conf) {
        return new BlockingRpcClient(conf){

            Codec getCodec() {
                return null;
            }
        };
    }

    protected BlockingRpcClient createRpcClient(Configuration conf) {
        return new BlockingRpcClient(conf);
    }

    protected BlockingRpcClient createRpcClientRTEDuringConnectionSetup(Configuration conf) throws IOException {
        return new BlockingRpcClient(conf){

            boolean isTcpNoDelay() {
                throw new RuntimeException("Injected fault");
            }
        };
    }

    @Override
    protected RpcServer createTestFailingRpcServer(Server server, String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler) throws IOException {
        return new TestFailingRpcServer(server, name, services, bindAddress, conf, scheduler);
    }

    private static class TestFailingRpcServer
    extends SimpleRpcServer {
        TestFailingRpcServer(Server server, String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler) throws IOException {
            super(server, name, services, bindAddress, conf, scheduler, true);
        }

        protected SimpleServerRpcConnection getConnection(SocketChannel channel, long time) {
            return new FailingConnection(this, channel, time);
        }

        final class FailingConnection
        extends SimpleServerRpcConnection {
            private FailingConnection(TestFailingRpcServer rpcServer, SocketChannel channel, long lastContact) {
                super((SimpleRpcServer)rpcServer, channel, lastContact);
            }

            public void processRequest(ByteBuff buf) throws IOException, InterruptedException {
                throw new DoNotRetryIOException("Failing for test");
            }
        }
    }
}

