/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.charset.Charset;
import org.apache.hadoop.hbase.ipc.BufferChain;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Charsets;
import org.apache.hbase.thirdparty.com.google.common.io.Files;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={RPCTests.class, SmallTests.class})
public class TestBufferChain {
    private File tmpFile;
    private static final byte[][] HELLO_WORLD_CHUNKS = new byte[][]{"hello".getBytes(Charsets.UTF_8), " ".getBytes(Charsets.UTF_8), "world".getBytes(Charsets.UTF_8)};

    @Before
    public void setup() throws IOException {
        this.tmpFile = File.createTempFile("TestBufferChain", "txt");
    }

    @After
    public void teardown() {
        this.tmpFile.delete();
    }

    @Test
    public void testGetBackBytesWePutIn() {
        ByteBuffer[] bufs = this.wrapArrays(HELLO_WORLD_CHUNKS);
        BufferChain chain = new BufferChain(bufs);
        Assert.assertTrue((boolean)Bytes.equals((byte[])Bytes.toBytes((String)"hello world"), (byte[])chain.getBytes()));
    }

    @Test
    public void testChainChunkBiggerThanWholeArray() throws IOException {
        ByteBuffer[] bufs = this.wrapArrays(HELLO_WORLD_CHUNKS);
        BufferChain chain = new BufferChain(bufs);
        this.writeAndVerify(chain, "hello world", 8192);
        this.assertNoRemaining(bufs);
    }

    @Test
    public void testChainChunkBiggerThanSomeArrays() throws IOException {
        ByteBuffer[] bufs = this.wrapArrays(HELLO_WORLD_CHUNKS);
        BufferChain chain = new BufferChain(bufs);
        this.writeAndVerify(chain, "hello world", 3);
        this.assertNoRemaining(bufs);
    }

    @Test
    public void testLimitOffset() throws IOException {
        ByteBuffer[] bufs = new ByteBuffer[]{this.stringBuf("XXXhelloYYY", 3, 5), this.stringBuf(" ", 0, 1), this.stringBuf("XXXXworldY", 4, 5)};
        BufferChain chain = new BufferChain(bufs);
        this.writeAndVerify(chain, "hello world", 3);
        this.assertNoRemaining(bufs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithSpy() throws IOException {
        ByteBuffer[] bufs = new ByteBuffer[]{this.stringBuf("XXXhelloYYY", 3, 5), this.stringBuf(" ", 0, 1), this.stringBuf("XXXXworldY", 4, 5)};
        BufferChain chain = new BufferChain(bufs);
        FileOutputStream fos = new FileOutputStream(this.tmpFile);
        FileChannel ch = (FileChannel)Mockito.spy((Object)fos.getChannel());
        try {
            chain.write((GatheringByteChannel)ch, 2);
            Assert.assertEquals((Object)"he", (Object)Files.toString((File)this.tmpFile, (Charset)Charsets.UTF_8));
            chain.write((GatheringByteChannel)ch, 2);
            Assert.assertEquals((Object)"hell", (Object)Files.toString((File)this.tmpFile, (Charset)Charsets.UTF_8));
            chain.write((GatheringByteChannel)ch, 3);
            Assert.assertEquals((Object)"hello w", (Object)Files.toString((File)this.tmpFile, (Charset)Charsets.UTF_8));
            chain.write((GatheringByteChannel)ch, 8);
            Assert.assertEquals((Object)"hello world", (Object)Files.toString((File)this.tmpFile, (Charset)Charsets.UTF_8));
        }
        finally {
            ch.close();
            fos.close();
        }
    }

    private ByteBuffer stringBuf(String string, int position, int length) {
        ByteBuffer buf = ByteBuffer.wrap(string.getBytes(Charsets.UTF_8));
        buf.position(position);
        buf.limit(position + length);
        Assert.assertTrue((boolean)buf.hasRemaining());
        return buf;
    }

    private void assertNoRemaining(ByteBuffer[] bufs) {
        for (ByteBuffer buf : bufs) {
            Assert.assertFalse((boolean)buf.hasRemaining());
        }
    }

    private ByteBuffer[] wrapArrays(byte[][] arrays) {
        ByteBuffer[] ret = new ByteBuffer[arrays.length];
        for (int i = 0; i < arrays.length; ++i) {
            ret[i] = ByteBuffer.wrap(arrays[i]);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndVerify(BufferChain chain, String string, int chunkSize) throws IOException {
        FileOutputStream fos = new FileOutputStream(this.tmpFile);
        FileChannel ch = fos.getChannel();
        try {
            long remaining = string.length();
            while (chain.hasRemaining()) {
                long n = chain.write((GatheringByteChannel)ch, chunkSize);
                Assert.assertTrue((n == (long)chunkSize || n == remaining ? 1 : 0) != 0);
                remaining -= n;
            }
            Assert.assertEquals((long)0L, (long)remaining);
        }
        finally {
            fos.close();
        }
        Assert.assertFalse((boolean)chain.hasRemaining());
        Assert.assertEquals((Object)string, (Object)Files.toString((File)this.tmpFile, (Charset)Charsets.UTF_8));
    }
}

