/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.BlockingRpcClient;
import org.apache.hadoop.hbase.ipc.BlockingRpcConnection;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestRpcClientLeaks {
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    public static final Logger LOG = LoggerFactory.getLogger(TestRpcClientLeaks.class);

    @BeforeClass
    public static void setup() throws Exception {
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void teardown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test(expected=RetriesExhaustedException.class)
    public void testSocketClosed() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        UTIL.createTable(tableName, HBaseTestingUtility.fam1).close();
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.set("hbase.rpc.client.impl", MyRpcClientImpl.class.getName());
        conf.setInt("hbase.client.retries.number", 2);
        Connection connection = ConnectionFactory.createConnection((Configuration)conf);
        Table table = connection.getTable(TableName.valueOf((String)this.name.getMethodName()));
        table.get(new Get("asd".getBytes()));
        connection.close();
        for (Socket socket : MyRpcClientImpl.savedSockets) {
            Assert.assertTrue((String)("Socket + " + socket + " is not closed"), (boolean)socket.isClosed());
        }
    }

    public static class MyRpcClientImpl
    extends BlockingRpcClient {
        public static List<Socket> savedSockets = Lists.newArrayList();
        @Rule
        public ExpectedException thrown = ExpectedException.none();

        public MyRpcClientImpl(Configuration conf) {
            super(conf);
        }

        public MyRpcClientImpl(Configuration conf, String clusterId, SocketAddress address, MetricsConnection metrics) {
            super(conf, clusterId, address, metrics);
        }

        protected BlockingRpcConnection createConnection(ConnectionId remoteId) throws IOException {
            return new BlockingRpcConnection(this, remoteId){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected synchronized void setupConnection() throws IOException {
                    super.setupConnection();
                    List<Socket> list = savedSockets;
                    synchronized (list) {
                        savedSockets.add(this.socket);
                    }
                    throw new IOException("Sample exception for verifying socket closure in case of exceptions.");
                }
            };
        }
    }
}

