/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Ignore
@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterBalanceThrottling {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILYNAME = Bytes.toBytes((String)"fam");

    @Before
    public void setupConfiguration() {
        TEST_UTIL.getConfiguration().set("hbase.master.loadbalancer.class", "org.apache.hadoop.hbase.master.balancer.SimpleLoadBalancer");
    }

    @After
    public void shutdown() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.balancer.max.balancing", 300000);
        TEST_UTIL.getConfiguration().setDouble("hbase.master.balancer.maxRitPercent", 1.0);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=60000L)
    public void testThrottlingByBalanceInterval() throws Exception {
        TEST_UTIL.startMiniCluster(2);
        TableName tableName = this.createTable("testNoThrottling");
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        this.unbalance(master, tableName);
        AtomicInteger maxCount = new AtomicInteger(0);
        AtomicBoolean stop = new AtomicBoolean(false);
        Thread checker = this.startBalancerChecker(master, maxCount, stop);
        master.balance();
        stop.set(true);
        checker.interrupt();
        checker.join();
        Assert.assertTrue((String)("max regions in transition: " + maxCount.get()), (maxCount.get() == 1 ? 1 : 0) != 0);
        TEST_UTIL.deleteTable(tableName);
    }

    @Test(timeout=60000L)
    public void testThrottlingByMaxRitPercent() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.balancer.max.balancing", 500);
        TEST_UTIL.getConfiguration().setDouble("hbase.master.balancer.maxRitPercent", 0.05);
        TEST_UTIL.startMiniCluster(2);
        TableName tableName = this.createTable("testThrottlingByMaxRitPercent");
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        this.unbalance(master, tableName);
        AtomicInteger maxCount = new AtomicInteger(0);
        AtomicBoolean stop = new AtomicBoolean(false);
        Thread checker = this.startBalancerChecker(master, maxCount, stop);
        master.balance();
        stop.set(true);
        checker.interrupt();
        checker.join();
        Assert.assertTrue((String)("max regions in transition: " + maxCount.get()), (maxCount.get() == 5 ? 1 : 0) != 0);
        TEST_UTIL.deleteTable(tableName);
    }

    private TableName createTable(String table) throws IOException {
        TableName tableName = TableName.valueOf((String)table);
        byte[] startKey = new byte[]{0};
        byte[] stopKey = new byte[]{127};
        TEST_UTIL.createTable(tableName, new byte[][]{FAMILYNAME}, 1, startKey, stopKey, 100);
        return tableName;
    }

    private Thread startBalancerChecker(final HMaster master, final AtomicInteger maxCount, final AtomicBoolean stop) {
        Runnable checker = new Runnable(){

            @Override
            public void run() {
                while (!stop.get()) {
                    maxCount.set(Math.max(maxCount.get(), master.getAssignmentManager().getRegionStates().getRegionsInTransitionCount()));
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        Thread thread = new Thread(checker);
        thread.start();
        return thread;
    }

    private void unbalance(HMaster master, TableName tableName) throws Exception {
        while (master.getAssignmentManager().getRegionStates().getRegionsInTransitionCount() > 0) {
            Thread.sleep(100L);
        }
        HRegionServer biasedServer = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
        for (HRegionInfo regionInfo : TEST_UTIL.getAdmin().getTableRegions(tableName)) {
            master.move(regionInfo.getEncodedNameAsBytes(), Bytes.toBytes((String)biasedServer.getServerName().getServerName()));
        }
        while (master.getAssignmentManager().getRegionStates().getRegionsInTransitionCount() > 0) {
            Thread.sleep(100L);
        }
    }
}

