/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterFileSystem.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setupTest() throws Exception {
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void teardownTest() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testFsUriSetProperly() throws Exception {
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        MasterFileSystem fs = master.getMasterFileSystem();
        Path masterRoot = FSUtils.getRootDir((Configuration)fs.getConfiguration());
        Path rootDir = FSUtils.getRootDir((Configuration)fs.getFileSystem().getConf());
        LOG.debug("from fs uri:" + FileSystem.getDefaultUri((Configuration)fs.getFileSystem().getConf()));
        LOG.debug("from configuration uri:" + FileSystem.getDefaultUri((Configuration)fs.getConfiguration()));
        Assert.assertEquals((Object)masterRoot, (Object)rootDir);
    }
}

