/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaMockingUtil;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerMetricsBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterMetaBootstrap;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MockRegionServer;
import org.apache.hadoop.hbase.master.RegionServerTracker;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterNoCluster {
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterNoCluster.class);
    private static final HBaseTestingUtility TESTUTIL = new HBaseTestingUtility();
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration c = TESTUTIL.getConfiguration();
        FSUtils.setRootDir((Configuration)c, (Path)TESTUTIL.getDataTestDir());
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        TESTUTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TESTUTIL.shutdownMiniZKCluster();
    }

    @After
    public void tearDown() throws KeeperException, ZooKeeperConnectionException, IOException {
        ZKWatcher zkw = new ZKWatcher(TESTUTIL.getConfiguration(), "@Before", new Abortable(){

            public void abort(String why, Throwable e) {
                throw new RuntimeException(why, e);
            }

            public boolean isAborted() {
                return false;
            }
        });
        ZKUtil.deleteNodeRecursively((ZKWatcher)zkw, (String)zkw.znodePaths.baseZNode);
        zkw.close();
    }

    @Test
    public void testStopDuringStart() throws IOException, KeeperException, InterruptedException {
        HMaster master = new HMaster(TESTUTIL.getConfiguration());
        master.start();
        master.stopMaster();
        master.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testFailover() throws Exception {
        long now = System.currentTimeMillis();
        ServerName sn0 = ServerName.valueOf((String)"0.example.org", (int)0, (long)now);
        ServerName sn1 = ServerName.valueOf((String)"1.example.org", (int)1, (long)now);
        ServerName sn2 = ServerName.valueOf((String)"2.example.org", (int)2, (long)now);
        final ServerName[] sns = new ServerName[]{sn0, sn1, sn2};
        Configuration conf = TESTUTIL.getConfiguration();
        MockRegionServer rs0 = new MockRegionServer(conf, sn0);
        MockRegionServer rs1 = new MockRegionServer(conf, sn1);
        MockRegionServer rs2 = new MockRegionServer(conf, sn2);
        MetaTableLocator.setMetaLocation((ZKWatcher)rs0.getZooKeeper(), (ServerName)rs0.getServerName(), (RegionState.State)RegionState.State.OPEN);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Result[] results = new Result[]{MetaMockingUtil.getMetaTableRowResult(new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HBaseTestingUtility.KEYS[1]), rs2.getServerName()), MetaMockingUtil.getMetaTableRowResult(new HRegionInfo(tableName, HBaseTestingUtility.KEYS[1], HBaseTestingUtility.KEYS[2]), rs2.getServerName()), MetaMockingUtil.getMetaTableRowResult(new HRegionInfo(tableName, HBaseTestingUtility.KEYS[2], HConstants.EMPTY_END_ROW), rs2.getServerName())};
        rs1.setNextResults(HRegionInfo.FIRST_META_REGIONINFO.getRegionName(), results);
        final ClusterConnection mockedConnection = HConnectionTestingUtility.getMockedConnectionAndDecorate(TESTUTIL.getConfiguration(), rs0, rs0, rs0.getServerName(), (RegionInfo)HRegionInfo.FIRST_META_REGIONINFO);
        HMaster master = new HMaster(conf){

            InetAddress getRemoteInetAddress(int port, long serverStartCode) throws UnknownHostException {
                if (port > sns.length) {
                    return super.getRemoteInetAddress(port, serverStartCode);
                }
                ServerName sn = sns[port];
                return InetAddress.getByAddress(sn.getHostname(), new byte[]{10, 0, 0, (byte)sn.getPort()});
            }

            void initClusterSchemaService() throws IOException, InterruptedException {
            }

            ServerManager createServerManager(MasterServices master) throws IOException {
                ServerManager sm = super.createServerManager(master);
                ServerManager spy = (ServerManager)Mockito.spy((Object)sm);
                return spy;
            }

            public ClusterConnection getConnection() {
                return mockedConnection;
            }

            public ClusterConnection getClusterConnection() {
                return mockedConnection;
            }
        };
        master.start();
        try {
            while (!master.serviceStarted) {
                Threads.sleep((long)10L);
            }
            for (int i = 0; i < sns.length; ++i) {
                RegionServerStatusProtos.RegionServerReportRequest.Builder request = RegionServerStatusProtos.RegionServerReportRequest.newBuilder();
                ServerName sn = ServerName.parseVersionedServerName((byte[])sns[i].getVersionedBytes());
                request.setServer(ProtobufUtil.toServerName((ServerName)sn));
                request.setLoad(ServerMetricsBuilder.toServerLoad((ServerMetrics)ServerMetricsBuilder.of((ServerName)sn)));
                master.getMasterRpcServices().regionServerReport(null, request.build());
            }
            while (!master.isInitialized()) {
                Threads.sleep((long)100L);
            }
            Assert.assertTrue((boolean)master.isInitialized());
        }
        finally {
            rs0.stop("Test is done");
            rs1.stop("Test is done");
            rs2.stop("Test is done");
            master.stopMaster();
            master.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testNotPullingDeadRegionServerFromZK() throws IOException, KeeperException, InterruptedException {
        Configuration conf = TESTUTIL.getConfiguration();
        final ServerName newServer = ServerName.valueOf((String)"test.sample", (int)1, (long)101L);
        final ServerName deadServer = ServerName.valueOf((String)"test.sample", (int)1, (long)100L);
        final MockRegionServer rs0 = new MockRegionServer(conf, newServer);
        HMaster master = new HMaster(conf){

            MasterMetaBootstrap createMetaBootstrap(HMaster master, MonitoredTask status) {
                return new MasterMetaBootstrap(this, status){

                    protected void assignMeta(int replicaId) {
                    }
                };
            }

            void initClusterSchemaService() throws IOException, InterruptedException {
            }

            void initializeZKBasedSystemTrackers() throws IOException, InterruptedException, KeeperException, CoordinatedStateException {
                super.initializeZKBasedSystemTrackers();
                this.getServerManager().recordNewServerWithLock(newServer, new ServerLoad(ServerMetricsBuilder.of((ServerName)newServer)));
                ArrayList<ServerName> onlineServers = new ArrayList<ServerName>();
                onlineServers.add(deadServer);
                onlineServers.add(newServer);
                this.regionServerTracker = (RegionServerTracker)Mockito.spy((Object)this.regionServerTracker);
                ((RegionServerTracker)Mockito.doReturn(onlineServers).when((Object)this.regionServerTracker)).getOnlineServers();
            }

            public ClusterConnection getConnection() {
                try {
                    return HConnectionTestingUtility.getMockedConnectionAndDecorate(TESTUTIL.getConfiguration(), rs0, rs0, rs0.getServerName(), (RegionInfo)HRegionInfo.FIRST_META_REGIONINFO);
                }
                catch (IOException e) {
                    return null;
                }
            }
        };
        master.start();
        try {
            while (!master.isInitialized()) {
                Threads.sleep((long)10L);
            }
            LOG.info("Master is initialized");
            Assert.assertFalse((String)"The dead server should not be pulled in", (boolean)master.getServerManager().isServerOnline(deadServer));
        }
        finally {
            master.stopMaster();
            master.join();
        }
    }
}

