/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.SnapshotOfRegionAssignmentFromMeta;
import org.apache.hadoop.hbase.master.TestRegionPlacement;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterOperationsForRegionReplicas {
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionPlacement.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Connection CONNECTION = null;
    private static Admin ADMIN;
    private static int numSlaves;
    private static Configuration conf;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        TEST_UTIL.startMiniCluster(numSlaves);
        CONNECTION = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
        ADMIN = CONNECTION.getAdmin();
        while (ADMIN.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().size() < numSlaves) {
            Thread.sleep(100L);
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (ADMIN != null) {
            ADMIN.close();
        }
        if (CONNECTION != null && !CONNECTION.isClosed()) {
            CONNECTION.close();
        }
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithSingleReplica() throws Exception {
        int numRegions = 3;
        boolean numReplica = true;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            HTableDescriptor desc = new HTableDescriptor(tableName);
            desc.setRegionReplication(1);
            desc.addFamily(new HColumnDescriptor("family"));
            ADMIN.createTable((TableDescriptor)desc, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"), 3);
            this.validateNumberOfRowsInMeta(tableName, 3, ADMIN.getConnection());
            List hris = MetaTableAccessor.getTableRegions((Connection)ADMIN.getConnection(), (TableName)tableName);
            assert (hris.size() == 3);
        }
        finally {
            ADMIN.disableTable(tableName);
            ADMIN.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithMultipleReplicas() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        int numRegions = 3;
        int numReplica = 2;
        try {
            HTableDescriptor desc = new HTableDescriptor(tableName);
            desc.setRegionReplication(2);
            desc.addFamily(new HColumnDescriptor("family"));
            ADMIN.createTable((TableDescriptor)desc, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"), 3);
            TEST_UTIL.waitTableEnabled(tableName);
            this.validateNumberOfRowsInMeta(tableName, 3, ADMIN.getConnection());
            List hris = MetaTableAccessor.getTableRegions((Connection)ADMIN.getConnection(), (TableName)tableName);
            assert (hris.size() == 6);
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 2; ++j) {
                    RegionInfo replica = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)((RegionInfo)hris.get(i)), (int)j);
                    RegionState state = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionState(replica);
                    assert (state != null);
                }
            }
            List metaRows = MetaTableAccessor.fullScanRegions((Connection)ADMIN.getConnection());
            int numRows = 0;
            for (Result result : metaRows) {
                RegionLocations locations = MetaTableAccessor.getRegionLocations((Result)result);
                HRegionInfo hri = locations.getRegionLocation().getRegionInfo();
                if (!hri.getTable().equals((Object)tableName)) continue;
                ++numRows;
                HRegionLocation[] servers = locations.getRegionLocations();
                assert (servers.length == 2);
                assert (!servers[0].equals((Object)servers[1]));
            }
            assert (numRows == 3);
            this.validateFromSnapshotFromMeta(TEST_UTIL, tableName, 3, 2, ADMIN.getConnection());
            ServerName master = TEST_UTIL.getHBaseClusterInterface().getClusterMetrics().getMasterName();
            TEST_UTIL.getHBaseClusterInterface().stopMaster(master);
            TEST_UTIL.getHBaseClusterInterface().waitForMasterToStop(master, 30000L);
            TEST_UTIL.getHBaseClusterInterface().startMaster(master.getHostname(), master.getPort());
            TEST_UTIL.getHBaseClusterInterface().waitForActiveAndReadyMaster();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 2; ++j) {
                    RegionInfo replica = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)((RegionInfo)hris.get(i)), (int)j);
                    RegionState state = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionState(replica);
                    assert (state != null);
                }
            }
            this.validateFromSnapshotFromMeta(TEST_UTIL, tableName, 3, 2, ADMIN.getConnection());
            ArrayList<Integer> rsports = new ArrayList<Integer>();
            for (JVMClusterUtil.RegionServerThread rst : TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads()) {
                rsports.add(rst.getRegionServer().getRpcServer().getListenerAddress().getPort());
            }
            TEST_UTIL.shutdownMiniHBaseCluster();
            TEST_UTIL.startMiniHBaseCluster(1, numSlaves, rsports);
            TEST_UTIL.waitTableEnabled(tableName);
            this.validateFromSnapshotFromMeta(TEST_UTIL, tableName, 3, 2, ADMIN.getConnection());
            TEST_UTIL.shutdownMiniHBaseCluster();
            TEST_UTIL.startMiniHBaseCluster(1, 1);
            TEST_UTIL.waitTableEnabled(tableName);
            this.validateSingleRegionServerAssignment(ADMIN.getConnection(), 3, 2);
            for (int i = 1; i < numSlaves; ++i) {
                TEST_UTIL.getMiniHBaseCluster().startRegionServer();
            }
            ADMIN.disableTable(tableName);
            assert (ADMIN.isTableDisabled(tableName));
            desc.setRegionReplication(3);
            ADMIN.modifyTable(tableName, (TableDescriptor)desc);
            ADMIN.enableTable(tableName);
            LOG.info(ADMIN.getTableDescriptor(tableName).toString());
            assert (ADMIN.isTableEnabled(tableName));
            List regions = TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(tableName);
            Assert.assertTrue((String)("regions.size=" + regions.size() + ", numRegions=" + 3 + ", numReplica=" + 2), (regions.size() == 9 ? 1 : 0) != 0);
            ADMIN.disableTable(tableName);
            desc.setRegionReplication(2);
            ADMIN.modifyTable(tableName, (TableDescriptor)desc);
            ADMIN.enableTable(tableName);
            assert (ADMIN.isTableEnabled(tableName));
            regions = TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(tableName);
            assert (regions.size() == 6);
            hris = MetaTableAccessor.getTableRegions((Connection)ADMIN.getConnection(), (TableName)tableName);
            assert (hris.size() == 6);
            HashMap<RegionInfo, Integer> defaultReplicas = new HashMap<RegionInfo, Integer>();
            for (RegionInfo hri : hris) {
                RegionInfo regionReplica0;
                Integer i = (Integer)defaultReplicas.get(regionReplica0 = RegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)hri));
                defaultReplicas.put(regionReplica0, i == null ? 1 : i + 1);
            }
            assert (defaultReplicas.size() == 3);
            HashSet counts = new HashSet(defaultReplicas.values());
            assert (counts.size() == 1 && counts.contains(new Integer(2)));
        }
        finally {
            ADMIN.disableTable(tableName);
            ADMIN.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="Enable when we have support for alter_table- HBASE-10361")
    public void testIncompleteMetaTableReplicaInformation() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        int numRegions = 3;
        int numReplica = 2;
        try {
            HTableDescriptor desc = new HTableDescriptor(tableName);
            desc.setRegionReplication(2);
            desc.addFamily(new HColumnDescriptor("family"));
            ADMIN.createTable((TableDescriptor)desc, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"), 3);
            TEST_UTIL.waitTableEnabled(tableName);
            HashSet<byte[]> tableRows = new HashSet<byte[]>();
            List hris = MetaTableAccessor.getTableRegions((Connection)ADMIN.getConnection(), (TableName)tableName);
            for (Object hri : hris) {
                tableRows.add(hri.getRegionName());
            }
            ADMIN.disableTable(tableName);
            Table metaTable = ADMIN.getConnection().getTable(TableName.META_TABLE_NAME);
            for (byte[] row : tableRows) {
                Delete deleteOneReplicaLocation = new Delete(row);
                deleteOneReplicaLocation.addColumns(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn((int)1));
                deleteOneReplicaLocation.addColumns(HConstants.CATALOG_FAMILY, MetaTableAccessor.getSeqNumColumn((int)1));
                deleteOneReplicaLocation.addColumns(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn((int)1));
                metaTable.delete(deleteOneReplicaLocation);
            }
            metaTable.close();
            ADMIN.enableTable(tableName);
            assert (ADMIN.isTableEnabled(tableName));
            List regions = TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(tableName);
            assert (regions.size() == 6);
        }
        finally {
            ADMIN.disableTable(tableName);
            ADMIN.deleteTable(tableName);
        }
    }

    private String printRegions(List<RegionInfo> regions) {
        StringBuilder strBuf = new StringBuilder();
        for (RegionInfo r : regions) {
            strBuf.append(" ____ " + r.toString());
        }
        return strBuf.toString();
    }

    private void validateNumberOfRowsInMeta(final TableName table, int numRegions, Connection connection) throws IOException {
        assert (ADMIN.tableExists(table));
        final AtomicInteger count = new AtomicInteger();
        MetaTableAccessor.Visitor visitor = new MetaTableAccessor.Visitor(){

            public boolean visit(Result r) throws IOException {
                if (MetaTableAccessor.getRegionInfo((Result)r).getTable().equals((Object)table)) {
                    count.incrementAndGet();
                }
                return true;
            }
        };
        MetaTableAccessor.fullScanRegions((Connection)connection, (MetaTableAccessor.Visitor)visitor);
        assert (count.get() == numRegions);
    }

    private void validateFromSnapshotFromMeta(HBaseTestingUtility util, TableName table, int numRegions, int numReplica, Connection connection) throws IOException {
        SnapshotOfRegionAssignmentFromMeta snapshot = new SnapshotOfRegionAssignmentFromMeta(connection);
        snapshot.initialize();
        Map regionToServerMap = snapshot.getRegionToRegionServerMap();
        assert (regionToServerMap.size() == numRegions * numReplica + 1);
        Map serverToRegionMap = snapshot.getRegionServerToRegionMap();
        for (Map.Entry entry : serverToRegionMap.entrySet()) {
            if (((ServerName)entry.getKey()).equals((Object)util.getHBaseCluster().getMaster().getServerName())) continue;
            List regions = (List)entry.getValue();
            HashSet<byte[]> setOfStartKeys = new HashSet<byte[]>();
            for (RegionInfo region : regions) {
                byte[] startKey = region.getStartKey();
                if (!region.getTable().equals((Object)table)) continue;
                setOfStartKeys.add(startKey);
                LOG.info("--STARTKEY " + new String(startKey) + "--");
            }
            Assert.assertEquals((long)numRegions, (long)setOfStartKeys.size());
        }
    }

    private void validateSingleRegionServerAssignment(Connection connection, int numRegions, int numReplica) throws IOException {
        SnapshotOfRegionAssignmentFromMeta snapshot = new SnapshotOfRegionAssignmentFromMeta(connection);
        snapshot.initialize();
        Map regionToServerMap = snapshot.getRegionToRegionServerMap();
        Assert.assertEquals((long)regionToServerMap.size(), (long)(numRegions * numReplica + 1));
        Map serverToRegionMap = snapshot.getRegionServerToRegionMap();
        Assert.assertEquals((String)"One Region Only", (long)1L, (long)serverToRegionMap.keySet().size());
        for (Map.Entry entry : serverToRegionMap.entrySet()) {
            if (((ServerName)entry.getKey()).equals((Object)TEST_UTIL.getHBaseCluster().getMaster().getServerName())) continue;
            Assert.assertEquals((long)((List)entry.getValue()).size(), (long)(numRegions * numReplica + 1));
        }
    }

    static {
        numSlaves = 2;
    }
}

