/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.SnapshotOfRegionAssignmentFromMeta;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestRestartCluster {
    private static final Logger LOG = LoggerFactory.getLogger(TestRestartCluster.class);
    private HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName[] TABLES = new TableName[]{TableName.valueOf((String)"restartTableOne"), TableName.valueOf((String)"restartTableTwo"), TableName.valueOf((String)"restartTableThree")};
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");

    @After
    public void tearDown() throws Exception {
        this.UTIL.shutdownMiniCluster();
    }

    @Test(timeout=300000L)
    public void testClusterRestart() throws Exception {
        this.UTIL.startMiniCluster(3);
        while (!this.UTIL.getMiniHBaseCluster().getMaster().isInitialized()) {
            Threads.sleep((long)1L);
        }
        LOG.info("\n\nCreating tables");
        for (TableName TABLE : TABLES) {
            this.UTIL.createTable(TABLE, FAMILY);
        }
        for (TableName TABLE : TABLES) {
            this.UTIL.waitTableEnabled(TABLE);
        }
        List allRegions = MetaTableAccessor.getAllRegions((Connection)this.UTIL.getConnection(), (boolean)false);
        Assert.assertEquals((long)4L, (long)allRegions.size());
        LOG.info("\n\nShutting down cluster");
        this.UTIL.shutdownMiniHBaseCluster();
        LOG.info("\n\nSleeping a bit");
        Thread.sleep(2000L);
        LOG.info("\n\nStarting cluster the second time");
        this.UTIL.restartHBaseCluster(3);
        allRegions = MetaTableAccessor.getAllRegions((Connection)this.UTIL.getConnection(), (boolean)false);
        Assert.assertEquals((long)4L, (long)allRegions.size());
        LOG.info("\n\nWaiting for tables to be available");
        for (TableName TABLE : TABLES) {
            try {
                this.UTIL.createTable(TABLE, FAMILY);
                Assert.assertTrue((String)"Able to create table that should already exist", (boolean)false);
            }
            catch (TableExistsException tee) {
                LOG.info("Table already exists as expected");
            }
            this.UTIL.waitTableAvailable(TABLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testRetainAssignmentOnRestart() throws Exception {
        boolean found;
        this.UTIL.startMiniCluster(2);
        while (!this.UTIL.getMiniHBaseCluster().getMaster().isInitialized()) {
            Threads.sleep((long)1L);
        }
        this.UTIL.getMiniHBaseCluster().getMaster().getMasterRpcServices().synchronousBalanceSwitch(false);
        LOG.info("\n\nCreating tables");
        for (TableName TABLE : TABLES) {
            this.UTIL.createTable(TABLE, FAMILY);
        }
        for (TableName TABLE : TABLES) {
            this.UTIL.waitTableEnabled(TABLE);
        }
        HMaster master = this.UTIL.getMiniHBaseCluster().getMaster();
        this.UTIL.waitUntilNoRegionsInTransition(120000L);
        SnapshotOfRegionAssignmentFromMeta snapshot = new SnapshotOfRegionAssignmentFromMeta(master.getConnection());
        snapshot.initialize();
        Map regionToRegionServerMap = snapshot.getRegionToRegionServerMap();
        MiniHBaseCluster cluster = this.UTIL.getHBaseCluster();
        List<JVMClusterUtil.RegionServerThread> threads = cluster.getLiveRegionServerThreads();
        Assert.assertEquals((long)2L, (long)threads.size());
        int[] rsPorts = new int[3];
        for (int i = 0; i < 2; ++i) {
            rsPorts[i] = threads.get(i).getRegionServer().getServerName().getPort();
        }
        rsPorts[2] = cluster.getMaster().getServerName().getPort();
        for (ServerName serverName : regionToRegionServerMap.values()) {
            found = false;
            for (int k = 0; k < 3 && !found; ++k) {
                found = serverName.getPort() == rsPorts[k];
            }
            Assert.assertTrue((boolean)found);
        }
        LOG.info("\n\nShutting down HBase cluster");
        cluster.shutdown();
        cluster.waitUntilShutDown();
        LOG.info("\n\nSleeping a bit");
        Thread.sleep(2000L);
        LOG.info("\n\nStarting cluster the second time with the same ports");
        try {
            cluster.getConf().setInt("hbase.master.wait.on.regionservers.mintostart", 3);
            master = cluster.startMaster().getMaster();
            for (int i = 0; i < 3; ++i) {
                cluster.getConf().setInt("hbase.regionserver.port", rsPorts[i]);
                cluster.startRegionServer();
            }
        }
        finally {
            cluster.getConf().setInt("hbase.regionserver.port", 0);
            cluster.getConf().setInt("hbase.master.wait.on.regionservers.mintostart", 2);
        }
        List localServers = master.getServerManager().getOnlineServersList();
        Assert.assertEquals((long)3L, (long)localServers.size());
        for (int i = 0; i < 3; ++i) {
            found = false;
            for (ServerName serverName : localServers) {
                if (serverName.getPort() != rsPorts[i]) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found);
        }
        RegionStates regionStates = master.getAssignmentManager().getRegionStates();
        int expectedRegions = regionToRegionServerMap.size() + 1;
        while (!master.isInitialized() || regionStates.getRegionAssignments().size() != expectedRegions) {
            Threads.sleep((long)100L);
        }
        snapshot = new SnapshotOfRegionAssignmentFromMeta(master.getConnection());
        snapshot.initialize();
        Map newRegionToRegionServerMap = snapshot.getRegionToRegionServerMap();
        Assert.assertEquals((long)regionToRegionServerMap.size(), (long)newRegionToRegionServerMap.size());
        for (Map.Entry entry : newRegionToRegionServerMap.entrySet()) {
            if (TableName.NAMESPACE_TABLE_NAME.equals((Object)((RegionInfo)entry.getKey()).getTable())) continue;
            ServerName oldServer = (ServerName)regionToRegionServerMap.get(entry.getKey());
            ServerName currentServer = (ServerName)entry.getValue();
            LOG.info("Key=" + entry.getKey() + " oldServer=" + oldServer + ", currentServer=" + currentServer);
            Assert.assertEquals((String)((RegionInfo)entry.getKey()).toString(), (Object)oldServer.getAddress(), (Object)currentServer.getAddress());
            Assert.assertNotEquals((long)oldServer.getStartcode(), (long)currentServer.getStartcode());
        }
    }
}

