/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.namespace.TestNamespaceAuditor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestKVGenerator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSimpleRegionNormalizerOnCluster {
    private static final Logger LOG = LoggerFactory.getLogger(TestSimpleRegionNormalizerOnCluster.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILYNAME = Bytes.toBytes((String)"fam");
    private static Admin admin;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 3);
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.startMiniCluster(1);
        TestNamespaceAuditor.waitForQuotaInitialize(TEST_UTIL);
        admin = TEST_UTIL.getAdmin();
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=90000L)
    public void testRegionNormalizationSplitOnCluster() throws Exception {
        this.testRegionNormalizationSplitOnCluster(false);
        this.testRegionNormalizationSplitOnCluster(true);
    }

    void testRegionNormalizationSplitOnCluster(boolean limitedByQuota) throws Exception {
        TableName TABLENAME;
        if (limitedByQuota) {
            String nsp = "np2";
            NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp).addConfiguration("hbase.namespace.quota.maxregions", "5").addConfiguration("hbase.namespace.quota.maxtables", "2").build();
            admin.createNamespace(nspDesc);
            TABLENAME = TableName.valueOf((String)(nsp + ':' + this.name.getMethodName()));
        } else {
            TABLENAME = TableName.valueOf((String)this.name.getMethodName());
        }
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        try (Table ht = TEST_UTIL.createMultiRegionTable(TABLENAME, FAMILYNAME, 5);){
            List<HRegion> generatedRegions = TEST_UTIL.getHBaseCluster().getRegions(TABLENAME);
            Collections.sort(generatedRegions, Comparator.comparing(HRegion::getRegionInfo, RegionInfo.COMPARATOR));
            HRegion region = generatedRegions.get(0);
            this.generateTestData((Region)region, 1);
            region.flush(true);
            region = generatedRegions.get(1);
            this.generateTestData((Region)region, 1);
            region.flush(true);
            region = generatedRegions.get(2);
            this.generateTestData((Region)region, 2);
            region.flush(true);
            region = generatedRegions.get(3);
            this.generateTestData((Region)region, 2);
            region.flush(true);
            region = generatedRegions.get(4);
            this.generateTestData((Region)region, 5);
            region.flush(true);
        }
        HTableDescriptor htd = new HTableDescriptor(admin.getTableDescriptor(TABLENAME));
        htd.setNormalizationEnabled(true);
        admin.modifyTable(TABLENAME, (TableDescriptor)htd);
        admin.flush(TABLENAME);
        Assert.assertEquals((long)5L, (long)MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)TABLENAME));
        Thread.sleep(5000L);
        m.normalizeRegions();
        if (limitedByQuota) {
            long skippedSplitcnt = 0L;
            do {
                skippedSplitcnt = m.getRegionNormalizer().getSkippedCount(NormalizationPlan.PlanType.SPLIT);
                Thread.sleep(100L);
            } while (skippedSplitcnt == 0L);
            assert (skippedSplitcnt > 0L);
        } else {
            int cnt;
            do {
                List<HRegion> regions = TEST_UTIL.getHBaseCluster().getRegions(TABLENAME);
                cnt = 0;
                for (HRegion region : regions) {
                    String regionName = region.getRegionInfo().getRegionNameAsString();
                    if (!regionName.startsWith("testRegionNormalizationSplitOnCluster,zzzzz")) continue;
                    ++cnt;
                }
            } while (cnt < 2);
        }
        admin.disableTable(TABLENAME);
        admin.deleteTable(TABLENAME);
    }

    @Test(timeout=60000L)
    public void testRegionNormalizationMergeOnCluster() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        try (Table ht = TEST_UTIL.createMultiRegionTable(tableName, FAMILYNAME, 5);){
            List<HRegion> generatedRegions = TEST_UTIL.getHBaseCluster().getRegions(tableName);
            Collections.sort(generatedRegions, Comparator.comparing(HRegion::getRegionInfo, RegionInfo.COMPARATOR));
            HRegion region = generatedRegions.get(0);
            this.generateTestData((Region)region, 1);
            region.flush(true);
            region = generatedRegions.get(1);
            this.generateTestData((Region)region, 1);
            region.flush(true);
            region = generatedRegions.get(2);
            this.generateTestData((Region)region, 3);
            region.flush(true);
            region = generatedRegions.get(3);
            this.generateTestData((Region)region, 3);
            region.flush(true);
            region = generatedRegions.get(4);
            this.generateTestData((Region)region, 5);
            region.flush(true);
        }
        HTableDescriptor htd = new HTableDescriptor(admin.getTableDescriptor(tableName));
        htd.setNormalizationEnabled(true);
        admin.modifyTable(tableName, (TableDescriptor)htd);
        admin.flush(tableName);
        Assert.assertEquals((long)5L, (long)MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)tableName));
        Thread.sleep(5000L);
        m.normalizeRegions();
        while (MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)tableName) > 4) {
            LOG.info("Waiting for normalization merge to complete");
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)4L, (long)MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)tableName));
        admin.disableTable(tableName);
        admin.deleteTable(tableName);
    }

    private void generateTestData(Region region, int numRows) throws IOException {
        LoadTestKVGenerator dataGenerator = new LoadTestKVGenerator(0x100000, 0x100000);
        for (int i = 0; i < numRows; ++i) {
            byte[] key = Bytes.add((byte[])region.getRegionInfo().getStartKey(), (byte[])Bytes.toBytes((int)i));
            for (int j = 0; j < 1; ++j) {
                Put put = new Put(key);
                byte[] col = Bytes.toBytes((String)String.valueOf(j));
                byte[] value = dataGenerator.generateRandomSizeValue((byte[][])new byte[][]{key, col});
                put.addColumn(FAMILYNAME, col, value);
                region.put(put);
            }
        }
    }
}

