/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterMetaBootstrap;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MasterProcedureTestingUtility {
    private static final Logger LOG = LoggerFactory.getLogger(MasterProcedureTestingUtility.class);

    private MasterProcedureTestingUtility() {
    }

    public static void restartMasterProcedureExecutor(ProcedureExecutor<MasterProcedureEnv> procExec) throws Exception {
        final MasterProcedureEnv env = (MasterProcedureEnv)procExec.getEnvironment();
        final HMaster master = (HMaster)env.getMasterServices();
        ProcedureTestingUtility.restart(procExec, (boolean)true, (boolean)true, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AssignmentManager am = env.getAssignmentManager();
                for (RegionState regionState : am.getRegionStates().getRegionStates()) {
                    env.getMasterServices().getServerManager().removeRegion(regionState.getRegion());
                }
                am.stop();
                master.setServerCrashProcessingEnabled(false);
                master.setInitialized(false);
                return null;
            }
        }, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AssignmentManager am = env.getAssignmentManager();
                am.start();
                MasterMetaBootstrap metaBootstrap = new MasterMetaBootstrap(master, TaskMonitor.get().createStatus("meta"));
                metaBootstrap.recoverMeta();
                metaBootstrap.processDeadServers();
                am.joinCluster();
                master.setInitialized(true);
                return null;
            }
        });
    }

    public static void masterFailover(HBaseTestingUtility testUtil) throws Exception {
        MiniHBaseCluster cluster = testUtil.getMiniHBaseCluster();
        HMaster oldMaster = cluster.getMaster();
        cluster.killMaster(cluster.getMaster().getServerName());
        MasterProcedureTestingUtility.waitBackupMaster(testUtil, oldMaster);
    }

    public static void waitBackupMaster(HBaseTestingUtility testUtil, HMaster oldMaster) throws Exception {
        MiniHBaseCluster cluster = testUtil.getMiniHBaseCluster();
        HMaster newMaster = cluster.getMaster();
        while (newMaster == null || newMaster == oldMaster) {
            Thread.sleep(250L);
            newMaster = cluster.getMaster();
        }
        while (!newMaster.isActiveMaster() || !newMaster.isInitialized()) {
            Thread.sleep(250L);
        }
    }

    public static TableDescriptor createHTD(TableName tableName, String ... family) {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        for (int i = 0; i < family.length; ++i) {
            builder.addColumnFamily(ColumnFamilyDescriptorBuilder.of((String)family[i]));
        }
        return builder.build();
    }

    public static RegionInfo[] createTable(ProcedureExecutor<MasterProcedureEnv> procExec, TableName tableName, byte[][] splitKeys, String ... family) throws IOException {
        TableDescriptor htd = MasterProcedureTestingUtility.createHTD(tableName, family);
        RegionInfo[] regions = ModifyRegionUtils.createRegionInfos((TableDescriptor)htd, (byte[][])splitKeys);
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId));
        return regions;
    }

    public static void validateTableCreation(HMaster master, TableName tableName, RegionInfo[] regions, String ... family) throws IOException {
        MasterProcedureTestingUtility.validateTableCreation(master, tableName, regions, true, family);
    }

    public static void validateTableCreation(HMaster master, TableName tableName, RegionInfo[] regions, boolean hasFamilyDirs, String ... family) throws IOException {
        FileSystem fs = master.getMasterFileSystem().getFileSystem();
        Path tableDir = FSUtils.getTableDir((Path)master.getMasterFileSystem().getRootDir(), (TableName)tableName);
        Assert.assertTrue((boolean)fs.exists(tableDir));
        FSUtils.logFileSystemState((FileSystem)fs, (Path)tableDir, (Logger)LOG);
        List unwantedRegionDirs = FSUtils.getRegionDirs((FileSystem)fs, (Path)tableDir);
        for (int i = 0; i < regions.length; ++i) {
            Path regionDir = new Path(tableDir, regions[i].getEncodedName());
            Assert.assertTrue((String)(regions[i] + " region dir does not exist"), (boolean)fs.exists(regionDir));
            Assert.assertTrue((boolean)unwantedRegionDirs.remove(regionDir));
            List allFamilyDirs = FSUtils.getFamilyDirs((FileSystem)fs, (Path)regionDir);
            for (int j = 0; j < family.length; ++j) {
                Path familyDir = new Path(regionDir, family[j]);
                if (hasFamilyDirs) {
                    Assert.assertTrue((String)(family[j] + " family dir does not exist"), (boolean)fs.exists(familyDir));
                    Assert.assertTrue((boolean)allFamilyDirs.remove(familyDir));
                    continue;
                }
                if (!fs.exists(familyDir)) {
                    LOG.warn(family[j] + " family dir does not exist");
                }
                allFamilyDirs.remove(familyDir);
            }
            Assert.assertTrue((String)("found extraneous families: " + allFamilyDirs), (boolean)allFamilyDirs.isEmpty());
        }
        Assert.assertTrue((String)("found extraneous regions: " + unwantedRegionDirs), (boolean)unwantedRegionDirs.isEmpty());
        LOG.debug("Table directory layout is as expected.");
        Assert.assertTrue((boolean)MetaTableAccessor.tableExists((Connection)master.getConnection(), (TableName)tableName));
        Assert.assertEquals((long)regions.length, (long)MasterProcedureTestingUtility.countMetaRegions(master, tableName));
        TableDescriptor htd = master.getTableDescriptors().get(tableName);
        Assert.assertTrue((String)"table descriptor not found", (htd != null ? 1 : 0) != 0);
        for (int i = 0; i < family.length; ++i) {
            Assert.assertTrue((String)("family not found " + family[i]), (htd.getColumnFamily(Bytes.toBytes((String)family[i])) != null ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)family.length, (long)htd.getColumnFamilyCount());
    }

    public static void validateTableDeletion(HMaster master, TableName tableName) throws IOException {
        FileSystem fs = master.getMasterFileSystem().getFileSystem();
        Path tableDir = FSUtils.getTableDir((Path)master.getMasterFileSystem().getRootDir(), (TableName)tableName);
        Assert.assertFalse((boolean)fs.exists(tableDir));
        Assert.assertFalse((boolean)MetaTableAccessor.tableExists((Connection)master.getConnection(), (TableName)tableName));
        Assert.assertEquals((long)0L, (long)MasterProcedureTestingUtility.countMetaRegions(master, tableName));
        Assert.assertTrue((String)"found htd of deleted table", (master.getTableDescriptors().get(tableName) == null ? 1 : 0) != 0);
    }

    private static int countMetaRegions(HMaster master, final TableName tableName) throws IOException {
        final AtomicInteger actualRegCount = new AtomicInteger(0);
        MetaTableAccessor.Visitor visitor = new MetaTableAccessor.Visitor(){

            public boolean visit(Result rowResult) throws IOException {
                HRegionLocation[] locations;
                RegionLocations list = MetaTableAccessor.getRegionLocations((Result)rowResult);
                if (list == null) {
                    LOG.warn("No serialized RegionInfo in " + rowResult);
                    return true;
                }
                HRegionLocation l = list.getRegionLocation();
                if (l == null) {
                    return true;
                }
                if (!l.getRegionInfo().getTable().equals((Object)tableName)) {
                    return false;
                }
                if (l.getRegionInfo().isOffline() || l.getRegionInfo().isSplit()) {
                    return true;
                }
                for (HRegionLocation location : locations = list.getRegionLocations()) {
                    ServerName serverName;
                    if (location == null || (serverName = location.getServerName()) == null || serverName.getHostAndPort() == null) continue;
                    actualRegCount.incrementAndGet();
                }
                return true;
            }
        };
        MetaTableAccessor.scanMetaForTableRegions((Connection)master.getConnection(), (MetaTableAccessor.Visitor)visitor, (TableName)tableName);
        return actualRegCount.get();
    }

    public static void validateTableIsEnabled(HMaster master, TableName tableName) throws IOException {
        TableStateManager tsm = master.getTableStateManager();
        Assert.assertTrue((boolean)tsm.getTableState(tableName).equals((Object)TableState.State.ENABLED));
    }

    public static void validateTableIsDisabled(HMaster master, TableName tableName) throws IOException {
        TableStateManager tsm = master.getTableStateManager();
        Assert.assertTrue((boolean)tsm.getTableState(tableName).equals((Object)TableState.State.DISABLED));
    }

    public static void validateColumnFamilyAddition(HMaster master, TableName tableName, String family) throws IOException {
        TableDescriptor htd = master.getTableDescriptors().get(tableName);
        Assert.assertTrue((htd != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)htd.hasColumnFamily(family.getBytes()));
    }

    public static void validateColumnFamilyDeletion(HMaster master, TableName tableName, String family) throws IOException {
        TableDescriptor htd = master.getTableDescriptors().get(tableName);
        Assert.assertTrue((htd != null ? 1 : 0) != 0);
        Assert.assertFalse((boolean)htd.hasColumnFamily(family.getBytes()));
        FileSystem fs = master.getMasterFileSystem().getFileSystem();
        Path tableDir = FSUtils.getTableDir((Path)master.getMasterFileSystem().getRootDir(), (TableName)tableName);
        for (Path regionDir : FSUtils.getRegionDirs((FileSystem)fs, (Path)tableDir)) {
            Path familyDir = new Path(regionDir, family);
            Assert.assertFalse((String)(family + " family dir should not exist"), (boolean)fs.exists(familyDir));
        }
    }

    public static void validateColumnFamilyModification(HMaster master, TableName tableName, String family, ColumnFamilyDescriptor columnDescriptor) throws IOException {
        TableDescriptor htd = master.getTableDescriptors().get(tableName);
        Assert.assertTrue((htd != null ? 1 : 0) != 0);
        ColumnFamilyDescriptor hcfd = htd.getColumnFamily(family.getBytes());
        Assert.assertEquals((long)0L, (long)ColumnFamilyDescriptor.COMPARATOR.compare(hcfd, columnDescriptor));
    }

    public static void loadData(Connection connection, TableName tableName, int rows, byte[][] splitKeys, String ... sfamilies) throws IOException {
        byte[][] families = new byte[sfamilies.length][];
        for (int i = 0; i < families.length; ++i) {
            families[i] = Bytes.toBytes((String)sfamilies[i]);
        }
        BufferedMutator mutator = connection.getBufferedMutator(tableName);
        Assert.assertTrue((rows >= splitKeys.length ? 1 : 0) != 0);
        for (byte[] k : splitKeys) {
            byte[] value = Bytes.add((byte[])Bytes.toBytes((long)System.currentTimeMillis()), (byte[])k);
            byte[] key = Bytes.add((byte[])k, (byte[])Bytes.toBytes((String)MD5Hash.getMD5AsHex((byte[])value)));
            mutator.mutate((Mutation)MasterProcedureTestingUtility.createPut(families, key, value));
            --rows;
        }
        while (rows-- > 0) {
            byte[] value = Bytes.add((byte[])Bytes.toBytes((long)System.currentTimeMillis()), (byte[])Bytes.toBytes((int)rows));
            byte[] key = Bytes.toBytes((String)MD5Hash.getMD5AsHex((byte[])value));
            mutator.mutate((Mutation)MasterProcedureTestingUtility.createPut(families, key, value));
        }
        mutator.flush();
    }

    private static Put createPut(byte[][] families, byte[] key, byte[] value) {
        byte[] q = Bytes.toBytes((String)"q");
        Put put = new Put(key);
        put.setDurability(Durability.SKIP_WAL);
        for (byte[] family : families) {
            put.addColumn(family, q, value);
        }
        return put;
    }

    public static long generateNonceGroup(HMaster master) {
        return master.getClusterConnection().getNonceGenerator().getNonceGroup();
    }

    public static long generateNonce(HMaster master) {
        return master.getClusterConnection().getNonceGenerator().newNonce();
    }

    public static void testRecoveryAndDoubleExecution(ProcedureExecutor<MasterProcedureEnv> procExec, long procId, int numSteps, boolean expectExecRunning) throws Exception {
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        Assert.assertEquals((Object)false, (Object)procExec.isRunning());
        for (int i = 0; i < numSteps; ++i) {
            LOG.info("Restart " + i + " exec state=" + procExec.getProcedure(procId));
            ProcedureTestingUtility.assertProcNotYetCompleted(procExec, (long)procId);
            MasterProcedureTestingUtility.restartMasterProcedureExecutor(procExec);
            ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        }
        Assert.assertEquals((Object)expectExecRunning, (Object)procExec.isRunning());
    }

    public static void testRecoveryAndDoubleExecution(ProcedureExecutor<MasterProcedureEnv> procExec, long procId) throws Exception {
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        Assert.assertEquals((Object)false, (Object)procExec.isRunning());
        int i = 0;
        while (!procExec.isFinished(procId)) {
            LOG.info("Restart " + i + " exec state=" + procExec.getProcedure(procId));
            MasterProcedureTestingUtility.restartMasterProcedureExecutor(procExec);
            ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
            ++i;
        }
        Assert.assertEquals((Object)true, (Object)procExec.isRunning());
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testRollbackAndDoubleExecution(ProcedureExecutor<MasterProcedureEnv> procExec, long procId, int lastStep) throws Exception {
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, lastStep, false);
        InjectAbortOnLoadListener abortListener = new InjectAbortOnLoadListener(procExec);
        abortListener.addProcId(procId);
        procExec.registerListener((ProcedureExecutor.ProcedureExecutorListener)abortListener);
        try {
            int i = 0;
            while (!procExec.isFinished(procId)) {
                LOG.info("Restart " + i + " rollback state: " + procExec.getProcedure(procId));
                ProcedureTestingUtility.assertProcNotYetCompleted(procExec, (long)procId);
                MasterProcedureTestingUtility.restartMasterProcedureExecutor(procExec);
                ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
                ++i;
            }
        }
        finally {
            Assert.assertTrue((boolean)procExec.unregisterListener((ProcedureExecutor.ProcedureExecutorListener)abortListener));
        }
        Assert.assertEquals((Object)true, (Object)procExec.isRunning());
        ProcedureTestingUtility.assertIsAbortException((Procedure)procExec.getResult(procId));
    }

    public static void testRollbackRetriableFailure(ProcedureExecutor<MasterProcedureEnv> procExec, long procId, int lastStep) throws Exception {
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, lastStep, false);
        MasterProcedureTestingUtility.testRestartWithAbort(procExec, procId);
        Assert.assertEquals((Object)true, (Object)procExec.isRunning());
        ProcedureTestingUtility.assertIsAbortException((Procedure)procExec.getResult(procId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testRestartWithAbort(ProcedureExecutor<MasterProcedureEnv> procExec, long procId) throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        InjectAbortOnLoadListener abortListener = new InjectAbortOnLoadListener(procExec);
        abortListener.addProcId(procId);
        procExec.registerListener((ProcedureExecutor.ProcedureExecutorListener)abortListener);
        try {
            ProcedureTestingUtility.assertProcNotYetCompleted(procExec, (long)procId);
            LOG.info("Restart and rollback procId=" + procId);
            MasterProcedureTestingUtility.restartMasterProcedureExecutor(procExec);
            ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        }
        finally {
            Assert.assertTrue((boolean)procExec.unregisterListener((ProcedureExecutor.ProcedureExecutorListener)abortListener));
        }
    }

    public static class InjectAbortOnLoadListener
    implements ProcedureExecutor.ProcedureExecutorListener {
        private final ProcedureExecutor<MasterProcedureEnv> procExec;
        private TreeSet<Long> procsToAbort = null;

        public InjectAbortOnLoadListener(ProcedureExecutor<MasterProcedureEnv> procExec) {
            this.procExec = procExec;
        }

        public void addProcId(long procId) {
            if (this.procsToAbort == null) {
                this.procsToAbort = new TreeSet();
            }
            this.procsToAbort.add(procId);
        }

        public void procedureLoaded(long procId) {
            if (this.procsToAbort != null && !this.procsToAbort.contains(procId)) {
                return;
            }
            this.procExec.abort(procId);
        }

        public void procedureAdded(long procId) {
        }

        public void procedureFinished(long procId) {
        }
    }
}

