/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.master.procedure.TestCreateTableProcedure;
import org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterProcedureEvents {
    private static final Logger LOG = LoggerFactory.getLogger(TestCreateTableProcedure.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
        conf.setBoolean("hbase.procedure.store.wal.use.hsync", false);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestMasterProcedureEvents.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(2);
        UTIL.waitUntilNoRegionsInTransition();
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @After
    public void tearDown() throws Exception {
        for (HTableDescriptor htd : UTIL.getAdmin().listTables()) {
            LOG.info("Tear down, remove table=" + htd.getTableName());
            UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test(timeout=30000L)
    public void testMasterInitializedEvent() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        ProcedureExecutor procExec = master.getMasterProcedureExecutor();
        HRegionInfo hri = new HRegionInfo(tableName);
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor("f"));
        while (!master.isInitialized()) {
            Thread.sleep(250L);
        }
        master.setInitialized(false);
        this.testProcedureEventWaitWake(master, master.getInitializedEvent(), (Procedure)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)htd, (RegionInfo[])new HRegionInfo[]{hri}));
    }

    @Test(timeout=30000L)
    public void testServerCrashProcedureEvent() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        ProcedureExecutor procExec = master.getMasterProcedureExecutor();
        while (!master.isServerCrashProcessingEnabled() || !master.isInitialized() || master.getAssignmentManager().getRegionStates().hasRegionsInTransition()) {
            Thread.sleep(25L);
        }
        UTIL.createTable(tableName, HBaseTestingUtility.COLUMNS[0]);
        try (Table t = UTIL.getConnection().getTable(tableName);){
            UTIL.loadTable(t, HBaseTestingUtility.COLUMNS[0]);
        }
        master.setServerCrashProcessingEnabled(false);
        HRegionServer hrs = this.getServerWithRegions();
        boolean carryingMeta = master.getAssignmentManager().isCarryingMeta(hrs.getServerName());
        UTIL.getHBaseCluster().killRegionServer(hrs.getServerName());
        hrs.join();
        while (!master.getServerManager().isServerDead(hrs.getServerName())) {
            Thread.sleep(10L);
        }
        master.getServerManager().moveFromOnlineToDeadServers(hrs.getServerName());
        this.testProcedureEventWaitWake(master, master.getServerCrashProcessingEnabledEvent(), (Procedure)new ServerCrashProcedure((MasterProcedureEnv)procExec.getEnvironment(), hrs.getServerName(), true, carryingMeta));
    }

    private void testProcedureEventWaitWake(HMaster master, ProcedureEvent event, Procedure proc) throws Exception {
        ProcedureExecutor procExec = master.getMasterProcedureExecutor();
        MasterProcedureScheduler procSched = ((MasterProcedureEnv)procExec.getEnvironment()).getProcedureScheduler();
        long startPollCalls = procSched.getPollCalls();
        long startNullPollCalls = procSched.getNullPollCalls();
        LOG.debug("checking " + event);
        Assert.assertEquals((Object)false, (Object)event.isReady());
        Assert.assertEquals((long)0L, (long)event.getSuspendedProcedures().size());
        LOG.debug("submit " + proc);
        long procId = procExec.submitProcedure(proc);
        LOG.debug("wait procedure suspended on " + event);
        while (event.getSuspendedProcedures().size() < 1) {
            Thread.sleep(25L);
        }
        LOG.debug("checking " + event + " size=" + event.getSuspendedProcedures().size());
        Assert.assertEquals((Object)false, (Object)event.isReady());
        Assert.assertEquals((long)1L, (long)event.getSuspendedProcedures().size());
        LOG.debug("wake " + event);
        event.wake((AbstractProcedureScheduler)procSched);
        Assert.assertEquals((Object)true, (Object)event.isReady());
        LOG.debug("waiting " + proc);
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)procId);
        Assert.assertEquals((Object)true, (Object)event.isReady());
        Assert.assertEquals((long)0L, (long)event.getSuspendedProcedures().size());
        LOG.debug("completed execution of " + proc + " pollCalls=" + (procSched.getPollCalls() - startPollCalls) + " nullPollCalls=" + (procSched.getNullPollCalls() - startNullPollCalls));
    }

    private HRegionServer getServerWithRegions() {
        for (int i = 0; i < 3; ++i) {
            HRegionServer hrs = UTIL.getHBaseCluster().getRegionServer(i);
            if (hrs.getNumberOfOnlineRegions() <= 0) continue;
            return hrs;
        }
        return null;
    }
}

