/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignmentTestingUtil;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestServerCrashProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(TestServerCrashProcedure.class);
    private HBaseTestingUtility util;
    private ProcedureMetrics serverCrashProcMetrics;
    private long serverCrashSubmittedCount = 0L;
    private long serverCrashFailedCount = 0L;

    private void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
        conf.set("hbase.balancer.tablesOnMaster", "none");
        conf.setInt("hbase.client.retries.number", 3);
    }

    @Before
    public void setup() throws Exception {
        this.util = new HBaseTestingUtility();
        this.setupConf(this.util.getConfiguration());
        this.util.startMiniCluster(3);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate((ProcedureExecutor)this.util.getHBaseCluster().getMaster().getMasterProcedureExecutor(), (boolean)false);
        this.serverCrashProcMetrics = this.util.getHBaseCluster().getMaster().getMasterMetrics().getServerCrashProcMetrics();
    }

    @After
    public void tearDown() throws Exception {
        HMaster master;
        MiniHBaseCluster cluster = this.util.getHBaseCluster();
        HMaster hMaster = master = cluster == null ? null : cluster.getMaster();
        if (master != null && master.getMasterProcedureExecutor() != null) {
            ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate((ProcedureExecutor)master.getMasterProcedureExecutor(), (boolean)false);
        }
        this.util.shutdownMiniCluster();
    }

    @Test(timeout=60000L)
    public void testCrashTargetRs() throws Exception {
        this.testRecoveryAndDoubleExecution(false, false);
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecutionOnRsWithMeta() throws Exception {
        this.testRecoveryAndDoubleExecution(true, true);
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecutionOnRsWithoutMeta() throws Exception {
        this.testRecoveryAndDoubleExecution(false, true);
    }

    private void testRecoveryAndDoubleExecution(boolean carryingMeta, boolean doubleExecution) throws Exception {
        TableName tableName = TableName.valueOf((String)("testRecoveryAndDoubleExecution-carryingMeta-" + carryingMeta));
        try (Table t = this.util.createTable(tableName, HBaseTestingUtility.COLUMNS, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);){
            this.util.loadTable(t, HBaseTestingUtility.COLUMNS[0]);
            int count = this.util.countRows(t);
            Assert.assertTrue((String)"expected some rows", (count > 0 ? 1 : 0) != 0);
            String checksum = this.util.checksumRows(t);
            HMaster master = this.util.getHBaseCluster().getMaster();
            ProcedureExecutor procExec = master.getMasterProcedureExecutor();
            master.setServerCrashProcessingEnabled(false);
            ServerName rsToKill = null;
            for (HRegionInfo hri : this.util.getHBaseAdmin().getTableRegions(tableName)) {
                ServerName serverName = AssignmentTestingUtil.getServerHoldingRegion(this.util, (RegionInfo)hri);
                if (AssignmentTestingUtil.isServerHoldingMeta(this.util, serverName) != carryingMeta) continue;
                rsToKill = serverName;
                break;
            }
            AssignmentTestingUtil.killRs(this.util, rsToKill);
            master.setServerCrashProcessingEnabled(true);
            master.getServerManager().moveFromOnlineToDeadServers(rsToKill);
            ProcedureTestingUtility.waitNoProcedureRunning((ProcedureExecutor)procExec);
            ServerCrashProcedure scp = new ServerCrashProcedure((MasterProcedureEnv)procExec.getEnvironment(), rsToKill, true, carryingMeta);
            if (doubleExecution) {
                ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate((ProcedureExecutor)procExec, (boolean)true);
                long procId = procExec.submitProcedure((Procedure)scp);
                MasterProcedureTestingUtility.testRecoveryAndDoubleExecution((ProcedureExecutor<MasterProcedureEnv>)procExec, procId);
            } else {
                ProcedureTestingUtility.submitAndWait((ProcedureExecutor)procExec, (Procedure)scp);
            }
            Assert.assertEquals((long)count, (long)this.util.countRows(t));
            Assert.assertEquals((Object)checksum, (Object)this.util.checksumRows(t));
        }
    }

    private void collectMasterMetrics() {
        this.serverCrashSubmittedCount = this.serverCrashProcMetrics.getSubmittedCounter().getCount();
        this.serverCrashFailedCount = this.serverCrashProcMetrics.getFailedCounter().getCount();
    }
}

