/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.assignment.AssignProcedure;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestAssignProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(TestAssignProcedure.class);
    @Rule
    public TestName name = new TestName();
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();

    @Test
    public void testTargetServerBeingNulledOnUs() throws ProcedureSuspendedException, IOException {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        RegionInfo ri = RegionInfoBuilder.newBuilder((TableName)tn).build();
        RegionStates.RegionStateNode rsn = new RegionStates.RegionStateNode(ri);
        rsn.setRegionLocation(ServerName.valueOf((String)"server.example.org", (int)0, (long)0L));
        MasterProcedureEnv env = (MasterProcedureEnv)Mockito.mock(MasterProcedureEnv.class);
        AssignmentManager am = (AssignmentManager)Mockito.mock(AssignmentManager.class);
        ServerManager sm = (ServerManager)Mockito.mock(ServerManager.class);
        Mockito.when((Object)sm.isServerOnline((ServerName)Mockito.any())).thenReturn((Object)true);
        MasterServices ms = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)ms.getServerManager()).thenReturn((Object)sm);
        Configuration configuration = HBaseConfiguration.create();
        Mockito.when((Object)ms.getConfiguration()).thenReturn((Object)configuration);
        Mockito.when((Object)env.getAssignmentManager()).thenReturn((Object)am);
        Mockito.when((Object)env.getMasterServices()).thenReturn((Object)ms);
        RSProcedureDispatcher rsd = new RSProcedureDispatcher(ms);
        Mockito.when((Object)env.getRemoteDispatcher()).thenReturn((Object)rsd);
        TargetServerBeingNulledOnUsAssignProcedure assignProcedure = new TargetServerBeingNulledOnUsAssignProcedure(ri, rsn);
        assignProcedure.updateTransition(env, rsn);
        Assert.assertTrue((boolean)assignProcedure.remoteCallFailedWasCalled.get());
        Assert.assertTrue((boolean)assignProcedure.addToRemoteDispatcherWasCalled.get());
    }

    @Test
    public void testSimpleComparator() {
        ArrayList<AssignProcedure> procedures = new ArrayList<AssignProcedure>();
        RegionInfo user1 = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"user_space1")).build();
        procedures.add(new AssignProcedure(user1));
        RegionInfo user2 = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"user_space2")).build();
        procedures.add(new AssignProcedure(RegionInfoBuilder.FIRST_META_REGIONINFO));
        procedures.add(new AssignProcedure(user2));
        RegionInfo system = RegionInfoBuilder.newBuilder((TableName)TableName.NAMESPACE_TABLE_NAME).build();
        procedures.add(new AssignProcedure(system));
        procedures.sort((Comparator<AssignProcedure>)AssignProcedure.COMPARATOR);
        Assert.assertTrue((boolean)((AssignProcedure)procedures.get(0)).isMeta());
        Assert.assertTrue((boolean)((AssignProcedure)procedures.get(1)).getRegionInfo().getTable().equals((Object)TableName.NAMESPACE_TABLE_NAME));
    }

    @Test
    public void testComparatorWithMetas() {
        ArrayList<AssignProcedure> procedures = new ArrayList<AssignProcedure>();
        RegionInfo user3 = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"user3")).build();
        procedures.add(new AssignProcedure(user3));
        RegionInfo system = RegionInfoBuilder.newBuilder((TableName)TableName.NAMESPACE_TABLE_NAME).build();
        procedures.add(new AssignProcedure(system));
        RegionInfo user1 = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"user_space1")).build();
        RegionInfo user2 = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"user_space2")).build();
        procedures.add(new AssignProcedure(user1));
        RegionInfo meta2 = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setStartKey(Bytes.toBytes((String)"002")).build();
        procedures.add(new AssignProcedure(meta2));
        procedures.add(new AssignProcedure(user2));
        RegionInfo meta1 = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setStartKey(Bytes.toBytes((String)"001")).build();
        procedures.add(new AssignProcedure(meta1));
        procedures.add(new AssignProcedure(RegionInfoBuilder.FIRST_META_REGIONINFO));
        RegionInfo meta0 = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setStartKey(Bytes.toBytes((String)"000")).build();
        procedures.add(new AssignProcedure(meta0));
        for (int i = 0; i < 10; ++i) {
            Collections.shuffle(procedures);
            procedures.sort((Comparator<AssignProcedure>)AssignProcedure.COMPARATOR);
            try {
                Assert.assertTrue((boolean)((AssignProcedure)procedures.get(0)).getRegionInfo().equals(RegionInfoBuilder.FIRST_META_REGIONINFO));
                Assert.assertTrue((boolean)((AssignProcedure)procedures.get(1)).getRegionInfo().equals(meta0));
                Assert.assertTrue((boolean)((AssignProcedure)procedures.get(2)).getRegionInfo().equals(meta1));
                Assert.assertTrue((boolean)((AssignProcedure)procedures.get(3)).getRegionInfo().equals(meta2));
                Assert.assertTrue((boolean)((AssignProcedure)procedures.get(4)).getRegionInfo().getTable().equals((Object)TableName.NAMESPACE_TABLE_NAME));
                Assert.assertTrue((boolean)((AssignProcedure)procedures.get(5)).getRegionInfo().equals(user1));
                Assert.assertTrue((boolean)((AssignProcedure)procedures.get(6)).getRegionInfo().equals(user2));
                Assert.assertTrue((boolean)((AssignProcedure)procedures.get(7)).getRegionInfo().equals(user3));
                continue;
            }
            catch (Throwable t) {
                for (AssignProcedure proc : procedures) {
                    LOG.debug(Objects.toString(proc));
                }
                throw t;
            }
        }
    }

    public static class TargetServerBeingNulledOnUsAssignProcedure
    extends AssignProcedure {
        public final AtomicBoolean addToRemoteDispatcherWasCalled = new AtomicBoolean(false);
        public final AtomicBoolean remoteCallFailedWasCalled = new AtomicBoolean(false);
        private final RegionStates.RegionStateNode rsn;

        public TargetServerBeingNulledOnUsAssignProcedure(RegionInfo regionInfo, RegionStates.RegionStateNode rsn) {
            super(regionInfo);
            this.rsn = rsn;
        }

        public boolean updateTransition(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode) throws IOException, ProcedureSuspendedException {
            return super.updateTransition(env, regionNode);
        }

        protected boolean addToRemoteDispatcher(MasterProcedureEnv env, ServerName targetServer) {
            boolean b = super.addToRemoteDispatcher(env, null);
            Assert.assertFalse((boolean)b);
            this.addToRemoteDispatcherWasCalled.set(true);
            return b;
        }

        public RegionStates.RegionStateNode getRegionState(MasterProcedureEnv env) {
            return this.rsn;
        }

        public void remoteCallFailed(MasterProcedureEnv env, ServerName serverName, IOException exception) {
            this.remoteCallFailedWasCalled.set(true);
        }
    }
}

