/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.mob.MobTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMobDataBlockEncoding {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] row1 = Bytes.toBytes((String)"row1");
    private static final byte[] family = Bytes.toBytes((String)"family");
    private static final byte[] qf1 = Bytes.toBytes((String)"qualifier1");
    private static final byte[] qf2 = Bytes.toBytes((String)"qualifier2");
    protected final byte[] qf3 = Bytes.toBytes((String)"qualifier3");
    private static Table table;
    private static Admin admin;
    private static HColumnDescriptor hcd;
    private static HTableDescriptor desc;
    private static Random random;
    private static long defaultThreshold;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    public void setUp(long threshold, String TN, DataBlockEncoding encoding) throws Exception {
        desc = new HTableDescriptor(TableName.valueOf((String)TN));
        hcd = new HColumnDescriptor(family);
        hcd.setMobEnabled(true);
        hcd.setMobThreshold(threshold);
        hcd.setMaxVersions(4);
        hcd.setDataBlockEncoding(encoding);
        desc.addFamily(hcd);
        admin = TEST_UTIL.getAdmin();
        admin.createTable((TableDescriptor)desc);
        table = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration()).getTable(TableName.valueOf((String)TN));
    }

    private static byte[] generateMobValue(int size) {
        byte[] mobVal = new byte[size];
        random.nextBytes(mobVal);
        return mobVal;
    }

    @Test
    public void testDataBlockEncoding() throws Exception {
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            this.testDataBlockEncoding(encoding);
        }
    }

    public void testDataBlockEncoding(DataBlockEncoding encoding) throws Exception {
        String TN = "testDataBlockEncoding" + encoding;
        this.setUp(defaultThreshold, TN, encoding);
        long ts1 = System.currentTimeMillis();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        byte[] value = TestMobDataBlockEncoding.generateMobValue((int)defaultThreshold + 1);
        Put put1 = new Put(row1);
        put1.addColumn(family, qf1, ts3, value);
        put1.addColumn(family, qf2, ts2, value);
        put1.addColumn(family, this.qf3, ts1, value);
        table.put(put1);
        admin.flush(TableName.valueOf((String)TN));
        Scan scan = new Scan();
        scan.setMaxVersions(4);
        MobTestUtil.assertCellsValue(table, scan, value, 3);
    }

    static {
        random = new Random();
        defaultThreshold = 10L;
    }
}

