/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.procedure.MasterProcedureManager;
import org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinatorRpcs;
import org.apache.hadoop.hbase.procedure.ZKProcedureCoordinator;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMasterProcedureManager
extends MasterProcedureManager {
    public static final String SIMPLE_SIGNATURE = "simple_test";
    public static final String SIMPLE_DATA = "simple_test_data";
    private static final Logger LOG = LoggerFactory.getLogger(SimpleMasterProcedureManager.class);
    private MasterServices master;
    private ProcedureCoordinator coordinator;
    private boolean done;

    public void stop(String why) {
        LOG.info("stop: " + why);
    }

    public boolean isStopped() {
        return false;
    }

    public void initialize(MasterServices master, MetricsMaster metricsMaster) throws KeeperException, IOException, UnsupportedOperationException {
        this.master = master;
        this.done = false;
        String name = master.getServerName().toString();
        ThreadPoolExecutor tpool = ProcedureCoordinator.defaultPool((String)name, (int)1);
        ZKProcedureCoordinator comms = new ZKProcedureCoordinator(master.getZooKeeper(), this.getProcedureSignature(), name);
        this.coordinator = new ProcedureCoordinator((ProcedureCoordinatorRpcs)comms, tpool);
    }

    public String getProcedureSignature() {
        return SIMPLE_SIGNATURE;
    }

    public byte[] execProcedureWithRet(HBaseProtos.ProcedureDescription desc) throws IOException {
        this.done = false;
        ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher(desc.getInstance());
        List serverNames = this.master.getServerManager().getOnlineServersList();
        ArrayList<String> servers = new ArrayList<String>();
        for (ServerName sn : serverNames) {
            servers.add(sn.toString());
        }
        Procedure proc = this.coordinator.startProcedure(monitor, desc.getInstance(), new byte[0], servers);
        if (proc == null) {
            String msg = "Failed to submit distributed procedure for '" + this.getProcedureSignature() + "'";
            LOG.error(msg);
            throw new IOException(msg);
        }
        HashMap returnData = null;
        try {
            returnData = proc.waitForCompletedWithRet();
            LOG.info("Done waiting - exec procedure for " + desc.getInstance());
            this.done = true;
        }
        catch (InterruptedException e) {
            ForeignException ee = new ForeignException("Interrupted while waiting for procdure to finish", (Throwable)e);
            monitor.receive(ee);
            Thread.currentThread().interrupt();
        }
        catch (ForeignException e) {
            monitor.receive(e);
        }
        return (byte[])returnData.values().iterator().next();
    }

    public boolean isProcedureDone(HBaseProtos.ProcedureDescription desc) throws IOException {
        return this.done;
    }
}

