/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.procedure.SimpleMasterProcedureManager;
import org.apache.hadoop.hbase.procedure.SimpleRSProcedureManager;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestProcedureManager {
    private static final Logger LOG = LoggerFactory.getLogger(TestProcedureManager.class);
    private static final int NUM_RS = 2;
    private static HBaseTestingUtility util = new HBaseTestingUtility();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = util.getConfiguration();
        conf.set("hbase.procedure.master.classes", SimpleMasterProcedureManager.class.getName());
        conf.set("hbase.procedure.regionserver.classes", SimpleRSProcedureManager.class.getName());
        util.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @Test
    public void testSimpleProcedureManager() throws IOException {
        Admin admin = util.getAdmin();
        byte[] result = admin.execProcedureWithRet("simple_test", "mytest", new HashMap());
        Assert.assertArrayEquals((String)"Incorrect return data from execProcedure", (byte[])"simple_test_data".getBytes(), (byte[])result);
    }
}

