/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.quotas.ActivePolicyEnforcement;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.policies.DefaultViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.policies.MissingSnapshotViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.policies.NoWritesViolationPolicyEnforcement;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestActivePolicyEnforcement {
    private RegionServerServices rss;

    @Before
    public void setup() {
        this.rss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
    }

    @Test
    public void testGetter() {
        TableName tableName = TableName.valueOf((String)"table");
        HashMap<TableName, NoWritesViolationPolicyEnforcement> map = new HashMap<TableName, NoWritesViolationPolicyEnforcement>();
        map.put(tableName, new NoWritesViolationPolicyEnforcement());
        ActivePolicyEnforcement ape = new ActivePolicyEnforcement(map, Collections.emptyMap(), null);
        Assert.assertEquals(map.get(tableName), (Object)ape.getPolicyEnforcement(tableName));
    }

    @Test
    public void testNoPolicyReturnsNoopEnforcement() {
        ActivePolicyEnforcement ape = new ActivePolicyEnforcement(new HashMap(), Collections.emptyMap(), (RegionServerServices)Mockito.mock(RegionServerServices.class));
        SpaceViolationPolicyEnforcement enforcement = ape.getPolicyEnforcement(TableName.valueOf((String)"nonexistent"));
        Assert.assertNotNull((Object)enforcement);
        Assert.assertTrue((String)("Expected an instance of MissingSnapshotViolationPolicyEnforcement, but got " + enforcement.getClass()), (boolean)(enforcement instanceof MissingSnapshotViolationPolicyEnforcement));
    }

    @Test
    public void testNoBulkLoadChecksOnNoSnapshot() {
        ActivePolicyEnforcement ape = new ActivePolicyEnforcement(new HashMap(), Collections.emptyMap(), (RegionServerServices)Mockito.mock(RegionServerServices.class));
        SpaceViolationPolicyEnforcement enforcement = ape.getPolicyEnforcement(TableName.valueOf((String)"nonexistent"));
        Assert.assertFalse((String)"Should not check bulkloads", (boolean)enforcement.shouldCheckBulkLoads());
    }

    @Test
    public void testNoQuotaReturnsSingletonPolicyEnforcement() {
        TableName tableName;
        ActivePolicyEnforcement ape = new ActivePolicyEnforcement(Collections.emptyMap(), Collections.emptyMap(), this.rss);
        SpaceViolationPolicyEnforcement policyEnforcement = ape.getPolicyEnforcement(tableName = TableName.valueOf((String)"my_table"));
        Assert.assertTrue((policyEnforcement == MissingSnapshotViolationPolicyEnforcement.getInstance() ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)ape.getLocallyCachedPolicies().size());
        Map.Entry entry = ape.getLocallyCachedPolicies().entrySet().iterator().next();
        Assert.assertTrue((policyEnforcement == entry.getValue() ? 1 : 0) != 0);
    }

    @Test
    public void testNonViolatingQuotaCachesPolicyEnforcment() {
        HashMap<TableName, SpaceQuotaSnapshot> snapshots = new HashMap<TableName, SpaceQuotaSnapshot>();
        TableName tableName = TableName.valueOf((String)"my_table");
        snapshots.put(tableName, new SpaceQuotaSnapshot(SpaceQuotaSnapshot.SpaceQuotaStatus.notInViolation(), 0L, 1024L));
        ActivePolicyEnforcement ape = new ActivePolicyEnforcement(Collections.emptyMap(), snapshots, this.rss);
        SpaceViolationPolicyEnforcement policyEnforcement = ape.getPolicyEnforcement(tableName);
        Assert.assertTrue((String)("Found the wrong class: " + policyEnforcement.getClass()), (boolean)(policyEnforcement instanceof DefaultViolationPolicyEnforcement));
        SpaceViolationPolicyEnforcement copy = ape.getPolicyEnforcement(tableName);
        Assert.assertTrue((String)"Expected the instance to be cached", (policyEnforcement == copy ? 1 : 0) != 0);
        Map.Entry entry = ape.getLocallyCachedPolicies().entrySet().iterator().next();
        Assert.assertTrue((policyEnforcement == entry.getValue() ? 1 : 0) != 0);
    }

    @Test
    public void testViolatingQuotaCachesNothing() {
        TableName tableName = TableName.valueOf((String)"my_table");
        SpaceViolationPolicyEnforcement policyEnforcement = (SpaceViolationPolicyEnforcement)Mockito.mock(SpaceViolationPolicyEnforcement.class);
        HashMap<TableName, SpaceViolationPolicyEnforcement> activePolicies = new HashMap<TableName, SpaceViolationPolicyEnforcement>();
        activePolicies.put(tableName, policyEnforcement);
        ActivePolicyEnforcement ape = new ActivePolicyEnforcement(activePolicies, Collections.emptyMap(), this.rss);
        Assert.assertTrue((ape.getPolicyEnforcement(tableName) == policyEnforcement ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)ape.getLocallyCachedPolicies().size());
    }
}

