/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.quotas.MasterSpaceQuotaObserver;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestMasterSpaceQuotaObserver {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static SpaceQuotaHelperForTests helper;
    @Rule
    public TestName testName = new TestName();

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void removeAllQuotas() throws Exception {
        Connection conn;
        if (helper == null) {
            helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, new AtomicLong());
        }
        if (!(conn = TEST_UTIL.getConnection()).getAdmin().tableExists(QuotaUtil.QUOTA_TABLE_NAME)) {
            helper.waitForQuotaTable(conn);
        } else {
            helper.removeAllQuotas(conn);
            Assert.assertEquals((long)0L, (long)helper.listNumDefinedQuotas(conn));
        }
    }

    @Test
    public void testTableQuotaRemoved() throws Exception {
        TableName tn;
        Connection conn = TEST_UTIL.getConnection();
        Admin admin = conn.getAdmin();
        if (admin.tableExists(tn = TableName.valueOf((String)this.testName.getMethodName()))) {
            admin.disableTable(tn);
            admin.deleteTable(tn);
        }
        HTableDescriptor tableDesc = new HTableDescriptor(tn);
        tableDesc.addFamily(new HColumnDescriptor("F1"));
        admin.createTable((TableDescriptor)tableDesc);
        Assert.assertEquals((long)0L, (long)this.getNumSpaceQuotas());
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)1024L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        admin.setQuota(settings);
        Assert.assertEquals((long)1L, (long)this.getNumSpaceQuotas());
        admin.disableTable(tn);
        admin.deleteTable(tn);
        Assert.assertEquals((long)0L, (long)this.getNumSpaceQuotas());
    }

    @Test
    public void testNamespaceQuotaRemoved() throws Exception {
        Connection conn = TEST_UTIL.getConnection();
        Admin admin = conn.getAdmin();
        String ns = this.testName.getMethodName();
        if (this.namespaceExists(ns)) {
            admin.deleteNamespace(ns);
        }
        NamespaceDescriptor desc = NamespaceDescriptor.create((String)ns).build();
        admin.createNamespace(desc);
        Assert.assertEquals((long)0L, (long)this.getNumSpaceQuotas());
        QuotaSettings settings = QuotaSettingsFactory.limitNamespaceSpace((String)ns, (long)1024L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        admin.setQuota(settings);
        Assert.assertEquals((long)1L, (long)this.getNumSpaceQuotas());
        admin.deleteNamespace(ns);
        Assert.assertEquals((long)0L, (long)this.getNumSpaceQuotas());
    }

    @Test
    public void testObserverAddedByDefault() throws Exception {
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        MasterCoprocessorHost cpHost = master.getMasterCoprocessorHost();
        Set coprocessorNames = cpHost.getCoprocessors();
        Assert.assertTrue((String)("Did not find MasterSpaceQuotaObserver in list of CPs: " + coprocessorNames), (boolean)coprocessorNames.contains(MasterSpaceQuotaObserver.class.getSimpleName()));
    }

    public boolean namespaceExists(String ns) throws IOException {
        NamespaceDescriptor[] descs;
        for (NamespaceDescriptor desc : descs = TEST_UTIL.getAdmin().listNamespaceDescriptors()) {
            if (!ns.equals(desc.getName())) continue;
            return true;
        }
        return false;
    }

    public int getNumSpaceQuotas() throws Exception {
        QuotaRetriever scanner = QuotaRetriever.open((Configuration)TEST_UTIL.getConfiguration());
        int numSpaceQuotas = 0;
        for (QuotaSettings quotaSettings : scanner) {
            if (quotaSettings.getQuotaType() != QuotaType.SPACE) continue;
            ++numSpaceQuotas;
        }
        return numSpaceQuotas;
    }
}

