/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.quotas.MasterSpaceQuotaObserver;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestMasterSpaceQuotaObserverWithMocks {
    private HMaster master;
    private Configuration conf;

    @Before
    public void setup() {
        this.conf = HBaseConfiguration.create();
        this.master = (HMaster)Mockito.mock(HMaster.class);
        ((HMaster)Mockito.doCallRealMethod().when((Object)this.master)).updateConfigurationForSpaceQuotaObserver((Configuration)Matchers.any());
    }

    @Test
    public void testAddDefaultObserver() {
        this.master.updateConfigurationForSpaceQuotaObserver(this.conf);
        Assert.assertEquals((Object)MasterSpaceQuotaObserver.class.getName(), (Object)this.conf.get("hbase.coprocessor.master.classes"));
    }

    @Test
    public void testDoNotAddDefaultObserver() {
        this.conf.setBoolean("hbase.quota.remove.on.table.delete", false);
        this.master.updateConfigurationForSpaceQuotaObserver(this.conf);
        Assert.assertNull((Object)this.conf.getStrings("hbase.coprocessor.master.classes"));
    }

    @Test
    public void testAppendsObserver() {
        this.conf.set("hbase.coprocessor.master.classes", AccessController.class.getName());
        this.master.updateConfigurationForSpaceQuotaObserver(this.conf);
        HashSet coprocs = new HashSet(this.conf.getStringCollection("hbase.coprocessor.master.classes"));
        Assert.assertEquals((long)2L, (long)coprocs.size());
        Assert.assertTrue((String)("Observed coprocessors were: " + coprocs), (boolean)coprocs.contains(AccessController.class.getName()));
        Assert.assertTrue((String)("Observed coprocessors were: " + coprocs), (boolean)coprocs.contains(MasterSpaceQuotaObserver.class.getName()));
    }
}

