/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.SpaceLimitSettings;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.ThrottleSettings;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, MediumTests.class})
public class TestQuotaAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(TestQuotaAdmin.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.refresh.period", 2000);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
    }

    @After
    public void clearQuotaTable() throws Exception {
        if (TEST_UTIL.getAdmin().tableExists(QuotaUtil.QUOTA_TABLE_NAME)) {
            TEST_UTIL.getAdmin().disableTable(QuotaUtil.QUOTA_TABLE_NAME);
            TEST_UTIL.getAdmin().truncateTable(QuotaUtil.QUOTA_TABLE_NAME, false);
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testThrottleType() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.READ_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.WRITE_NUMBER, (long)12L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.bypassGlobals((String)userName, (boolean)true));
        try (QuotaRetriever scanner = QuotaRetriever.open((Configuration)TEST_UTIL.getConfiguration());){
            int countThrottle = 0;
            int countGlobalBypass = 0;
            block13: for (QuotaSettings settings : scanner) {
                switch (settings.getQuotaType()) {
                    case THROTTLE: {
                        ThrottleSettings throttle = (ThrottleSettings)settings;
                        if (throttle.getSoftLimit() == 6L) {
                            Assert.assertEquals((Object)ThrottleType.READ_NUMBER, (Object)throttle.getThrottleType());
                        } else if (throttle.getSoftLimit() == 12L) {
                            Assert.assertEquals((Object)ThrottleType.WRITE_NUMBER, (Object)throttle.getThrottleType());
                        } else {
                            Assert.fail((String)"should not come here, because don't set quota with this limit");
                        }
                        Assert.assertEquals((Object)userName, (Object)throttle.getUserName());
                        Assert.assertEquals(null, (Object)throttle.getTableName());
                        Assert.assertEquals(null, (Object)throttle.getNamespace());
                        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)throttle.getTimeUnit()));
                        ++countThrottle;
                        continue block13;
                    }
                    case GLOBAL_BYPASS: {
                        ++countGlobalBypass;
                        continue block13;
                    }
                }
                Assert.fail((String)("unexpected settings type: " + settings.getQuotaType()));
            }
            Assert.assertEquals((long)2L, (long)countThrottle);
            Assert.assertEquals((long)1L, (long)countGlobalBypass);
        }
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        this.assertNumResults(1, null);
        admin.setQuota(QuotaSettingsFactory.bypassGlobals((String)userName, (boolean)false));
        this.assertNumResults(0, null);
    }

    @Test
    public void testSimpleScan() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.bypassGlobals((String)userName, (boolean)true));
        try (QuotaRetriever scanner = QuotaRetriever.open((Configuration)TEST_UTIL.getConfiguration());){
            int countThrottle = 0;
            int countGlobalBypass = 0;
            block13: for (QuotaSettings settings : scanner) {
                LOG.debug(Objects.toString(settings));
                switch (settings.getQuotaType()) {
                    case THROTTLE: {
                        ThrottleSettings throttle = (ThrottleSettings)settings;
                        Assert.assertEquals((Object)userName, (Object)throttle.getUserName());
                        Assert.assertEquals(null, (Object)throttle.getTableName());
                        Assert.assertEquals(null, (Object)throttle.getNamespace());
                        Assert.assertEquals((long)6L, (long)throttle.getSoftLimit());
                        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)throttle.getTimeUnit()));
                        ++countThrottle;
                        continue block13;
                    }
                    case GLOBAL_BYPASS: {
                        ++countGlobalBypass;
                        continue block13;
                    }
                }
                Assert.fail((String)("unexpected settings type: " + settings.getQuotaType()));
            }
            Assert.assertEquals((long)1L, (long)countThrottle);
            Assert.assertEquals((long)1L, (long)countGlobalBypass);
        }
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        this.assertNumResults(1, null);
        admin.setQuota(QuotaSettingsFactory.bypassGlobals((String)userName, (boolean)false));
        this.assertNumResults(0, null);
    }

    @Test
    public void testQuotaRetrieverFilter() throws Exception {
        String[] users;
        Admin admin = TEST_UTIL.getAdmin();
        TableName[] tables = new TableName[]{TableName.valueOf((String)"T0"), TableName.valueOf((String)"T01"), TableName.valueOf((String)"NS0:T2")};
        String[] namespaces = new String[]{"NS0", "NS01", "NS2"};
        for (String string : users = new String[]{"User0", "User01", "User2"}) {
            admin.setQuota(QuotaSettingsFactory.throttleUser((String)string, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)1L, (TimeUnit)TimeUnit.MINUTES));
            for (TableName tableName : tables) {
                admin.setQuota(QuotaSettingsFactory.throttleUser((String)string, (TableName)tableName, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)2L, (TimeUnit)TimeUnit.MINUTES));
            }
            for (String string2 : namespaces) {
                admin.setQuota(QuotaSettingsFactory.throttleUser((String)string, (String)string2, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)3L, (TimeUnit)TimeUnit.MINUTES));
            }
        }
        this.assertNumResults(21, null);
        for (String string : tables) {
            admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)string, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)4L, (TimeUnit)TimeUnit.MINUTES));
        }
        this.assertNumResults(24, null);
        for (String string : namespaces) {
            admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)string, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)5L, (TimeUnit)TimeUnit.MINUTES));
        }
        this.assertNumResults(27, null);
        this.assertNumResults(7, new QuotaFilter().setUserFilter("User0"));
        this.assertNumResults(0, new QuotaFilter().setUserFilter("User"));
        this.assertNumResults(21, new QuotaFilter().setUserFilter("User.*"));
        this.assertNumResults(3, new QuotaFilter().setUserFilter("User.*").setTableFilter("T0"));
        this.assertNumResults(3, new QuotaFilter().setUserFilter("User.*").setTableFilter("NS.*"));
        this.assertNumResults(0, new QuotaFilter().setUserFilter("User.*").setTableFilter("T"));
        this.assertNumResults(6, new QuotaFilter().setUserFilter("User.*").setTableFilter("T.*"));
        this.assertNumResults(3, new QuotaFilter().setUserFilter("User.*").setNamespaceFilter("NS0"));
        this.assertNumResults(0, new QuotaFilter().setUserFilter("User.*").setNamespaceFilter("NS"));
        this.assertNumResults(9, new QuotaFilter().setUserFilter("User.*").setNamespaceFilter("NS.*"));
        this.assertNumResults(6, new QuotaFilter().setUserFilter("User.*").setTableFilter("T0").setNamespaceFilter("NS0"));
        this.assertNumResults(1, new QuotaFilter().setTableFilter("T0"));
        this.assertNumResults(0, new QuotaFilter().setTableFilter("T"));
        this.assertNumResults(2, new QuotaFilter().setTableFilter("T.*"));
        this.assertNumResults(3, new QuotaFilter().setTableFilter(".*T.*"));
        this.assertNumResults(1, new QuotaFilter().setNamespaceFilter("NS0"));
        this.assertNumResults(0, new QuotaFilter().setNamespaceFilter("NS"));
        this.assertNumResults(3, new QuotaFilter().setNamespaceFilter("NS.*"));
        for (String string : users) {
            admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)string));
            for (TableName tableName : tables) {
                admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)string, (TableName)tableName));
            }
            for (String string3 : namespaces) {
                admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)string, (String)string3));
            }
        }
        this.assertNumResults(6, null);
        for (String string : tables) {
            admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)string));
        }
        this.assertNumResults(3, null);
        for (String string : namespaces) {
            admin.setQuota(QuotaSettingsFactory.unthrottleNamespace((String)string));
        }
        this.assertNumResults(0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetGetRemoveSpaceQuota() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        TableName tn = TableName.valueOf((String)"sq_table1");
        long sizeLimit = 0x50000000000L;
        SpaceViolationPolicy violationPolicy = SpaceViolationPolicy.NO_WRITES;
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x50000000000L, (SpaceViolationPolicy)violationPolicy);
        admin.setQuota(settings);
        try (Table quotaTable = TEST_UTIL.getConnection().getTable(QuotaTableUtil.QUOTA_TABLE_NAME);
             ResultScanner scanner = quotaTable.getScanner(new Scan());){
            Result r = (Result)Iterables.getOnlyElement((Iterable)scanner);
            CellScanner cells = r.cellScanner();
            Assert.assertTrue((String)"Expected to find a cell", (boolean)cells.advance());
            this.assertSpaceQuota(0x50000000000L, violationPolicy, cells.current());
        }
        try (QuotaRetriever scanner = QuotaRetriever.open((Configuration)admin.getConfiguration());){
            this.assertSpaceQuota(0x50000000000L, violationPolicy, (QuotaSettings)Iterables.getOnlyElement((Iterable)scanner));
        }
        QuotaSettings removeQuota = QuotaSettingsFactory.removeTableSpaceLimit((TableName)tn);
        admin.setQuota(removeQuota);
        try (Table quotaTable = TEST_UTIL.getConnection().getTable(QuotaTableUtil.QUOTA_TABLE_NAME);
             ResultScanner rs = quotaTable.getScanner(new Scan());){
            Assert.assertNull((String)"Did not expect to find a quota entry", (Object)rs.next());
        }
        scanner = QuotaRetriever.open((Configuration)admin.getConfiguration());
        try {
            Assert.assertNull((String)"Did not expect to find a quota entry", (Object)scanner.next());
        }
        finally {
            scanner.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetModifyRemoveQuota() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        TableName tn = TableName.valueOf((String)"sq_table2");
        long originalSizeLimit = 0x50000000000L;
        SpaceViolationPolicy violationPolicy = SpaceViolationPolicy.NO_WRITES;
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x50000000000L, (SpaceViolationPolicy)violationPolicy);
        admin.setQuota(settings);
        try (Table quotaTable = TEST_UTIL.getConnection().getTable(QuotaTableUtil.QUOTA_TABLE_NAME);
             ResultScanner scanner = quotaTable.getScanner(new Scan());){
            Result r = (Result)Iterables.getOnlyElement((Iterable)scanner);
            CellScanner cells = r.cellScanner();
            Assert.assertTrue((String)"Expected to find a cell", (boolean)cells.advance());
            this.assertSpaceQuota(0x50000000000L, violationPolicy, cells.current());
        }
        try (QuotaRetriever quotaScanner = QuotaRetriever.open((Configuration)admin.getConfiguration());){
            this.assertSpaceQuota(0x50000000000L, violationPolicy, (QuotaSettings)Iterables.getOnlyElement((Iterable)quotaScanner));
        }
        long newSizeLimit = 0x10000000000L;
        SpaceViolationPolicy newViolationPolicy = SpaceViolationPolicy.NO_WRITES_COMPACTIONS;
        QuotaSettings newSettings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x10000000000L, (SpaceViolationPolicy)newViolationPolicy);
        admin.setQuota(newSettings);
        try (Table quotaTable = TEST_UTIL.getConnection().getTable(QuotaTableUtil.QUOTA_TABLE_NAME);
             ResultScanner scanner = quotaTable.getScanner(new Scan());){
            Result r = (Result)Iterables.getOnlyElement((Iterable)scanner);
            CellScanner cells = r.cellScanner();
            Assert.assertTrue((String)"Expected to find a cell", (boolean)cells.advance());
            this.assertSpaceQuota(0x10000000000L, newViolationPolicy, cells.current());
        }
        quotaScanner = QuotaRetriever.open((Configuration)admin.getConfiguration());
        try {
            this.assertSpaceQuota(0x10000000000L, newViolationPolicy, (QuotaSettings)Iterables.getOnlyElement((Iterable)quotaScanner));
        }
        finally {
            quotaScanner.close();
        }
        QuotaSettings removeQuota = QuotaSettingsFactory.removeTableSpaceLimit((TableName)tn);
        admin.setQuota(removeQuota);
        try (Table quotaTable = TEST_UTIL.getConnection().getTable(QuotaTableUtil.QUOTA_TABLE_NAME);
             ResultScanner scanner = quotaTable.getScanner(new Scan());){
            Assert.assertNull((String)"Did not expect to find a quota entry", (Object)scanner.next());
        }
        quotaScanner = QuotaRetriever.open((Configuration)admin.getConfiguration());
        try {
            Assert.assertNull((String)"Did not expect to find a quota entry", (Object)quotaScanner.next());
        }
        finally {
            quotaScanner.close();
        }
    }

    private void assertNumResults(int expected, QuotaFilter filter) throws Exception {
        Assert.assertEquals((long)expected, (long)this.countResults(filter));
    }

    private void assertSpaceQuota(long sizeLimit, SpaceViolationPolicy violationPolicy, Cell cell) throws Exception {
        QuotaProtos.Quotas q = QuotaTableUtil.quotasFromData((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
        Assert.assertTrue((String)"Quota should have space quota defined", (boolean)q.hasSpace());
        QuotaProtos.SpaceQuota spaceQuota = q.getSpace();
        Assert.assertEquals((long)sizeLimit, (long)spaceQuota.getSoftLimit());
        Assert.assertEquals((Object)violationPolicy, (Object)ProtobufUtil.toViolationPolicy((QuotaProtos.SpaceViolationPolicy)spaceQuota.getViolationPolicy()));
    }

    private void assertSpaceQuota(long sizeLimit, SpaceViolationPolicy violationPolicy, QuotaSettings actualSettings) {
        Assert.assertTrue((String)("The actual QuotaSettings was not an instance of " + SpaceLimitSettings.class + " but of " + actualSettings.getClass()), (boolean)(actualSettings instanceof SpaceLimitSettings));
        QuotaProtos.SpaceLimitRequest spaceLimitRequest = ((SpaceLimitSettings)actualSettings).getProto();
        Assert.assertEquals((long)sizeLimit, (long)spaceLimitRequest.getQuota().getSoftLimit());
        Assert.assertEquals((Object)violationPolicy, (Object)ProtobufUtil.toViolationPolicy((QuotaProtos.SpaceViolationPolicy)spaceLimitRequest.getQuota().getViolationPolicy()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countResults(QuotaFilter filter) throws Exception {
        try (QuotaRetriever scanner = QuotaRetriever.open((Configuration)TEST_UTIL.getConfiguration(), (QuotaFilter)filter);){
            int count = 0;
            for (QuotaSettings settings : scanner) {
                LOG.debug(Objects.toString(settings));
                ++count;
            }
            int n = count;
            return n;
        }
    }
}

