/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestSuperUserQuotaPermissions {
    private static final Logger LOG = LoggerFactory.getLogger(TestSuperUserQuotaPermissions.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String SUPERUSER_NAME = System.getProperty("user.name");
    private static final UserGroupInformation SUPERUSER_UGI = UserGroupInformation.createUserForTesting((String)SUPERUSER_NAME, (String[])new String[0]);
    private static final String REGULARUSER_NAME = "quota_regularuser";
    private static final UserGroupInformation REGULARUSER_UGI = UserGroupInformation.createUserForTesting((String)"quota_regularuser", (String[])new String[0]);
    private static final AtomicLong COUNTER = new AtomicLong(0L);
    @Rule
    public TestName testName = new TestName();
    private SpaceQuotaHelperForTests helper;

    @BeforeClass
    public static void setupMiniCluster() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        conf.set("hbase.coprocessor.master.classes", AccessController.class.getName());
        conf.set("hbase.coprocessor.region.classes", AccessController.class.getName());
        conf.set("hbase.coprocessor.regionserver.classes", AccessController.class.getName());
        conf.setBoolean("hbase.security.exec.permission.checks", true);
        conf.setBoolean("hbase.security.authorization", true);
        conf.set("hbase.superuser", SUPERUSER_NAME);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void removeAllQuotas() throws Exception {
        Connection conn = TEST_UTIL.getConnection();
        if (this.helper == null) {
            this.helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, COUNTER);
        }
        if (!conn.getAdmin().tableExists(QuotaUtil.QUOTA_TABLE_NAME)) {
            this.helper.waitForQuotaTable(conn);
        } else {
            this.helper.removeAllQuotas(conn);
            Assert.assertEquals((long)0L, (long)this.helper.listNumDefinedQuotas(conn));
        }
    }

    @Test
    public void testSuperUserCanStillCompact() throws Exception {
        final TableName tn = this.doAsSuperUser(new Callable<TableName>(){

            @Override
            public TableName call() throws Exception {
                try (Connection conn = TestSuperUserQuotaPermissions.this.getConnection();){
                    Admin admin = conn.getAdmin();
                    TableName tn = TestSuperUserQuotaPermissions.this.helper.createTableWithRegions(admin, 5);
                    long sizeLimit = 0x200000L;
                    QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x200000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_WRITES_COMPACTIONS);
                    admin.setQuota(settings);
                    try {
                        AccessControlClient.grant((Connection)conn, (TableName)tn, (String)TestSuperUserQuotaPermissions.REGULARUSER_NAME, null, null, (Permission.Action[])new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    }
                    catch (Throwable t) {
                        if (t instanceof Exception) {
                            throw (Exception)t;
                        }
                        throw new Exception(t);
                    }
                    TableName tableName = tn;
                    return tableName;
                }
            }
        });
        this.doAsRegularUser(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection conn = TestSuperUserQuotaPermissions.this.getConnection();){
                    TestSuperUserQuotaPermissions.this.helper.writeData(tn, 0x300000L);
                    Void void_ = null;
                    return void_;
                }
            }
        });
        this.waitForTableToEnterQuotaViolation(tn);
        try {
            this.doAsRegularUser(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try (Connection conn = TestSuperUserQuotaPermissions.this.getConnection();){
                        conn.getAdmin().majorCompact(tn);
                        Void void_ = null;
                        return void_;
                    }
                }
            });
            Assert.fail((String)"Expected an exception trying to compact a table with a quota violation");
        }
        catch (DoNotRetryIOException doNotRetryIOException) {
            // empty catch block
        }
        this.doAsSuperUser(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection conn = TestSuperUserQuotaPermissions.this.getConnection();){
                    conn.getAdmin().majorCompact(tn);
                    Void void_ = null;
                    return void_;
                }
            }
        });
    }

    @Test
    public void testSuperuserCanRemoveQuota() throws Exception {
        final TableName tn = this.doAsSuperUser(new Callable<TableName>(){

            @Override
            public TableName call() throws Exception {
                try (Connection conn = TestSuperUserQuotaPermissions.this.getConnection();){
                    Admin admin = conn.getAdmin();
                    TableName tn = TestSuperUserQuotaPermissions.this.helper.createTableWithRegions(admin, 5);
                    long sizeLimit = 0x200000L;
                    QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x200000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_WRITES_COMPACTIONS);
                    admin.setQuota(settings);
                    try {
                        AccessControlClient.grant((Connection)conn, (TableName)tn, (String)TestSuperUserQuotaPermissions.REGULARUSER_NAME, null, null, (Permission.Action[])new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    }
                    catch (Throwable t) {
                        if (t instanceof Exception) {
                            throw (Exception)t;
                        }
                        throw new Exception(t);
                    }
                    TableName tableName = tn;
                    return tableName;
                }
            }
        });
        this.doAsRegularUser(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection conn = TestSuperUserQuotaPermissions.this.getConnection();){
                    TestSuperUserQuotaPermissions.this.helper.writeData(tn, 0x300000L);
                    Void void_ = null;
                    return void_;
                }
            }
        });
        this.waitForTableToEnterQuotaViolation(tn);
        this.doAsRegularUser(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection conn = TestSuperUserQuotaPermissions.this.getConnection();){
                    Admin admin = conn.getAdmin();
                    QuotaSettings qs = QuotaSettingsFactory.removeTableSpaceLimit((TableName)tn);
                    try {
                        admin.setQuota(qs);
                        Assert.fail((String)"Expected that an unprivileged user should not be allowed to remove a quota");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Void void_ = null;
                    return void_;
                }
            }
        });
        this.doAsSuperUser(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection conn = TestSuperUserQuotaPermissions.this.getConnection();){
                    Admin admin = conn.getAdmin();
                    QuotaSettings qs = QuotaSettingsFactory.removeTableSpaceLimit((TableName)tn);
                    admin.setQuota(qs);
                    Assert.assertNull((Object)TestSuperUserQuotaPermissions.this.helper.getTableSpaceQuota(conn, tn));
                    Void void_ = null;
                    return void_;
                }
            }
        });
    }

    private Connection getConnection() throws IOException {
        return ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
    }

    private <T> T doAsSuperUser(Callable<T> task) throws Exception {
        return this.doAsUser(SUPERUSER_UGI, task);
    }

    private <T> T doAsRegularUser(Callable<T> task) throws Exception {
        return this.doAsUser(REGULARUSER_UGI, task);
    }

    private <T> T doAsUser(UserGroupInformation ugi, final Callable<T> task) throws Exception {
        return (T)ugi.doAs(new PrivilegedExceptionAction<T>(){

            @Override
            public T run() throws Exception {
                return task.call();
            }
        });
    }

    private void waitForTableToEnterQuotaViolation(final TableName tn) throws Exception {
        final HRegionServer rs = TEST_UTIL.getHBaseCluster().getRegionServer(0);
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)30000L, (long)1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                Map snapshots = rs.getRegionServerSpaceQuotaManager().copyQuotaSnapshots();
                SpaceQuotaSnapshot snapshot = (SpaceQuotaSnapshot)snapshots.get(tn);
                if (snapshot == null) {
                    LOG.info("Found no snapshot for " + tn);
                    return false;
                }
                LOG.info("Found snapshot " + snapshot);
                return snapshot.getQuotaStatus().isInViolation();
            }
        });
    }
}

