/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.Arrays;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.TableSpaceQuotaSnapshotNotifier;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestTableSpaceQuotaViolationNotifier {
    private TableSpaceQuotaSnapshotNotifier notifier;
    private Connection conn;

    @Before
    public void setup() throws Exception {
        this.notifier = new TableSpaceQuotaSnapshotNotifier();
        this.conn = (Connection)Mockito.mock(Connection.class);
        this.notifier.initialize(this.conn);
    }

    @Test
    public void testToViolation() throws Exception {
        TableName tn = TableName.valueOf((String)"inviolation");
        SpaceQuotaSnapshot snapshot = new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.NO_INSERTS), 1024L, 512L);
        Table quotaTable = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)this.conn.getTable(QuotaTableUtil.QUOTA_TABLE_NAME)).thenReturn((Object)quotaTable);
        Put expectedPut = new Put(Bytes.toBytes((String)("t." + tn.getNameAsString())));
        QuotaProtos.SpaceQuotaSnapshot protoQuota = QuotaProtos.SpaceQuotaSnapshot.newBuilder().setQuotaStatus(QuotaProtos.SpaceQuotaStatus.newBuilder().setInViolation(true).setViolationPolicy(QuotaProtos.SpaceViolationPolicy.NO_INSERTS)).setQuotaLimit(512L).setQuotaUsage(1024L).build();
        expectedPut.addColumn(Bytes.toBytes((String)"u"), Bytes.toBytes((String)"p"), protoQuota.toByteArray());
        this.notifier.transitionTable(tn, snapshot);
        ((Table)Mockito.verify((Object)quotaTable)).put((Put)Matchers.argThat(new SingleCellMutationMatcher((Mutation)expectedPut)));
    }

    private static final class SingleCellMutationMatcher<T>
    implements ArgumentMatcher<T> {
        private final Mutation expected;

        private SingleCellMutationMatcher(Mutation expected) {
            this.expected = expected;
        }

        public boolean matches(T argument) {
            if (!this.expected.getClass().isAssignableFrom(argument.getClass())) {
                return false;
            }
            Mutation actual = (Mutation)argument;
            if (!Arrays.equals(this.expected.getRow(), actual.getRow())) {
                return false;
            }
            if (this.expected.size() != actual.size()) {
                return false;
            }
            NavigableMap expectedCells = this.expected.getFamilyCellMap();
            NavigableMap actualCells = actual.getFamilyCellMap();
            Map.Entry expectedEntry = expectedCells.entrySet().iterator().next();
            Map.Entry actualEntry = actualCells.entrySet().iterator().next();
            if (!Arrays.equals((byte[])expectedEntry.getKey(), (byte[])actualEntry.getKey())) {
                return false;
            }
            return Objects.equals(expectedEntry.getValue(), actualEntry.getValue());
        }
    }
}

