/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.quotas.QuotaSnapshotStore;
import org.apache.hadoop.hbase.quotas.TableQuotaSnapshotStore;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.common.collect.Multimap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestTablesWithQuotas {
    private Connection conn;
    private Configuration conf;

    @Before
    public void setup() throws Exception {
        this.conn = (Connection)Mockito.mock(Connection.class);
        this.conf = HBaseConfiguration.create();
    }

    @Test
    public void testImmutableGetters() {
        TableName tn;
        int i;
        HashSet<TableName> tablesWithTableQuotas = new HashSet<TableName>();
        HashSet<TableName> tablesWithNamespaceQuotas = new HashSet<TableName>();
        QuotaObserverChore.TablesWithQuotas tables = new QuotaObserverChore.TablesWithQuotas(this.conn, this.conf);
        for (i = 0; i < 5; ++i) {
            tn = TableName.valueOf((String)("tn" + i));
            tablesWithTableQuotas.add(tn);
            tables.addTableQuotaTable(tn);
        }
        for (i = 0; i < 3; ++i) {
            tn = TableName.valueOf((String)("tn_ns" + i));
            tablesWithNamespaceQuotas.add(tn);
            tables.addNamespaceQuotaTable(tn);
        }
        Set actualTableQuotaTables = tables.getTableQuotaTables();
        Set actualNamespaceQuotaTables = tables.getNamespaceQuotaTables();
        Assert.assertEquals(tablesWithTableQuotas, (Object)actualTableQuotaTables);
        Assert.assertEquals(tablesWithNamespaceQuotas, (Object)actualNamespaceQuotaTables);
        try {
            actualTableQuotaTables.add(null);
            Assert.fail((String)"Should not be able to add an element");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            actualNamespaceQuotaTables.add(null);
            Assert.fail((String)"Should not be able to add an element");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testInsufficientlyReportedTableFiltering() throws Exception {
        final HashMap<TableName, Integer> reportedRegions = new HashMap<TableName, Integer>();
        final HashMap<TableName, Integer> actualRegions = new HashMap<TableName, Integer>();
        final Configuration conf = HBaseConfiguration.create();
        conf.setDouble("hbase.master.quotas.observer.report.percent", 0.95);
        TableName tooFewRegionsTable = TableName.valueOf((String)"tn1");
        TableName sufficientRegionsTable = TableName.valueOf((String)"tn2");
        TableName tooFewRegionsNamespaceTable = TableName.valueOf((String)"ns1", (String)"tn2");
        TableName sufficientRegionsNamespaceTable = TableName.valueOf((String)"ns1", (String)"tn2");
        QuotaObserverChore.TablesWithQuotas tables = new QuotaObserverChore.TablesWithQuotas(this.conn, conf){

            Configuration getConfiguration() {
                return conf;
            }

            int getNumRegions(TableName tableName) {
                return (Integer)actualRegions.get(tableName);
            }

            int getNumReportedRegions(TableName table, QuotaSnapshotStore<TableName> tableStore) {
                return (Integer)reportedRegions.get(table);
            }
        };
        tables.addTableQuotaTable(tooFewRegionsTable);
        tables.addTableQuotaTable(sufficientRegionsTable);
        tables.addNamespaceQuotaTable(tooFewRegionsNamespaceTable);
        tables.addNamespaceQuotaTable(sufficientRegionsNamespaceTable);
        reportedRegions.put(tooFewRegionsTable, 5);
        actualRegions.put(tooFewRegionsTable, 10);
        reportedRegions.put(sufficientRegionsTable, 19);
        actualRegions.put(sufficientRegionsTable, 20);
        reportedRegions.put(tooFewRegionsNamespaceTable, 9);
        actualRegions.put(tooFewRegionsNamespaceTable, 10);
        reportedRegions.put(sufficientRegionsNamespaceTable, 98);
        actualRegions.put(sufficientRegionsNamespaceTable, 100);
        tables.filterInsufficientlyReportedTables(null);
        Set filteredTablesWithTableQuotas = tables.getTableQuotaTables();
        Assert.assertEquals(Collections.singleton(sufficientRegionsTable), (Object)filteredTablesWithTableQuotas);
        Set filteredTablesWithNamespaceQutoas = tables.getNamespaceQuotaTables();
        Assert.assertEquals(Collections.singleton(sufficientRegionsNamespaceTable), (Object)filteredTablesWithNamespaceQutoas);
    }

    @Test
    public void testGetTablesByNamespace() {
        QuotaObserverChore.TablesWithQuotas tables = new QuotaObserverChore.TablesWithQuotas(this.conn, this.conf);
        tables.addTableQuotaTable(TableName.valueOf((String)"ignored1"));
        tables.addTableQuotaTable(TableName.valueOf((String)"ignored2"));
        tables.addNamespaceQuotaTable(TableName.valueOf((String)"ns1", (String)"t1"));
        tables.addNamespaceQuotaTable(TableName.valueOf((String)"ns1", (String)"t2"));
        tables.addNamespaceQuotaTable(TableName.valueOf((String)"ns1", (String)"t3"));
        tables.addNamespaceQuotaTable(TableName.valueOf((String)"ns2", (String)"t1"));
        tables.addNamespaceQuotaTable(TableName.valueOf((String)"ns2", (String)"t2"));
        Multimap tablesByNamespace = tables.getTablesByNamespace();
        Collection tablesInNs = tablesByNamespace.get((Object)"ns1");
        Assert.assertEquals((long)3L, (long)tablesInNs.size());
        Assert.assertTrue((String)("Unexpected results for ns1: " + tablesInNs), (boolean)tablesInNs.containsAll(Arrays.asList(TableName.valueOf((String)"ns1", (String)"t1"), TableName.valueOf((String)"ns1", (String)"t2"), TableName.valueOf((String)"ns1", (String)"t3"))));
        tablesInNs = tablesByNamespace.get((Object)"ns2");
        Assert.assertEquals((long)2L, (long)tablesInNs.size());
        Assert.assertTrue((String)("Unexpected results for ns2: " + tablesInNs), (boolean)tablesInNs.containsAll(Arrays.asList(TableName.valueOf((String)"ns2", (String)"t1"), TableName.valueOf((String)"ns2", (String)"t2"))));
    }

    @Test
    public void testFilteringMissingTables() throws Exception {
        TableName missingTable = TableName.valueOf((String)"doesNotExist");
        Admin admin = (Admin)Mockito.mock(Admin.class);
        Mockito.when((Object)this.conn.getAdmin()).thenReturn((Object)admin);
        Mockito.when((Object)admin.getTableRegions(missingTable)).thenReturn(null);
        QuotaObserverChore chore = (QuotaObserverChore)Mockito.mock(QuotaObserverChore.class);
        HashMap regionUsage = new HashMap();
        TableQuotaSnapshotStore store = new TableQuotaSnapshotStore(this.conn, chore, regionUsage);
        QuotaObserverChore.TablesWithQuotas tables = new QuotaObserverChore.TablesWithQuotas(this.conn, this.conf){

            int getNumReportedRegions(TableName table, QuotaSnapshotStore<TableName> tableStore) {
                throw new RuntimeException("Should should not reach here");
            }
        };
        tables.addTableQuotaTable(missingTable);
        tables.filterInsufficientlyReportedTables((QuotaSnapshotStore)store);
        Set tablesWithQuotas = tables.getTableQuotaTables();
        Assert.assertTrue((String)("Expected to find no tables, but found " + tablesWithQuotas), (boolean)tablesWithQuotas.isEmpty());
    }
}

