/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateRandomStoreFile {
    private static final int LEN_VARIATION = 5;
    private static final Logger LOG = LoggerFactory.getLogger(CreateRandomStoreFile.class);
    private static final String OUTPUT_DIR_OPTION = "o";
    private static final String NUM_KV_OPTION = "n";
    private static final String HFILE_VERSION_OPTION = "h";
    private static final String KEY_SIZE_OPTION = "k";
    private static final String VALUE_SIZE_OPTION = "v";
    private static final String COMPRESSION_OPTION = "c";
    private static final String BLOOM_FILTER_OPTION = "bf";
    private static final String BLOCK_SIZE_OPTION = "bs";
    private static final String BLOOM_BLOCK_SIZE_OPTION = "bfbs";
    private static final String INDEX_BLOCK_SIZE_OPTION = "ibs";
    private static final int EXIT_FAILURE = 1;
    private static final int NUM_VALID_KEY_TYPES = KeyValue.Type.values().length - 2;
    private Options options = new Options();
    private int keyPrefixLen;
    private int keyLen;
    private int rowLen;
    private int cfLen;
    private int valueLen;
    private Random rand;

    public boolean run(String[] args) throws IOException {
        CommandLine cmdLine;
        this.options.addOption(OUTPUT_DIR_OPTION, "output_dir", true, "Output directory");
        this.options.addOption(NUM_KV_OPTION, "num_kv", true, "Number of key/value pairs");
        this.options.addOption(KEY_SIZE_OPTION, "key_size", true, "Average key size");
        this.options.addOption(VALUE_SIZE_OPTION, "value_size", true, "Average value size");
        this.options.addOption(HFILE_VERSION_OPTION, "hfile_version", true, "HFile version to create");
        this.options.addOption(COMPRESSION_OPTION, "compression", true, " Compression type, one of " + Arrays.toString(Compression.Algorithm.values()));
        this.options.addOption(BLOOM_FILTER_OPTION, "bloom_filter", true, "Bloom filter type, one of " + Arrays.toString(BloomType.values()));
        this.options.addOption(BLOCK_SIZE_OPTION, "block_size", true, "HFile block size");
        this.options.addOption(BLOOM_BLOCK_SIZE_OPTION, "bloom_block_size", true, "Compound Bloom filters block size");
        this.options.addOption(INDEX_BLOCK_SIZE_OPTION, "index_block_size", true, "Index block size");
        if (args.length == 0) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(CreateRandomStoreFile.class.getSimpleName(), this.options, true);
            return false;
        }
        PosixParser parser = new PosixParser();
        try {
            cmdLine = parser.parse(this.options, args);
        }
        catch (ParseException ex) {
            LOG.error(ex.toString(), (Throwable)ex);
            return false;
        }
        if (!cmdLine.hasOption(OUTPUT_DIR_OPTION)) {
            LOG.error("Output directory is not specified");
            return false;
        }
        if (!cmdLine.hasOption(NUM_KV_OPTION)) {
            LOG.error("The number of keys/values not specified");
            return false;
        }
        if (!cmdLine.hasOption(KEY_SIZE_OPTION)) {
            LOG.error("Key size is not specified");
            return false;
        }
        if (!cmdLine.hasOption(VALUE_SIZE_OPTION)) {
            LOG.error("Value size not specified");
            return false;
        }
        Configuration conf = HBaseConfiguration.create();
        Path outputDir = new Path(cmdLine.getOptionValue(OUTPUT_DIR_OPTION));
        long numKV = Long.parseLong(cmdLine.getOptionValue(NUM_KV_OPTION));
        this.configureKeyValue(numKV, Integer.parseInt(cmdLine.getOptionValue(KEY_SIZE_OPTION)), Integer.parseInt(cmdLine.getOptionValue(VALUE_SIZE_OPTION)));
        FileSystem fs = FileSystem.get((Configuration)conf);
        Compression.Algorithm compr = Compression.Algorithm.NONE;
        if (cmdLine.hasOption(COMPRESSION_OPTION)) {
            compr = Compression.Algorithm.valueOf((String)cmdLine.getOptionValue(COMPRESSION_OPTION));
        }
        BloomType bloomType = BloomType.NONE;
        if (cmdLine.hasOption(BLOOM_FILTER_OPTION)) {
            bloomType = BloomType.valueOf((String)cmdLine.getOptionValue(BLOOM_FILTER_OPTION));
        }
        int blockSize = 65536;
        if (cmdLine.hasOption(BLOCK_SIZE_OPTION)) {
            blockSize = Integer.valueOf(cmdLine.getOptionValue(BLOCK_SIZE_OPTION));
        }
        if (cmdLine.hasOption(BLOOM_BLOCK_SIZE_OPTION)) {
            conf.setInt("io.storefile.bloom.block.size", Integer.valueOf(cmdLine.getOptionValue(BLOOM_BLOCK_SIZE_OPTION)).intValue());
        }
        if (cmdLine.hasOption(INDEX_BLOCK_SIZE_OPTION)) {
            conf.setInt("hfile.index.block.max.size", Integer.valueOf(cmdLine.getOptionValue(INDEX_BLOCK_SIZE_OPTION)).intValue());
        }
        HFileContext meta = new HFileContextBuilder().withCompression(compr).withBlockSize(blockSize).build();
        StoreFileWriter sfw = new StoreFileWriter.Builder(conf, new CacheConfig(conf), fs).withOutputDir(outputDir).withBloomType(bloomType).withMaxKeyCount(numKV).withFileContext(meta).build();
        this.rand = new Random();
        LOG.info("Writing " + numKV + " key/value pairs");
        for (long i = 0L; i < numKV; ++i) {
            sfw.append((Cell)this.generateKeyValue(i));
        }
        int numMetaBlocks = this.rand.nextInt(10) + 1;
        LOG.info("Writing " + numMetaBlocks + " meta blocks");
        for (int metaI = 0; metaI < numMetaBlocks; ++metaI) {
            sfw.getHFileWriter().appendMetaBlock(this.generateString(), (Writable)new BytesWritable(this.generateValue()));
        }
        sfw.close();
        Path storeFilePath = sfw.getPath();
        long fileSize = fs.getFileStatus(storeFilePath).getLen();
        LOG.info("Created " + storeFilePath + ", " + fileSize + " bytes");
        return true;
    }

    private void configureKeyValue(long numKV, int keyLen, int valueLen) {
        numKV = Math.abs(numKV);
        keyLen = Math.abs(keyLen);
        this.keyPrefixLen = 0;
        while (numKV != 0L) {
            numKV >>>= 8;
            ++this.keyPrefixLen;
        }
        this.keyLen = Math.max(this.keyPrefixLen, keyLen);
        this.valueLen = valueLen;
        this.rowLen = this.keyPrefixLen / 3;
        this.cfLen = this.keyPrefixLen / 4;
    }

    private int nextInRange(int range) {
        return this.rand.nextInt(2 * range + 1) - range;
    }

    public KeyValue generateKeyValue(long i) {
        byte[] k = this.generateKey(i);
        byte[] v = this.generateValue();
        return new KeyValue(k, 0, this.rowLen, k, this.rowLen, this.cfLen, k, this.rowLen + this.cfLen, k.length - this.rowLen - this.cfLen, this.rand.nextLong(), CreateRandomStoreFile.generateKeyType(this.rand), v, 0, v.length);
    }

    public static KeyValue.Type generateKeyType(Random rand) {
        if (rand.nextBoolean()) {
            return KeyValue.Type.Put;
        }
        KeyValue.Type keyType = KeyValue.Type.values()[1 + rand.nextInt(NUM_VALID_KEY_TYPES)];
        if (keyType == KeyValue.Type.Minimum || keyType == KeyValue.Type.Maximum) {
            throw new RuntimeException("Generated an invalid key type: " + keyType + ". Probably the layout of KeyValue.Type has changed.");
        }
        return keyType;
    }

    private String generateString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.rand.nextInt(10); ++i) {
            sb.append((char)(65 + this.rand.nextInt(26)));
        }
        return sb.toString();
    }

    private byte[] generateKey(long i) {
        int pos;
        byte[] k = new byte[Math.max(this.keyPrefixLen, this.keyLen + this.nextInRange(5))];
        for (pos = this.keyPrefixLen - 1; pos >= 0; --pos) {
            k[pos] = (byte)(i & 0xFFL);
            i >>>= 8;
        }
        for (pos = this.keyPrefixLen; pos < k.length; ++pos) {
            k[pos] = (byte)this.rand.nextInt(256);
        }
        return k;
    }

    private byte[] generateValue() {
        byte[] v = new byte[Math.max(1, this.valueLen + this.nextInRange(5))];
        for (int i = 0; i < v.length; ++i) {
            v[i] = (byte)this.rand.nextInt(256);
        }
        return v;
    }

    public static void main(String[] args) {
        CreateRandomStoreFile app = new CreateRandomStoreFile();
        try {
            if (!app.run(args)) {
                System.exit(1);
            }
        }
        catch (IOException ex) {
            LOG.error(ex.toString(), (Throwable)ex);
            System.exit(1);
        }
    }
}

