/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestBlocksScanned
extends HBaseTestCase {
    private static byte[] FAMILY = Bytes.toBytes((String)"family");
    private static byte[] COL = Bytes.toBytes((String)"col");
    private static byte[] START_KEY = Bytes.toBytes((String)"aaa");
    private static byte[] END_KEY = Bytes.toBytes((String)"zzz");
    private static int BLOCK_SIZE = 70;
    private static HBaseTestingUtility TEST_UTIL = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        TEST_UTIL = new HBaseTestingUtility();
    }

    @Test
    public void testBlocksScanned() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"TestBlocksScanned");
        HTableDescriptor table = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        table.addFamily(new HColumnDescriptor(FAMILY).setMaxVersions(10).setBlockCacheEnabled(true).setBlocksize(BLOCK_SIZE).setCompressionType(Compression.Algorithm.NONE));
        this._testBlocksScanned(table);
    }

    @Test
    public void testBlocksScannedWithEncoding() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"TestBlocksScannedWithEncoding");
        HTableDescriptor table = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        table.addFamily(new HColumnDescriptor(FAMILY).setMaxVersions(10).setBlockCacheEnabled(true).setDataBlockEncoding(DataBlockEncoding.FAST_DIFF).setBlocksize(BLOCK_SIZE).setCompressionType(Compression.Algorithm.NONE));
        this._testBlocksScanned(table);
    }

    private void _testBlocksScanned(HTableDescriptor table) throws Exception {
        long expectDataBlockRead;
        HRegion r = this.createNewHRegion(table, START_KEY, END_KEY, TEST_UTIL.getConfiguration());
        TestBlocksScanned.addContent((Region)r, FAMILY, COL);
        r.flush(true);
        CacheStats stats = new CacheConfig(TEST_UTIL.getConfiguration()).getBlockCache().getStats();
        long before = stats.getHitCount() + stats.getMissCount();
        Scan scan = new Scan().withStartRow(Bytes.toBytes((String)"aaa")).withStopRow(Bytes.toBytes((String)"aaz")).setReadType(Scan.ReadType.PREAD);
        scan.addColumn(FAMILY, COL);
        scan.setMaxVersions(1);
        HRegion.RegionScannerImpl s = r.getScanner(scan);
        ArrayList results = new ArrayList();
        while (s.next(results)) {
        }
        s.close();
        int expectResultSize = 25;
        TestBlocksScanned.assertEquals((int)expectResultSize, (int)results.size());
        int kvPerBlock = (int)Math.ceil((double)BLOCK_SIZE / (double)KeyValueUtil.ensureKeyValue((Cell)((Cell)results.get(0))).getLength());
        Assert.assertEquals((long)2L, (long)kvPerBlock);
        long expectIndexBlockRead = expectDataBlockRead = (long)Math.ceil((double)expectResultSize / (double)kvPerBlock);
        TestBlocksScanned.assertEquals((long)(expectIndexBlockRead + expectDataBlockRead), (long)(stats.getHitCount() + stats.getMissCount() - before));
    }
}

