/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Iterator;
import java.util.SortedSet;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestCellSkipListSet
extends TestCase {
    private final CellSet csls = new CellSet((CellComparator)CellComparatorImpl.COMPARATOR);

    protected void setUp() throws Exception {
        super.setUp();
        this.csls.clear();
    }

    public void testAdd() throws Exception {
        byte[] bytes = Bytes.toBytes((String)this.getName());
        KeyValue kv = new KeyValue(bytes, bytes, bytes, bytes);
        this.csls.add((Cell)kv);
        TestCellSkipListSet.assertTrue((boolean)this.csls.contains((Object)kv));
        TestCellSkipListSet.assertEquals((int)1, (int)this.csls.size());
        Cell first = this.csls.first();
        TestCellSkipListSet.assertTrue((boolean)kv.equals((Object)first));
        TestCellSkipListSet.assertTrue((boolean)Bytes.equals((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength(), (byte[])first.getValueArray(), (int)first.getValueOffset(), (int)first.getValueLength()));
        byte[] overwriteValue = Bytes.toBytes((String)"overwrite");
        KeyValue overwrite = new KeyValue(bytes, bytes, bytes, overwriteValue);
        this.csls.add((Cell)overwrite);
        TestCellSkipListSet.assertEquals((int)1, (int)this.csls.size());
        first = this.csls.first();
        TestCellSkipListSet.assertTrue((boolean)Bytes.equals((byte[])overwrite.getValueArray(), (int)overwrite.getValueOffset(), (int)overwrite.getValueLength(), (byte[])first.getValueArray(), (int)first.getValueOffset(), (int)first.getValueLength()));
        TestCellSkipListSet.assertFalse((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)overwrite), (byte[])CellUtil.cloneValue((Cell)kv)));
    }

    public void testIterator() throws Exception {
        byte[] bytes = Bytes.toBytes((String)this.getName());
        byte[] value1 = Bytes.toBytes((String)"1");
        byte[] value2 = Bytes.toBytes((String)"2");
        int total = 3;
        for (int i = 0; i < 3; ++i) {
            this.csls.add((Cell)new KeyValue(bytes, bytes, Bytes.toBytes((String)("" + i)), value1));
        }
        int count = 0;
        for (Cell kv : this.csls) {
            TestCellSkipListSet.assertEquals((String)("" + count), (String)Bytes.toString((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength()));
            TestCellSkipListSet.assertTrue((boolean)Bytes.equals((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength(), (byte[])value1, (int)0, (int)value1.length));
            ++count;
        }
        TestCellSkipListSet.assertEquals((int)3, (int)count);
        for (int i = 0; i < 3; ++i) {
            this.csls.add((Cell)new KeyValue(bytes, bytes, Bytes.toBytes((String)("" + i)), value2));
        }
        count = 0;
        for (Cell kv : this.csls) {
            TestCellSkipListSet.assertEquals((String)("" + count), (String)Bytes.toString((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength()));
            TestCellSkipListSet.assertTrue((boolean)Bytes.equals((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength(), (byte[])value2, (int)0, (int)value2.length));
            ++count;
        }
        TestCellSkipListSet.assertEquals((int)3, (int)count);
    }

    public void testDescendingIterator() throws Exception {
        Cell kv;
        byte[] bytes = Bytes.toBytes((String)this.getName());
        byte[] value1 = Bytes.toBytes((String)"1");
        byte[] value2 = Bytes.toBytes((String)"2");
        int total = 3;
        for (int i = 0; i < 3; ++i) {
            this.csls.add((Cell)new KeyValue(bytes, bytes, Bytes.toBytes((String)("" + i)), value1));
        }
        int count = 0;
        Iterator i = this.csls.descendingIterator();
        while (i.hasNext()) {
            kv = (Cell)i.next();
            TestCellSkipListSet.assertEquals((String)("" + (3 - (count + 1))), (String)Bytes.toString((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength()));
            TestCellSkipListSet.assertTrue((boolean)Bytes.equals((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength(), (byte[])value1, (int)0, (int)value1.length));
            ++count;
        }
        TestCellSkipListSet.assertEquals((int)3, (int)count);
        for (int i2 = 0; i2 < 3; ++i2) {
            this.csls.add((Cell)new KeyValue(bytes, bytes, Bytes.toBytes((String)("" + i2)), value2));
        }
        count = 0;
        Iterator i3 = this.csls.descendingIterator();
        while (i3.hasNext()) {
            kv = (Cell)i3.next();
            TestCellSkipListSet.assertEquals((String)("" + (3 - (count + 1))), (String)Bytes.toString((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength()));
            TestCellSkipListSet.assertTrue((boolean)Bytes.equals((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength(), (byte[])value2, (int)0, (int)value2.length));
            ++count;
        }
        TestCellSkipListSet.assertEquals((int)3, (int)count);
    }

    public void testHeadTail() throws Exception {
        byte[] bytes = Bytes.toBytes((String)this.getName());
        byte[] value1 = Bytes.toBytes((String)"1");
        byte[] value2 = Bytes.toBytes((String)"2");
        int total = 3;
        KeyValue splitter = null;
        for (int i = 0; i < 3; ++i) {
            KeyValue kv = new KeyValue(bytes, bytes, Bytes.toBytes((String)("" + i)), value1);
            if (i == 1) {
                splitter = kv;
            }
            this.csls.add((Cell)kv);
        }
        SortedSet tail = this.csls.tailSet(splitter);
        TestCellSkipListSet.assertEquals((int)2, (int)tail.size());
        SortedSet head = this.csls.headSet(splitter);
        TestCellSkipListSet.assertEquals((int)1, (int)head.size());
        for (int i = 0; i < 3; ++i) {
            this.csls.add((Cell)new KeyValue(bytes, bytes, Bytes.toBytes((String)("" + i)), value2));
        }
        tail = this.csls.tailSet((Cell)splitter);
        TestCellSkipListSet.assertTrue((boolean)Bytes.equals((byte[])((Cell)tail.first()).getValueArray(), (int)((Cell)tail.first()).getValueOffset(), (int)((Cell)tail.first()).getValueLength(), (byte[])value2, (int)0, (int)value2.length));
        head = this.csls.headSet((Cell)splitter);
        TestCellSkipListSet.assertTrue((boolean)Bytes.equals((byte[])((Cell)head.first()).getValueArray(), (int)((Cell)head.first()).getValueOffset(), (int)((Cell)head.first()).getValueLength(), (byte[])value2, (int)0, (int)value2.length));
    }
}

