/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestCompactionLifeCycleTracker {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName NAME = TableName.valueOf((String)TestCompactionLifeCycleTracker.class.getSimpleName());
    private static final byte[] CF1 = Bytes.toBytes((String)"CF1");
    private static final byte[] CF2 = Bytes.toBytes((String)"CF2");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"CQ");
    private HRegion region;
    private static CompactionLifeCycleTracker TRACKER = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.getConfiguration().setInt("hbase.hstore.compaction.min", 2);
        UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws IOException {
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)NAME).addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])CF1)).addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])CF2)).addCoprocessor(CompactionObserver.class.getName()).build());
        try (Table table = UTIL.getConnection().getTable(NAME);){
            byte[] row;
            int i;
            for (i = 0; i < 100; ++i) {
                row = Bytes.toBytes((int)i);
                table.put(new Put(row).add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(row).setFamily(CF1).setQualifier(QUALIFIER).setTimestamp(Long.MAX_VALUE).setType(Cell.Type.Put).setValue(Bytes.toBytes((int)i)).build()));
            }
            UTIL.getAdmin().flush(NAME);
            for (i = 100; i < 200; ++i) {
                row = Bytes.toBytes((int)i);
                table.put(new Put(row).add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(row).setFamily(CF1).setQualifier(QUALIFIER).setTimestamp(Long.MAX_VALUE).setType(Cell.Type.Put).setValue(Bytes.toBytes((int)i)).build()));
            }
            UTIL.getAdmin().flush(NAME);
        }
        this.region = UTIL.getHBaseCluster().getRegions(NAME).get(0);
        Assert.assertEquals((long)2L, (long)this.region.getStore(CF1).getStorefilesCount());
        Assert.assertEquals((long)0L, (long)this.region.getStore(CF2).getStorefilesCount());
    }

    @After
    public void tearDown() throws IOException {
        this.region = null;
        TRACKER = null;
        UTIL.deleteTable(NAME);
    }

    @Test
    public void testRequestOnRegion() throws IOException, InterruptedException {
        Tracker tracker = new Tracker();
        TRACKER = tracker;
        this.region.requestCompaction("test", 1, false, (CompactionLifeCycleTracker)tracker);
        tracker.await();
        Assert.assertEquals((long)1L, (long)tracker.notExecutedStores.size());
        Assert.assertEquals((Object)Bytes.toString((byte[])CF2), (Object)((Store)tracker.notExecutedStores.get(0).getFirst()).getColumnFamilyName());
        Assert.assertThat((Object)tracker.notExecutedStores.get(0).getSecond(), (Matcher)CoreMatchers.containsString((String)"compaction request was cancelled"));
        Assert.assertEquals((long)1L, (long)tracker.beforeExecuteStores.size());
        Assert.assertEquals((Object)Bytes.toString((byte[])CF1), (Object)tracker.beforeExecuteStores.get(0).getColumnFamilyName());
        Assert.assertEquals((long)1L, (long)tracker.afterExecuteStores.size());
        Assert.assertEquals((Object)Bytes.toString((byte[])CF1), (Object)tracker.afterExecuteStores.get(0).getColumnFamilyName());
    }

    @Test
    public void testRequestOnStore() throws IOException, InterruptedException {
        Tracker tracker = new Tracker();
        TRACKER = tracker;
        this.region.requestCompaction(CF1, "test", 1, false, (CompactionLifeCycleTracker)tracker);
        tracker.await();
        Assert.assertTrue((boolean)tracker.notExecutedStores.isEmpty());
        Assert.assertEquals((long)1L, (long)tracker.beforeExecuteStores.size());
        Assert.assertEquals((Object)Bytes.toString((byte[])CF1), (Object)tracker.beforeExecuteStores.get(0).getColumnFamilyName());
        Assert.assertEquals((long)1L, (long)tracker.afterExecuteStores.size());
        Assert.assertEquals((Object)Bytes.toString((byte[])CF1), (Object)tracker.afterExecuteStores.get(0).getColumnFamilyName());
        tracker = new Tracker();
        TRACKER = tracker;
        this.region.requestCompaction(CF2, "test", 1, false, (CompactionLifeCycleTracker)tracker);
        tracker.await();
        Assert.assertEquals((long)1L, (long)tracker.notExecutedStores.size());
        Assert.assertEquals((Object)Bytes.toString((byte[])CF2), (Object)((Store)tracker.notExecutedStores.get(0).getFirst()).getColumnFamilyName());
        Assert.assertThat((Object)tracker.notExecutedStores.get(0).getSecond(), (Matcher)CoreMatchers.containsString((String)"compaction request was cancelled"));
        Assert.assertTrue((boolean)tracker.beforeExecuteStores.isEmpty());
        Assert.assertTrue((boolean)tracker.afterExecuteStores.isEmpty());
    }

    @Test
    public void testSpaceQuotaViolation() throws IOException, InterruptedException {
        this.region.getRegionServerServices().getRegionServerSpaceQuotaManager().enforceViolationPolicy(NAME, new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.NO_WRITES_COMPACTIONS), 10L, 100L));
        Tracker tracker = new Tracker();
        TRACKER = tracker;
        this.region.requestCompaction("test", 1, false, (CompactionLifeCycleTracker)tracker);
        tracker.await();
        Assert.assertEquals((long)2L, (long)tracker.notExecutedStores.size());
        tracker.notExecutedStores.sort((p1, p2) -> ((Store)p1.getFirst()).getColumnFamilyName().compareTo(((Store)p2.getFirst()).getColumnFamilyName()));
        Assert.assertEquals((Object)Bytes.toString((byte[])CF1), (Object)((Store)tracker.notExecutedStores.get(0).getFirst()).getColumnFamilyName());
        Assert.assertThat((Object)tracker.notExecutedStores.get(0).getSecond(), (Matcher)CoreMatchers.containsString((String)"space quota violation"));
        Assert.assertEquals((Object)Bytes.toString((byte[])CF2), (Object)((Store)tracker.notExecutedStores.get(1).getFirst()).getColumnFamilyName());
        Assert.assertThat((Object)tracker.notExecutedStores.get(1).getSecond(), (Matcher)CoreMatchers.containsString((String)"space quota violation"));
        Assert.assertTrue((boolean)tracker.beforeExecuteStores.isEmpty());
        Assert.assertTrue((boolean)tracker.afterExecuteStores.isEmpty());
    }

    private static final class Tracker
    implements CompactionLifeCycleTracker {
        final List<Pair<Store, String>> notExecutedStores = new ArrayList<Pair<Store, String>>();
        final List<Store> beforeExecuteStores = new ArrayList<Store>();
        final List<Store> afterExecuteStores = new ArrayList<Store>();
        private boolean completed = false;

        private Tracker() {
        }

        public void notExecuted(Store store, String reason) {
            this.notExecutedStores.add((Pair<Store, String>)Pair.newPair((Object)store, (Object)reason));
        }

        public void beforeExecution(Store store) {
            this.beforeExecuteStores.add(store);
        }

        public void afterExecution(Store store) {
            this.afterExecuteStores.add(store);
        }

        public synchronized void completed() {
            this.completed = true;
            this.notifyAll();
        }

        public synchronized void await() throws InterruptedException {
            while (!this.completed) {
                this.wait();
            }
        }
    }

    public static final class CompactionObserver
    implements RegionObserver,
    RegionCoprocessor {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends StoreFile> candidates, CompactionLifeCycleTracker tracker) throws IOException {
            if (TRACKER != null) {
                Assert.assertSame((Object)tracker, (Object)TRACKER);
            }
        }

        public void postCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends StoreFile> selected, CompactionLifeCycleTracker tracker, CompactionRequest request) {
            if (TRACKER != null) {
                Assert.assertSame((Object)tracker, (Object)TRACKER);
            }
        }

        public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
            if (TRACKER != null) {
                Assert.assertSame((Object)tracker, (Object)TRACKER);
            }
            return scanner;
        }

        public void postCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, StoreFile resultFile, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
            if (TRACKER != null) {
                Assert.assertSame((Object)tracker, (Object)TRACKER);
            }
        }
    }
}

