/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.VerySlowRegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={VerySlowRegionServerTests.class, LargeTests.class})
public class TestCompactionState {
    private static final Logger LOG = LoggerFactory.getLogger(TestCompactionState.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Random random = new Random();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=600000L)
    public void testMajorCompaction() throws IOException, InterruptedException {
        this.compaction(this.name.getMethodName(), 8, CompactionState.MAJOR, false);
    }

    @Test(timeout=600000L)
    public void testMinorCompaction() throws IOException, InterruptedException {
        this.compaction(this.name.getMethodName(), 15, CompactionState.MINOR, false);
    }

    @Test(timeout=600000L)
    public void testMajorCompactionOnFamily() throws IOException, InterruptedException {
        this.compaction(this.name.getMethodName(), 8, CompactionState.MAJOR, true);
    }

    @Test(timeout=600000L)
    public void testMinorCompactionOnFamily() throws IOException, InterruptedException {
        this.compaction(this.name.getMethodName(), 15, CompactionState.MINOR, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidColumnFamily() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] family = Bytes.toBytes((String)"family");
        byte[] fakecf = Bytes.toBytes((String)"fakecf");
        boolean caughtMinorCompact = false;
        boolean caughtMajorCompact = false;
        Table ht = null;
        try {
            ht = TEST_UTIL.createTable(tableName, family);
            Admin admin = TEST_UTIL.getAdmin();
            try {
                admin.compact(tableName, fakecf);
            }
            catch (IOException ioe) {
                caughtMinorCompact = true;
            }
            try {
                admin.majorCompact(tableName, fakecf);
            }
            catch (IOException ioe) {
                caughtMajorCompact = true;
            }
        }
        finally {
            if (ht != null) {
                TEST_UTIL.deleteTable(tableName);
            }
            Assert.assertTrue((boolean)caughtMinorCompact);
            Assert.assertTrue((boolean)caughtMajorCompact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compaction(String tableName, int flushes, CompactionState expectedState, boolean singleFamily) throws IOException, InterruptedException {
        TableName table = TableName.valueOf((String)tableName);
        byte[] family = Bytes.toBytes((String)"family");
        byte[][] families = new byte[][]{family, Bytes.add((byte[])family, (byte[])Bytes.toBytes((String)"2")), Bytes.add((byte[])family, (byte[])Bytes.toBytes((String)"3"))};
        Table ht = null;
        try {
            ht = TEST_UTIL.createTable(table, (byte[][])families);
            TestCompactionState.loadData(ht, families, 3000, flushes);
            HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
            List regions = rs.getRegions(table);
            int countBefore = TestCompactionState.countStoreFilesInFamilies(regions, families);
            int countBeforeSingleFamily = TestCompactionState.countStoreFilesInFamily(regions, family);
            Assert.assertTrue((countBefore > 0 ? 1 : 0) != 0);
            Admin admin = TEST_UTIL.getAdmin();
            if (expectedState == CompactionState.MINOR) {
                if (singleFamily) {
                    admin.compact(table, family);
                } else {
                    admin.compact(table);
                }
            } else if (singleFamily) {
                admin.majorCompact(table, family);
            } else {
                admin.majorCompact(table);
            }
            long curt = System.currentTimeMillis();
            long waitTime = 5000L;
            long endt = curt + waitTime;
            CompactionState state = admin.getCompactionState(table);
            while (state == CompactionState.NONE && curt < endt) {
                Thread.sleep(10L);
                state = admin.getCompactionState(table);
                curt = System.currentTimeMillis();
            }
            if (expectedState != state) {
                for (Region region : regions) {
                    state = CompactionState.valueOf((String)region.getCompactionState().toString());
                    Assert.assertEquals((Object)CompactionState.NONE, (Object)state);
                }
            } else {
                state = admin.getCompactionState(table);
                while (state != CompactionState.NONE && curt < endt) {
                    Thread.sleep(10L);
                    state = admin.getCompactionState(table);
                }
                Assert.assertEquals((Object)CompactionState.NONE, (Object)state);
            }
            int countAfter = TestCompactionState.countStoreFilesInFamilies(regions, families);
            int countAfterSingleFamily = TestCompactionState.countStoreFilesInFamily(regions, family);
            Assert.assertTrue((countAfter < countBefore ? 1 : 0) != 0);
            if (!singleFamily) {
                if (expectedState == CompactionState.MAJOR) {
                    Assert.assertTrue((families.length == countAfter ? 1 : 0) != 0);
                } else {
                    Assert.assertTrue((families.length < countAfter ? 1 : 0) != 0);
                }
            } else {
                int singleFamDiff = countBeforeSingleFamily - countAfterSingleFamily;
                Assert.assertTrue((singleFamDiff == countBefore - countAfter ? 1 : 0) != 0);
                if (expectedState == CompactionState.MAJOR) {
                    Assert.assertTrue((1 == countAfterSingleFamily ? 1 : 0) != 0);
                } else {
                    Assert.assertTrue((1 < countAfterSingleFamily ? 1 : 0) != 0);
                }
            }
        }
        finally {
            if (ht != null) {
                TEST_UTIL.deleteTable(table);
            }
        }
    }

    private static int countStoreFilesInFamily(List<HRegion> regions, byte[] family) {
        return TestCompactionState.countStoreFilesInFamilies(regions, new byte[][]{family});
    }

    private static int countStoreFilesInFamilies(List<HRegion> regions, byte[][] families) {
        int count = 0;
        for (HRegion region : regions) {
            count += region.getStoreFileList(families).size();
        }
        return count;
    }

    private static void loadData(Table ht, byte[][] families, int rows, int flushes) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>(rows);
        byte[] qualifier = Bytes.toBytes((String)"val");
        for (int i = 0; i < flushes; ++i) {
            for (int k = 0; k < rows; ++k) {
                byte[] row = Bytes.toBytes((long)random.nextLong());
                Put p = new Put(row);
                for (int j = 0; j < families.length; ++j) {
                    p.addColumn(families[j], qualifier, row);
                }
                puts.add(p);
            }
            ht.put(puts);
            TEST_UTIL.flush();
            puts.clear();
        }
    }
}

