/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestHRegionOnCluster {
    private static final Logger LOG = LoggerFactory.getLogger(TestHRegionOnCluster.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testDataCorrectnessReplayingRecoveredEdits() throws Exception {
        boolean NUM_MASTERS = true;
        int NUM_RS = 3;
        Admin hbaseAdmin = null;
        TEST_UTIL.startMiniCluster(1, 3);
        try {
            HRegionInfo regionInfo;
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            byte[] FAMILY = Bytes.toBytes((String)"family");
            MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
            HMaster master = cluster.getMaster();
            HTableDescriptor desc = new HTableDescriptor(tableName);
            desc.addFamily(new HColumnDescriptor(FAMILY));
            hbaseAdmin = master.getConnection().getAdmin();
            hbaseAdmin.createTable((TableDescriptor)desc);
            Assert.assertTrue((boolean)hbaseAdmin.isTableAvailable(tableName));
            LOG.info("Loading r1 to v1 into " + tableName);
            Table table = TEST_UTIL.getConnection().getTable(tableName);
            this.putDataAndVerify(table, "r1", FAMILY, "v1", 1);
            TEST_UTIL.waitUntilAllRegionsAssigned(table.getName());
            try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
                regionInfo = locator.getRegionLocation(Bytes.toBytes((String)"r1")).getRegionInfo();
            }
            int originServerNum = cluster.getServerWith(regionInfo.getRegionName());
            HRegionServer originServer = cluster.getRegionServer(originServerNum);
            int targetServerNum = (originServerNum + 1) % 3;
            HRegionServer targetServer = cluster.getRegionServer(targetServerNum);
            Assert.assertFalse((boolean)originServer.equals(targetServer));
            TEST_UTIL.waitUntilAllRegionsAssigned(table.getName());
            LOG.info("Moving " + regionInfo.getEncodedName() + " to " + targetServer.getServerName());
            hbaseAdmin.move(regionInfo.getEncodedNameAsBytes(), Bytes.toBytes((String)targetServer.getServerName().getServerName()));
            do {
                Thread.sleep(1L);
            } while (cluster.getServerWith(regionInfo.getRegionName()) == originServerNum);
            LOG.info("Loading r2 to v2 into " + tableName);
            this.putDataAndVerify(table, "r2", FAMILY, "v2", 2);
            TEST_UTIL.waitUntilAllRegionsAssigned(table.getName());
            LOG.info("Moving " + regionInfo.getEncodedName() + " to " + originServer.getServerName());
            hbaseAdmin.move(regionInfo.getEncodedNameAsBytes(), Bytes.toBytes((String)originServer.getServerName().getServerName()));
            do {
                Thread.sleep(1L);
            } while (cluster.getServerWith(regionInfo.getRegionName()) == targetServerNum);
            LOG.info("Loading r3 to v3 into " + tableName);
            this.putDataAndVerify(table, "r3", FAMILY, "v3", 3);
            LOG.info("Killing target server " + targetServer.getServerName());
            targetServer.kill();
            cluster.getRegionServerThreads().get(targetServerNum).join();
            while (master.getServerManager().areDeadServersInProgress()) {
                Thread.sleep(5L);
            }
            LOG.info("Killing origin server " + targetServer.getServerName());
            originServer.kill();
            cluster.getRegionServerThreads().get(originServerNum).join();
            LOG.info("Loading r4 to v4 into " + tableName);
            this.putDataAndVerify(table, "r4", FAMILY, "v4", 4);
        }
        finally {
            if (hbaseAdmin != null) {
                hbaseAdmin.close();
            }
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    private void putDataAndVerify(Table table, String row, byte[] family, String value, int verifyNum) throws IOException {
        Result r;
        System.out.println("=========Putting data :" + row);
        Put put = new Put(Bytes.toBytes((String)row));
        put.addColumn(family, Bytes.toBytes((String)"q1"), Bytes.toBytes((String)value));
        table.put(put);
        ResultScanner resultScanner = table.getScanner(new Scan());
        ArrayList<Result> results = new ArrayList<Result>();
        while ((r = resultScanner.next()) != null) {
            results.add(r);
        }
        resultScanner.close();
        if (results.size() != verifyNum) {
            System.out.println(results);
        }
        Assert.assertEquals((long)verifyNum, (long)results.size());
    }
}

