/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.CompactedHFilesDischarger;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.TestHRegion;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestHRegionReplayEvents {
    private static final Logger LOG = LoggerFactory.getLogger(TestHRegion.class);
    @Rule
    public TestName name = new TestName();
    private static HBaseTestingUtility TEST_UTIL;
    public static Configuration CONF;
    private String dir;
    private byte[][] families = new byte[][]{Bytes.toBytes((String)"cf1"), Bytes.toBytes((String)"cf2"), Bytes.toBytes((String)"cf3")};
    protected byte[] tableName;
    protected String method;
    protected final byte[] row = Bytes.toBytes((String)"rowA");
    protected final byte[] row2 = Bytes.toBytes((String)"rowB");
    protected byte[] cq = Bytes.toBytes((String)"cq");
    private Path rootDir;
    private TableDescriptor htd;
    private long time;
    private RegionServerServices rss;
    private RegionInfo primaryHri;
    private RegionInfo secondaryHri;
    private HRegion primaryRegion;
    private HRegion secondaryRegion;
    private WALFactory wals;
    private WAL walPrimary;
    private WAL walSecondary;
    private WAL.Reader reader;

    @Before
    public void setup() throws IOException {
        TEST_UTIL = HBaseTestingUtility.createLocalHTU();
        CONF = TEST_UTIL.getConfiguration();
        this.dir = TEST_UTIL.getDataTestDir("TestHRegionReplayEvents").toString();
        this.method = this.name.getMethodName();
        this.tableName = Bytes.toBytes((String)this.name.getMethodName());
        this.rootDir = new Path(this.dir + this.method);
        TEST_UTIL.getConfiguration().set("hbase.rootdir", this.rootDir.toString());
        this.method = this.name.getMethodName();
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.method));
        for (byte[] family : this.families) {
            builder.addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        }
        this.htd = builder.build();
        this.time = System.currentTimeMillis();
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null);
        this.primaryHri = RegionInfoBuilder.newBuilder((TableName)this.htd.getTableName()).setRegionId(this.time).setReplicaId(0).build();
        this.secondaryHri = RegionInfoBuilder.newBuilder((TableName)this.htd.getTableName()).setRegionId(this.time).setReplicaId(1).build();
        this.wals = TestHRegion.createWALFactory(CONF, this.rootDir);
        this.walPrimary = this.wals.getWAL(this.primaryHri);
        this.walSecondary = this.wals.getWAL(this.secondaryHri);
        this.rss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        Mockito.when((Object)this.rss.getServerName()).thenReturn((Object)ServerName.valueOf((String)"foo", (int)1, (long)1L));
        Mockito.when((Object)this.rss.getConfiguration()).thenReturn((Object)CONF);
        Mockito.when((Object)this.rss.getRegionServerAccounting()).thenReturn((Object)new RegionServerAccounting(CONF));
        String string = EventType.RS_COMPACTED_FILES_DISCHARGER.toString();
        ExecutorService es = new ExecutorService(string);
        es.startExecutorService(string + "-" + string, 1);
        Mockito.when((Object)this.rss.getExecutorService()).thenReturn((Object)es);
        this.primaryRegion = HRegion.createHRegion((RegionInfo)this.primaryHri, (Path)this.rootDir, (Configuration)CONF, (TableDescriptor)this.htd, (WAL)this.walPrimary);
        this.primaryRegion.close();
        ArrayList<HRegion> regions = new ArrayList<HRegion>();
        regions.add(this.primaryRegion);
        ((RegionServerServices)Mockito.doReturn(regions).when((Object)this.rss)).getRegions();
        this.primaryRegion = HRegion.openHRegion((Path)this.rootDir, (RegionInfo)this.primaryHri, (TableDescriptor)this.htd, (WAL)this.walPrimary, (Configuration)CONF, (RegionServerServices)this.rss, null);
        this.secondaryRegion = HRegion.openHRegion((RegionInfo)this.secondaryHri, (TableDescriptor)this.htd, null, (Configuration)CONF, (RegionServerServices)this.rss, null);
        this.reader = null;
    }

    @After
    public void tearDown() throws Exception {
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.primaryRegion != null) {
            HBaseTestingUtility.closeRegionAndWAL(this.primaryRegion);
        }
        if (this.secondaryRegion != null) {
            HBaseTestingUtility.closeRegionAndWAL(this.secondaryRegion);
        }
        EnvironmentEdgeManagerTestHelper.reset();
        LOG.info("Cleaning test directory: " + TEST_UTIL.getDataTestDir());
        TEST_UTIL.cleanupTestDir();
    }

    String getName() {
        return this.name.getMethodName();
    }

    @Test
    public void testRegionReplicaSecondaryCannotFlush() throws IOException {
        this.putDataByReplay(this.secondaryRegion, 0, 1000, this.cq, this.families);
        TestHRegion.verifyData(this.secondaryRegion, 0, 1000, this.cq, this.families);
        HRegion.FlushResultImpl flush = (HRegion.FlushResultImpl)this.secondaryRegion.flush(true);
        Assert.assertEquals((Object)flush.result, (Object)HRegion.FlushResult.Result.CANNOT_FLUSH);
        TestHRegion.verifyData(this.secondaryRegion, 0, 1000, this.cq, this.families);
        Map files = this.secondaryRegion.close(false);
        for (List f : files.values()) {
            Assert.assertTrue((boolean)f.isEmpty());
        }
    }

    @Test(timeout=60000L)
    public void testOnlyReplayingFlushStartDoesNotHoldUpRegionClose() throws IOException {
        WAL.Entry entry;
        int start = 0;
        LOG.info("-- Writing some data to primary from " + start + " to " + (start + 100));
        TestHRegion.putData(this.primaryRegion, Durability.SYNC_WAL, start, 100, this.cq, this.families);
        LOG.info("-- Flushing primary, creating 3 files for 3 stores");
        this.primaryRegion.flush(true);
        this.reader = this.createWALReaderForPrimary();
        LOG.info("-- Replaying edits and flush events in secondary");
        while ((entry = this.reader.next()) != null) {
            WALProtos.FlushDescriptor flushDesc = WALEdit.getFlushDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            if (flushDesc != null) {
                if (flushDesc.getAction() == WALProtos.FlushDescriptor.FlushAction.START_FLUSH) {
                    LOG.info("-- Replaying flush start in secondary");
                    this.secondaryRegion.replayWALFlushStartMarker(flushDesc);
                    continue;
                }
                if (flushDesc.getAction() != WALProtos.FlushDescriptor.FlushAction.COMMIT_FLUSH) continue;
                LOG.info("-- NOT Replaying flush commit in secondary");
                continue;
            }
            TestHRegionReplayEvents.replayEdit(this.secondaryRegion, entry);
        }
        Assert.assertTrue((this.rss.getRegionServerAccounting().getGlobalMemStoreDataSize() > 0L ? 1 : 0) != 0);
        this.secondaryRegion.close();
        Assert.assertEquals((long)0L, (long)this.rss.getRegionServerAccounting().getGlobalMemStoreDataSize());
    }

    static int replayEdit(HRegion region, WAL.Entry entry) throws IOException {
        if (WALEdit.isMetaEditFamily((Cell)((Cell)entry.getEdit().getCells().get(0)))) {
            return 0;
        }
        Put put = new Put(CellUtil.cloneRow((Cell)((Cell)entry.getEdit().getCells().get(0))));
        for (Cell cell : entry.getEdit().getCells()) {
            put.add(cell);
        }
        put.setDurability(Durability.SKIP_WAL);
        WALSplitter.MutationReplay mutation = new WALSplitter.MutationReplay(ClientProtos.MutationProto.MutationType.PUT, (Mutation)put, 0L, 0L);
        region.batchReplay(new WALSplitter.MutationReplay[]{mutation}, entry.getKey().getSequenceId());
        return Integer.parseInt(Bytes.toString((byte[])put.getRow()));
    }

    WAL.Reader createWALReaderForPrimary() throws FileNotFoundException, IOException {
        return WALFactory.createReader((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)AbstractFSWALProvider.getCurrentFileName((WAL)this.walPrimary), (Configuration)TEST_UTIL.getConfiguration());
    }

    @Test
    public void testBatchReplayWithMultipleNonces() throws IOException {
        try {
            WALSplitter.MutationReplay[] mutations = new WALSplitter.MutationReplay[100];
            for (int i = 0; i < 100; ++i) {
                Put put = new Put(Bytes.toBytes((int)i));
                put.setDurability(Durability.SYNC_WAL);
                for (byte[] familly : this.families) {
                    put.addColumn(familly, this.cq, null);
                    long nonceNum = i / 10;
                    mutations[i] = new WALSplitter.MutationReplay(ClientProtos.MutationProto.MutationType.PUT, (Mutation)put, nonceNum, nonceNum);
                }
            }
            this.primaryRegion.batchReplay(mutations, 20L);
        }
        catch (Exception e) {
            String msg = "Error while replay of batch with multiple nonces. ";
            LOG.error(msg, (Throwable)e);
            Assert.fail((String)(msg + e.getMessage()));
        }
    }

    @Test
    public void testReplayFlushesAndCompactions() throws IOException {
        WAL.Entry entry;
        this.putDataWithFlushes(this.primaryRegion, 100, 300, 100);
        LOG.info("-- Compacting primary, only 1 store");
        this.primaryRegion.compactStore(Bytes.toBytes((String)"cf1"), (ThroughputController)NoLimitThroughputController.INSTANCE);
        this.reader = this.createWALReaderForPrimary();
        LOG.info("-- Replaying edits and flush events in secondary");
        int lastReplayed = 0;
        int expectedStoreFileCount = 0;
        while ((entry = this.reader.next()) != null) {
            WALProtos.FlushDescriptor flushDesc = WALEdit.getFlushDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            WALProtos.CompactionDescriptor compactionDesc = WALEdit.getCompaction((Cell)((Cell)entry.getEdit().getCells().get(0)));
            if (flushDesc != null) {
                TestHRegion.verifyData(this.secondaryRegion, 0, lastReplayed, this.cq, this.families);
                HStore store = this.secondaryRegion.getStore(Bytes.toBytes((String)"cf1"));
                long storeMemstoreSize = store.getMemStoreSize().getHeapSize();
                long regionMemstoreSize = this.secondaryRegion.getMemStoreSize();
                long storeFlushableSize = store.getFlushableSize().getHeapSize();
                long storeSize = store.getSize();
                long storeSizeUncompressed = store.getStoreSizeUncompressed();
                if (flushDesc.getAction() == WALProtos.FlushDescriptor.FlushAction.START_FLUSH) {
                    LOG.info("-- Replaying flush start in secondary");
                    HRegion.PrepareFlushResult result = this.secondaryRegion.replayWALFlushStartMarker(flushDesc);
                    Assert.assertNull((Object)result.result);
                    Assert.assertEquals((long)result.flushOpSeqId, (long)flushDesc.getFlushSequenceNumber());
                    long newStoreMemstoreSize = store.getMemStoreSize().getHeapSize();
                    LOG.info("Memstore size reduced by:" + StringUtils.humanReadableInt((long)(newStoreMemstoreSize - storeMemstoreSize)));
                    Assert.assertTrue((storeMemstoreSize > newStoreMemstoreSize ? 1 : 0) != 0);
                } else if (flushDesc.getAction() == WALProtos.FlushDescriptor.FlushAction.COMMIT_FLUSH) {
                    LOG.info("-- Replaying flush commit in secondary");
                    this.secondaryRegion.replayWALFlushCommitMarker(flushDesc);
                    ++expectedStoreFileCount;
                    for (HStore s : this.secondaryRegion.getStores()) {
                        Assert.assertEquals((long)expectedStoreFileCount, (long)s.getStorefilesCount());
                    }
                    long newFlushableSize = store.getFlushableSize().getHeapSize();
                    Assert.assertTrue((storeFlushableSize > newFlushableSize ? 1 : 0) != 0);
                    long newRegionMemstoreSize = this.secondaryRegion.getMemStoreSize();
                    Assert.assertTrue((regionMemstoreSize > newRegionMemstoreSize ? 1 : 0) != 0);
                    Assert.assertTrue((store.getSize() > storeSize ? 1 : 0) != 0);
                    Assert.assertTrue((store.getStoreSizeUncompressed() > storeSizeUncompressed ? 1 : 0) != 0);
                    Assert.assertEquals((long)store.getSize(), (long)store.getStorefilesSize());
                }
                TestHRegion.verifyData(this.secondaryRegion, 0, lastReplayed + 1, this.cq, this.families);
                continue;
            }
            if (compactionDesc != null) {
                this.secondaryRegion.replayWALCompactionMarker(compactionDesc, true, false, Long.MAX_VALUE);
                for (HStore store : this.secondaryRegion.getStores()) {
                    if (store.getColumnFamilyName().equals("cf1")) {
                        Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
                        continue;
                    }
                    Assert.assertEquals((long)expectedStoreFileCount, (long)store.getStorefilesCount());
                }
                continue;
            }
            lastReplayed = TestHRegionReplayEvents.replayEdit(this.secondaryRegion, entry);
        }
        Assert.assertEquals((long)399L, (long)lastReplayed);
        LOG.info("-- Verifying edits from secondary");
        TestHRegion.verifyData(this.secondaryRegion, 0, 400, this.cq, this.families);
        LOG.info("-- Verifying edits from primary. Ensuring that files are not deleted");
        TestHRegion.verifyData(this.primaryRegion, 0, lastReplayed, this.cq, this.families);
        for (HStore store : this.primaryRegion.getStores()) {
            if (store.getColumnFamilyName().equals("cf1")) {
                Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
                continue;
            }
            Assert.assertEquals((long)expectedStoreFileCount, (long)store.getStorefilesCount());
        }
    }

    @Test
    public void testReplayFlushStartMarkers() throws IOException {
        WAL.Entry entry;
        this.putDataWithFlushes(this.primaryRegion, 100, 100, 100);
        int numRows = 200;
        this.reader = this.createWALReaderForPrimary();
        LOG.info("-- Replaying edits and flush events in secondary");
        WALProtos.FlushDescriptor startFlushDesc = null;
        int lastReplayed = 0;
        while ((entry = this.reader.next()) != null) {
            WALProtos.FlushDescriptor flushDesc = WALEdit.getFlushDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            if (flushDesc != null) {
                HStore store = this.secondaryRegion.getStore(Bytes.toBytes((String)"cf1"));
                long storeMemstoreSize = store.getMemStoreSize().getHeapSize();
                long regionMemstoreSize = this.secondaryRegion.getMemStoreSize();
                long storeFlushableSize = store.getFlushableSize().getHeapSize();
                if (flushDesc.getAction() == WALProtos.FlushDescriptor.FlushAction.START_FLUSH) {
                    startFlushDesc = flushDesc;
                    LOG.info("-- Replaying flush start in secondary");
                    HRegion.PrepareFlushResult result = this.secondaryRegion.replayWALFlushStartMarker(startFlushDesc);
                    Assert.assertNull((Object)result.result);
                    Assert.assertEquals((long)result.flushOpSeqId, (long)startFlushDesc.getFlushSequenceNumber());
                    Assert.assertTrue((regionMemstoreSize > 0L ? 1 : 0) != 0);
                    Assert.assertTrue((storeFlushableSize > 0L ? 1 : 0) != 0);
                    long newStoreMemstoreSize = store.getMemStoreSize().getHeapSize();
                    LOG.info("Memstore size reduced by:" + StringUtils.humanReadableInt((long)(newStoreMemstoreSize - storeMemstoreSize)));
                    Assert.assertTrue((storeMemstoreSize > newStoreMemstoreSize ? 1 : 0) != 0);
                    TestHRegion.verifyData(this.secondaryRegion, 0, lastReplayed + 1, this.cq, this.families);
                }
                TestHRegion.verifyData(this.secondaryRegion, 0, lastReplayed + 1, this.cq, this.families);
                continue;
            }
            lastReplayed = TestHRegionReplayEvents.replayEdit(this.secondaryRegion, entry);
        }
        TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
        LOG.info("-- Replaying same flush start in secondary again");
        HRegion.PrepareFlushResult result = this.secondaryRegion.replayWALFlushStartMarker(startFlushDesc);
        Assert.assertNull((Object)result);
        Assert.assertNotNull((Object)this.secondaryRegion.getPrepareFlushResult());
        Assert.assertEquals((long)this.secondaryRegion.getPrepareFlushResult().flushOpSeqId, (long)startFlushDesc.getFlushSequenceNumber());
        Assert.assertTrue((this.secondaryRegion.getMemStoreSize() > 0L ? 1 : 0) != 0);
        TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
        WALProtos.FlushDescriptor startFlushDescSmallerSeqId = this.clone(startFlushDesc, startFlushDesc.getFlushSequenceNumber() - 50L);
        LOG.info("-- Replaying same flush start in secondary again " + startFlushDescSmallerSeqId);
        result = this.secondaryRegion.replayWALFlushStartMarker(startFlushDescSmallerSeqId);
        Assert.assertNull((Object)result);
        Assert.assertNotNull((Object)this.secondaryRegion.getPrepareFlushResult());
        Assert.assertEquals((long)this.secondaryRegion.getPrepareFlushResult().flushOpSeqId, (long)startFlushDesc.getFlushSequenceNumber());
        Assert.assertTrue((this.secondaryRegion.getMemStoreSize() > 0L ? 1 : 0) != 0);
        TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
        WALProtos.FlushDescriptor startFlushDescLargerSeqId = this.clone(startFlushDesc, startFlushDesc.getFlushSequenceNumber() + 50L);
        LOG.info("-- Replaying same flush start in secondary again " + startFlushDescLargerSeqId);
        result = this.secondaryRegion.replayWALFlushStartMarker(startFlushDescLargerSeqId);
        Assert.assertNull((Object)result);
        Assert.assertNotNull((Object)this.secondaryRegion.getPrepareFlushResult());
        Assert.assertEquals((long)this.secondaryRegion.getPrepareFlushResult().flushOpSeqId, (long)startFlushDesc.getFlushSequenceNumber());
        Assert.assertTrue((this.secondaryRegion.getMemStoreSize() > 0L ? 1 : 0) != 0);
        TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
        LOG.info("-- Verifying edits from secondary");
        TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
        LOG.info("-- Verifying edits from primary.");
        TestHRegion.verifyData(this.primaryRegion, 0, numRows, this.cq, this.families);
    }

    @Test
    public void testReplayFlushCommitMarkerSmallerThanFlushStartMarker() throws IOException {
        this.putDataWithFlushes(this.primaryRegion, 100, 200, 100);
        int numRows = 300;
        this.reader = this.createWALReaderForPrimary();
        LOG.info("-- Replaying edits and flush events in secondary");
        WALProtos.FlushDescriptor startFlushDesc = null;
        WALProtos.FlushDescriptor commitFlushDesc = null;
        int lastReplayed = 0;
        while (true) {
            System.out.println(lastReplayed);
            WAL.Entry entry = this.reader.next();
            if (entry == null) break;
            WALProtos.FlushDescriptor flushDesc = WALEdit.getFlushDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            if (flushDesc != null) {
                if (flushDesc.getAction() == WALProtos.FlushDescriptor.FlushAction.START_FLUSH) {
                    if (startFlushDesc == null) {
                        startFlushDesc = flushDesc;
                    } else {
                        LOG.info("-- Replaying flush start in secondary");
                        startFlushDesc = flushDesc;
                        HRegion.PrepareFlushResult result = this.secondaryRegion.replayWALFlushStartMarker(startFlushDesc);
                        Assert.assertNull((Object)result.result);
                    }
                } else if (flushDesc.getAction() == WALProtos.FlushDescriptor.FlushAction.COMMIT_FLUSH && commitFlushDesc == null) {
                    commitFlushDesc = flushDesc;
                }
                TestHRegion.verifyData(this.secondaryRegion, 0, lastReplayed + 1, this.cq, this.families);
                continue;
            }
            lastReplayed = TestHRegionReplayEvents.replayEdit(this.secondaryRegion, entry);
        }
        TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
        int expectedStoreFileCount = 0;
        for (HStore s : this.secondaryRegion.getStores()) {
            Assert.assertEquals((long)expectedStoreFileCount, (long)s.getStorefilesCount());
        }
        long regionMemstoreSize = this.secondaryRegion.getMemStoreSize();
        LOG.info("Testing replaying flush COMMIT " + commitFlushDesc + " on top of flush START" + startFlushDesc);
        Assert.assertTrue((commitFlushDesc.getFlushSequenceNumber() < startFlushDesc.getFlushSequenceNumber() ? 1 : 0) != 0);
        LOG.info("-- Replaying flush commit in secondary" + commitFlushDesc);
        this.secondaryRegion.replayWALFlushCommitMarker(commitFlushDesc);
        ++expectedStoreFileCount;
        for (HStore s : this.secondaryRegion.getStores()) {
            Assert.assertEquals((long)expectedStoreFileCount, (long)s.getStorefilesCount());
        }
        HStore store = this.secondaryRegion.getStore(Bytes.toBytes((String)"cf1"));
        long newFlushableSize = store.getFlushableSize().getHeapSize();
        Assert.assertTrue((newFlushableSize > 0L ? 1 : 0) != 0);
        long newRegionMemstoreSize = this.secondaryRegion.getMemStoreSize();
        Assert.assertEquals((long)regionMemstoreSize, (long)newRegionMemstoreSize);
        Assert.assertNotNull((Object)this.secondaryRegion.getPrepareFlushResult());
        LOG.info("-- Verifying edits from secondary");
        TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
        LOG.info("-- Verifying edits from primary.");
        TestHRegion.verifyData(this.primaryRegion, 0, numRows, this.cq, this.families);
    }

    @Test
    public void testReplayFlushCommitMarkerLargerThanFlushStartMarker() throws IOException {
        WAL.Entry entry;
        this.putDataWithFlushes(this.primaryRegion, 100, 100, 100);
        int numRows = 200;
        this.reader = this.createWALReaderForPrimary();
        LOG.info("-- Replaying edits and flush events in secondary");
        WALProtos.FlushDescriptor startFlushDesc = null;
        WALProtos.FlushDescriptor commitFlushDesc = null;
        int lastReplayed = 0;
        while ((entry = this.reader.next()) != null) {
            WALProtos.FlushDescriptor flushDesc = WALEdit.getFlushDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            if (flushDesc != null) {
                if (flushDesc.getAction() == WALProtos.FlushDescriptor.FlushAction.START_FLUSH) {
                    if (startFlushDesc == null) {
                        LOG.info("-- Replaying flush start in secondary");
                        startFlushDesc = flushDesc;
                        HRegion.PrepareFlushResult result = this.secondaryRegion.replayWALFlushStartMarker(startFlushDesc);
                        Assert.assertNull((Object)result.result);
                    }
                } else if (flushDesc.getAction() == WALProtos.FlushDescriptor.FlushAction.COMMIT_FLUSH) {
                    commitFlushDesc = WALProtos.FlushDescriptor.newBuilder((WALProtos.FlushDescriptor)flushDesc).setFlushSequenceNumber(flushDesc.getFlushSequenceNumber() + 50L).build();
                }
                TestHRegion.verifyData(this.secondaryRegion, 0, lastReplayed + 1, this.cq, this.families);
                continue;
            }
            lastReplayed = TestHRegionReplayEvents.replayEdit(this.secondaryRegion, entry);
        }
        TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
        int expectedStoreFileCount = 0;
        for (HStore s : this.secondaryRegion.getStores()) {
            Assert.assertEquals((long)expectedStoreFileCount, (long)s.getStorefilesCount());
        }
        long regionMemstoreSize = this.secondaryRegion.getMemStoreSize();
        LOG.info("Testing replaying flush COMMIT " + commitFlushDesc + " on top of flush START" + startFlushDesc);
        Assert.assertTrue((commitFlushDesc.getFlushSequenceNumber() > startFlushDesc.getFlushSequenceNumber() ? 1 : 0) != 0);
        LOG.info("-- Replaying flush commit in secondary" + commitFlushDesc);
        this.secondaryRegion.replayWALFlushCommitMarker(commitFlushDesc);
        ++expectedStoreFileCount;
        for (HStore s : this.secondaryRegion.getStores()) {
            Assert.assertEquals((long)expectedStoreFileCount, (long)s.getStorefilesCount());
        }
        HStore store = this.secondaryRegion.getStore(Bytes.toBytes((String)"cf1"));
        long newFlushableSize = store.getFlushableSize().getHeapSize();
        Assert.assertTrue((newFlushableSize > 0L ? 1 : 0) != 0);
        long newRegionMemstoreSize = this.secondaryRegion.getMemStoreSize();
        Assert.assertTrue((newRegionMemstoreSize > 0L ? 1 : 0) != 0);
        Assert.assertTrue((regionMemstoreSize > newRegionMemstoreSize ? 1 : 0) != 0);
        Assert.assertNull((Object)this.secondaryRegion.getPrepareFlushResult());
        LOG.info("-- Verifying edits from secondary");
        TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
        LOG.info("-- Verifying edits from primary.");
        TestHRegion.verifyData(this.primaryRegion, 0, numRows, this.cq, this.families);
    }

    @Test
    public void testReplayFlushCommitMarkerWithoutFlushStartMarkerDroppableMemstore() throws IOException {
        this.testReplayFlushCommitMarkerWithoutFlushStartMarker(true);
    }

    @Test
    public void testReplayFlushCommitMarkerWithoutFlushStartMarkerNonDroppableMemstore() throws IOException {
        this.testReplayFlushCommitMarkerWithoutFlushStartMarker(false);
    }

    public void testReplayFlushCommitMarkerWithoutFlushStartMarker(boolean droppableMemstore) throws IOException {
        WAL.Entry entry;
        this.putDataWithFlushes(this.primaryRegion, 100, 100, droppableMemstore ? 0 : 100);
        int numRows = droppableMemstore ? 100 : 200;
        this.reader = this.createWALReaderForPrimary();
        LOG.info("-- Replaying edits and flush events in secondary");
        WALProtos.FlushDescriptor commitFlushDesc = null;
        int lastReplayed = 0;
        while ((entry = this.reader.next()) != null) {
            WALProtos.FlushDescriptor flushDesc = WALEdit.getFlushDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            if (flushDesc != null) {
                if (flushDesc.getAction() != WALProtos.FlushDescriptor.FlushAction.START_FLUSH && flushDesc.getAction() == WALProtos.FlushDescriptor.FlushAction.COMMIT_FLUSH) {
                    commitFlushDesc = flushDesc;
                }
                TestHRegion.verifyData(this.secondaryRegion, 0, lastReplayed + 1, this.cq, this.families);
                continue;
            }
            lastReplayed = TestHRegionReplayEvents.replayEdit(this.secondaryRegion, entry);
        }
        TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
        int expectedStoreFileCount = 0;
        for (HStore s : this.secondaryRegion.getStores()) {
            Assert.assertEquals((long)expectedStoreFileCount, (long)s.getStorefilesCount());
        }
        long regionMemstoreSize = this.secondaryRegion.getMemStoreSize();
        Assert.assertNull((Object)this.secondaryRegion.getPrepareFlushResult());
        Assert.assertTrue((commitFlushDesc.getFlushSequenceNumber() > 0L ? 1 : 0) != 0);
        for (HStore store : this.secondaryRegion.getStores()) {
            Assert.assertTrue((store.getMaxSequenceId().orElse(0L) <= this.secondaryRegion.getReadPoint(null) ? 1 : 0) != 0);
        }
        LOG.info("-- Replaying flush commit in secondary" + commitFlushDesc);
        this.secondaryRegion.replayWALFlushCommitMarker(commitFlushDesc);
        ++expectedStoreFileCount;
        for (HStore s : this.secondaryRegion.getStores()) {
            Assert.assertEquals((long)expectedStoreFileCount, (long)s.getStorefilesCount());
        }
        HStore store = this.secondaryRegion.getStore(Bytes.toBytes((String)"cf1"));
        long newFlushableSize = store.getFlushableSize().getHeapSize();
        if (droppableMemstore) {
            Assert.assertTrue((newFlushableSize == MutableSegment.DEEP_OVERHEAD ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((newFlushableSize > 0L ? 1 : 0) != 0);
        }
        long newRegionMemstoreSize = this.secondaryRegion.getMemStoreSize();
        if (droppableMemstore) {
            Assert.assertTrue((0L == newRegionMemstoreSize ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((regionMemstoreSize == newRegionMemstoreSize ? 1 : 0) != 0);
        }
        LOG.info("-- Verifying edits from secondary");
        TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
        LOG.info("-- Verifying edits from primary.");
        TestHRegion.verifyData(this.primaryRegion, 0, numRows, this.cq, this.families);
    }

    private WALProtos.FlushDescriptor clone(WALProtos.FlushDescriptor flush, long flushSeqId) {
        return WALProtos.FlushDescriptor.newBuilder((WALProtos.FlushDescriptor)flush).setFlushSequenceNumber(flushSeqId).build();
    }

    @Test
    public void testReplayRegionOpenEvent() throws IOException {
        WAL.Entry entry;
        this.putDataWithFlushes(this.primaryRegion, 100, 0, 100);
        int numRows = 100;
        this.primaryRegion.close();
        this.primaryRegion = HRegion.openHRegion((Path)this.rootDir, (RegionInfo)this.primaryHri, (TableDescriptor)this.htd, (WAL)this.walPrimary, (Configuration)CONF, (RegionServerServices)this.rss, null);
        this.reader = this.createWALReaderForPrimary();
        ArrayList regionEvents = Lists.newArrayList();
        LOG.info("-- Replaying edits and region events in secondary");
        while ((entry = this.reader.next()) != null) {
            WALProtos.FlushDescriptor flushDesc = WALEdit.getFlushDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            WALProtos.RegionEventDescriptor regionEventDesc = WALEdit.getRegionEventDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            if (flushDesc != null || regionEventDesc == null) continue;
            regionEvents.add(regionEventDesc);
        }
        Assert.assertEquals((long)3L, (long)regionEvents.size());
        this.secondaryRegion.replayWALRegionEventMarker((WALProtos.RegionEventDescriptor)regionEvents.get(0));
        this.secondaryRegion.replayWALRegionEventMarker((WALProtos.RegionEventDescriptor)regionEvents.get(1));
        int expectedStoreFileCount = 0;
        for (HStore s : this.secondaryRegion.getStores()) {
            Assert.assertEquals((long)expectedStoreFileCount, (long)s.getStorefilesCount());
        }
        long regionMemstoreSize = this.secondaryRegion.getMemStoreSize();
        Assert.assertTrue((regionMemstoreSize == 0L ? 1 : 0) != 0);
        LOG.info("Testing replaying region open event " + regionEvents.get(2));
        this.secondaryRegion.replayWALRegionEventMarker((WALProtos.RegionEventDescriptor)regionEvents.get(2));
        ++expectedStoreFileCount;
        for (HStore s : this.secondaryRegion.getStores()) {
            Assert.assertEquals((long)expectedStoreFileCount, (long)s.getStorefilesCount());
        }
        HStore store = this.secondaryRegion.getStore(Bytes.toBytes((String)"cf1"));
        long newFlushableSize = store.getFlushableSize().getHeapSize();
        Assert.assertTrue((newFlushableSize == MutableSegment.DEEP_OVERHEAD ? 1 : 0) != 0);
        long newRegionMemstoreSize = this.secondaryRegion.getMemStoreSize();
        Assert.assertTrue((newRegionMemstoreSize == 0L ? 1 : 0) != 0);
        Assert.assertNull((Object)this.secondaryRegion.getPrepareFlushResult());
        LOG.info("-- Verifying edits from secondary");
        TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
        LOG.info("-- Verifying edits from primary.");
        TestHRegion.verifyData(this.primaryRegion, 0, numRows, this.cq, this.families);
    }

    @Test
    public void testReplayRegionOpenEventAfterFlushStart() throws IOException {
        WAL.Entry entry;
        this.putDataWithFlushes(this.primaryRegion, 100, 100, 100);
        int numRows = 200;
        this.primaryRegion.close();
        this.primaryRegion = HRegion.openHRegion((Path)this.rootDir, (RegionInfo)this.primaryHri, (TableDescriptor)this.htd, (WAL)this.walPrimary, (Configuration)CONF, (RegionServerServices)this.rss, null);
        this.reader = this.createWALReaderForPrimary();
        ArrayList regionEvents = Lists.newArrayList();
        LOG.info("-- Replaying edits and region events in secondary");
        while ((entry = this.reader.next()) != null) {
            WALProtos.FlushDescriptor flushDesc = WALEdit.getFlushDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            WALProtos.RegionEventDescriptor regionEventDesc = WALEdit.getRegionEventDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            if (flushDesc != null) {
                if (flushDesc.getAction() != WALProtos.FlushDescriptor.FlushAction.START_FLUSH) continue;
                this.secondaryRegion.replayWALFlushStartMarker(flushDesc);
                continue;
            }
            if (regionEventDesc != null) {
                regionEvents.add(regionEventDesc);
                continue;
            }
            TestHRegionReplayEvents.replayEdit(this.secondaryRegion, entry);
        }
        TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
        Assert.assertEquals((long)3L, (long)regionEvents.size());
        int expectedStoreFileCount = 0;
        for (HStore s : this.secondaryRegion.getStores()) {
            Assert.assertEquals((long)expectedStoreFileCount, (long)s.getStorefilesCount());
        }
        LOG.info("Testing replaying region open event " + regionEvents.get(2));
        this.secondaryRegion.replayWALRegionEventMarker((WALProtos.RegionEventDescriptor)regionEvents.get(2));
        expectedStoreFileCount = 2;
        for (HStore s : this.secondaryRegion.getStores()) {
            Assert.assertEquals((long)expectedStoreFileCount, (long)s.getStorefilesCount());
        }
        HStore store = this.secondaryRegion.getStore(Bytes.toBytes((String)"cf1"));
        MemStoreSize newSnapshotSize = store.getSnapshotSize();
        Assert.assertTrue((newSnapshotSize.getDataSize() == 0L ? 1 : 0) != 0);
        long newRegionMemstoreSize = this.secondaryRegion.getMemStoreSize();
        Assert.assertTrue((newRegionMemstoreSize == 0L ? 1 : 0) != 0);
        Assert.assertNull((Object)this.secondaryRegion.getPrepareFlushResult());
        LOG.info("-- Verifying edits from secondary");
        TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
        LOG.info("-- Verifying edits from primary.");
        TestHRegion.verifyData(this.primaryRegion, 0, numRows, this.cq, this.families);
    }

    @Test
    public void testSkippingEditsWithSmallerSeqIdAfterRegionOpenEvent() throws IOException {
        Object entry;
        this.putDataWithFlushes(this.primaryRegion, 100, 100, 0);
        int numRows = 100;
        this.primaryRegion.close();
        this.primaryRegion = HRegion.openHRegion((Path)this.rootDir, (RegionInfo)this.primaryHri, (TableDescriptor)this.htd, (WAL)this.walPrimary, (Configuration)CONF, (RegionServerServices)this.rss, null);
        this.reader = this.createWALReaderForPrimary();
        ArrayList regionEvents = Lists.newArrayList();
        ArrayList edits = Lists.newArrayList();
        LOG.info("-- Replaying edits and region events in secondary");
        while ((entry = this.reader.next()) != null) {
            WALProtos.FlushDescriptor flushDesc = WALEdit.getFlushDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            WALProtos.RegionEventDescriptor regionEventDesc = WALEdit.getRegionEventDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            if (flushDesc != null) continue;
            if (regionEventDesc != null) {
                regionEvents.add(regionEventDesc);
                continue;
            }
            edits.add(entry);
        }
        this.secondaryRegion.replayWALRegionEventMarker(WALProtos.RegionEventDescriptor.newBuilder((WALProtos.RegionEventDescriptor)((WALProtos.RegionEventDescriptor)regionEvents.get(0))).setLogSequenceNumber(((WALProtos.RegionEventDescriptor)regionEvents.get(2)).getLogSequenceNumber()).build());
        for (WAL.Entry entry2 : edits) {
            TestHRegionReplayEvents.replayEdit(this.secondaryRegion, entry2);
        }
        boolean expectedFail = false;
        try {
            TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
        }
        catch (AssertionError e) {
            expectedFail = true;
        }
        if (!expectedFail) {
            Assert.fail((String)"Should have failed this verification");
        }
    }

    @Test
    public void testReplayFlushSeqIds() throws IOException {
        WAL.Entry entry;
        int start = 0;
        LOG.info("-- Writing some data to primary from " + start + " to " + (start + 100));
        TestHRegion.putData(this.primaryRegion, Durability.SYNC_WAL, start, 100, this.cq, this.families);
        LOG.info("-- Flushing primary, creating 3 files for 3 stores");
        this.primaryRegion.flush(true);
        this.reader = this.createWALReaderForPrimary();
        long flushSeqId = -1L;
        LOG.info("-- Replaying flush events in secondary");
        while ((entry = this.reader.next()) != null) {
            WALProtos.FlushDescriptor flushDesc = WALEdit.getFlushDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            if (flushDesc == null) continue;
            if (flushDesc.getAction() == WALProtos.FlushDescriptor.FlushAction.START_FLUSH) {
                LOG.info("-- Replaying flush start in secondary");
                this.secondaryRegion.replayWALFlushStartMarker(flushDesc);
                flushSeqId = flushDesc.getFlushSequenceNumber();
                continue;
            }
            if (flushDesc.getAction() != WALProtos.FlushDescriptor.FlushAction.COMMIT_FLUSH) continue;
            LOG.info("-- Replaying flush commit in secondary");
            this.secondaryRegion.replayWALFlushCommitMarker(flushDesc);
            Assert.assertEquals((long)flushSeqId, (long)flushDesc.getFlushSequenceNumber());
        }
        long readPoint = this.secondaryRegion.getMVCC().getReadPoint();
        Assert.assertEquals((long)flushSeqId, (long)readPoint);
        TestHRegion.verifyData(this.secondaryRegion, 0, 100, this.cq, this.families);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSeqIdsFromReplay() throws IOException {
        String method = this.name.getMethodName();
        byte[] tableName = Bytes.toBytes((String)method);
        byte[] family = Bytes.toBytes((String)"family");
        try (HRegion region = TestHRegionReplayEvents.initHRegion(tableName, method, new byte[][]{family});){
            long readPoint = region.getMVCC().getReadPoint();
            long origSeqId = readPoint + 100L;
            Put put = new Put(this.row).addColumn(family, this.row, this.row);
            put.setDurability(Durability.SKIP_WAL);
            this.replay(region, put, origSeqId);
            TestHRegion.assertGet(region, family, this.row);
            Assert.assertEquals((long)origSeqId, (long)region.getReadPoint(null));
            put = new Put(this.row2).addColumn(family, this.row2, this.row2);
            put.setDurability(Durability.SKIP_WAL);
            this.replay(region, put, origSeqId - 50L);
            TestHRegion.assertGet(region, family, this.row2);
        }
    }

    @Test
    public void testSecondaryRegionDoesNotWriteRegionEventsToWAL() throws IOException {
        this.secondaryRegion.close();
        this.walSecondary = (WAL)Mockito.spy((Object)this.walSecondary);
        this.secondaryRegion = HRegion.openHRegion((RegionInfo)this.secondaryHri, (TableDescriptor)this.htd, (WAL)this.walSecondary, (Configuration)CONF, (RegionServerServices)this.rss, null);
        ((WAL)Mockito.verify((Object)this.walSecondary, (VerificationMode)Mockito.times((int)0))).append((RegionInfo)ArgumentMatchers.any(RegionInfo.class), (WALKeyImpl)ArgumentMatchers.any(WALKeyImpl.class), (WALEdit)ArgumentMatchers.any(WALEdit.class), ArgumentMatchers.anyBoolean());
        this.putDataByReplay(this.secondaryRegion, 0, 10, this.cq, this.families);
        this.secondaryRegion.replayWALFlushStartMarker(WALProtos.FlushDescriptor.newBuilder().setFlushSequenceNumber(10L).setTableName(UnsafeByteOperations.unsafeWrap((byte[])this.primaryRegion.getTableDescriptor().getTableName().getName())).setAction(WALProtos.FlushDescriptor.FlushAction.START_FLUSH).setEncodedRegionName(UnsafeByteOperations.unsafeWrap((byte[])this.primaryRegion.getRegionInfo().getEncodedNameAsBytes())).setRegionName(UnsafeByteOperations.unsafeWrap((byte[])this.primaryRegion.getRegionInfo().getRegionName())).build());
        ((WAL)Mockito.verify((Object)this.walSecondary, (VerificationMode)Mockito.times((int)0))).append((RegionInfo)ArgumentMatchers.any(RegionInfo.class), (WALKeyImpl)ArgumentMatchers.any(WALKeyImpl.class), (WALEdit)ArgumentMatchers.any(WALEdit.class), ArgumentMatchers.anyBoolean());
        this.secondaryRegion.close();
        ((WAL)Mockito.verify((Object)this.walSecondary, (VerificationMode)Mockito.times((int)0))).append((RegionInfo)ArgumentMatchers.any(RegionInfo.class), (WALKeyImpl)ArgumentMatchers.any(WALKeyImpl.class), (WALEdit)ArgumentMatchers.any(WALEdit.class), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testRegionReadsEnabledFlag() throws IOException {
        this.putDataByReplay(this.secondaryRegion, 0, 100, this.cq, this.families);
        TestHRegion.verifyData(this.secondaryRegion, 0, 100, this.cq, this.families);
        this.secondaryRegion.setReadsEnabled(false);
        try {
            TestHRegion.verifyData(this.secondaryRegion, 0, 100, this.cq, this.families);
            Assert.fail((String)"Should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.putDataByReplay(this.secondaryRegion, 100, 100, this.cq, this.families);
        this.secondaryRegion.setReadsEnabled(true);
        TestHRegion.verifyData(this.secondaryRegion, 0, 200, this.cq, this.families);
    }

    @Test
    public void testWriteFlushRequestMarker() throws IOException {
        WAL.Entry entry;
        HRegion.FlushResultImpl result = this.primaryRegion.flushcache(true, false, FlushLifeCycleTracker.DUMMY);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.result, (Object)HRegion.FlushResult.Result.CANNOT_FLUSH_MEMSTORE_EMPTY);
        Assert.assertFalse((boolean)result.wroteFlushWalMarker);
        result = this.primaryRegion.flushcache(true, true, FlushLifeCycleTracker.DUMMY);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.result, (Object)HRegion.FlushResult.Result.CANNOT_FLUSH_MEMSTORE_EMPTY);
        Assert.assertTrue((boolean)result.wroteFlushWalMarker);
        ArrayList flushes = Lists.newArrayList();
        this.reader = this.createWALReaderForPrimary();
        while ((entry = this.reader.next()) != null) {
            WALProtos.FlushDescriptor flush = WALEdit.getFlushDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            if (flush == null) continue;
            flushes.add(flush);
        }
        Assert.assertEquals((long)1L, (long)flushes.size());
        Assert.assertNotNull(flushes.get(0));
        Assert.assertEquals((Object)WALProtos.FlushDescriptor.FlushAction.CANNOT_FLUSH, (Object)((WALProtos.FlushDescriptor)flushes.get(0)).getAction());
    }

    @Test
    public void testReplayingFlushRequestRestoresReadsEnabledState() throws IOException {
        WAL.Entry entry;
        this.disableReads(this.secondaryRegion);
        this.primaryRegion.flushcache(true, true, FlushLifeCycleTracker.DUMMY);
        this.reader = this.createWALReaderForPrimary();
        while ((entry = this.reader.next()) != null) {
            WALProtos.FlushDescriptor flush = WALEdit.getFlushDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            if (flush == null) continue;
            this.secondaryRegion.replayWALFlushMarker(flush, entry.getKey().getSequenceId());
        }
        this.secondaryRegion.get(new Get(Bytes.toBytes((int)0)));
    }

    @Test
    public void testReplayingFlushRestoresReadsEnabledState() throws IOException {
        this.disableReads(this.secondaryRegion);
        TestHRegion.putData(this.primaryRegion, Durability.SYNC_WAL, 0, 100, this.cq, this.families);
        this.primaryRegion.flush(true);
        TestHRegion.putData(this.primaryRegion, Durability.SYNC_WAL, 0, 100, this.cq, this.families);
        this.reader = this.createWALReaderForPrimary();
        while (true) {
            WAL.Entry entry = this.reader.next();
            LOG.info(Objects.toString(entry));
            if (entry == null) break;
            WALProtos.FlushDescriptor flush = WALEdit.getFlushDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            if (flush != null) {
                this.secondaryRegion.replayWALFlushMarker(flush, entry.getKey().getSequenceId());
                continue;
            }
            TestHRegionReplayEvents.replayEdit(this.secondaryRegion, entry);
        }
        TestHRegion.verifyData(this.secondaryRegion, 0, 100, this.cq, this.families);
    }

    @Test
    public void testReplayingFlushWithEmptyMemstoreRestoresReadsEnabledState() throws IOException {
        WAL.Entry entry;
        this.disableReads(this.secondaryRegion);
        TestHRegion.putData(this.primaryRegion, Durability.SYNC_WAL, 0, 100, this.cq, this.families);
        this.primaryRegion.flush(true);
        this.reader = this.createWALReaderForPrimary();
        while ((entry = this.reader.next()) != null) {
            WALProtos.FlushDescriptor flush = WALEdit.getFlushDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            if (flush == null) continue;
            this.secondaryRegion.replayWALFlushMarker(flush, entry.getKey().getSequenceId());
        }
        TestHRegion.verifyData(this.secondaryRegion, 0, 100, this.cq, this.families);
    }

    @Test
    public void testReplayingRegionOpenEventRestoresReadsEnabledState() throws IOException {
        WAL.Entry entry;
        this.disableReads(this.secondaryRegion);
        this.primaryRegion.close();
        this.primaryRegion = HRegion.openHRegion((Path)this.rootDir, (RegionInfo)this.primaryHri, (TableDescriptor)this.htd, (WAL)this.walPrimary, (Configuration)CONF, (RegionServerServices)this.rss, null);
        this.reader = this.createWALReaderForPrimary();
        while ((entry = this.reader.next()) != null) {
            WALProtos.RegionEventDescriptor regionEventDesc = WALEdit.getRegionEventDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            if (regionEventDesc == null) continue;
            this.secondaryRegion.replayWALRegionEventMarker(regionEventDesc);
        }
        this.secondaryRegion.get(new Get(Bytes.toBytes((int)0)));
    }

    @Test
    public void testRefresStoreFiles() throws IOException {
        WAL.Entry entry;
        Assert.assertEquals((long)0L, (long)this.primaryRegion.getStoreFileList(this.families).size());
        Assert.assertEquals((long)0L, (long)this.secondaryRegion.getStoreFileList(this.families).size());
        this.secondaryRegion.refreshStoreFiles();
        Assert.assertEquals((long)0L, (long)this.secondaryRegion.getStoreFileList(this.families).size());
        this.putDataWithFlushes(this.primaryRegion, 100, 100, 0);
        int numRows = 100;
        this.secondaryRegion.refreshStoreFiles();
        this.assertPathListsEqual(this.primaryRegion.getStoreFileList(this.families), this.secondaryRegion.getStoreFileList(this.families));
        Assert.assertEquals((long)this.families.length, (long)this.secondaryRegion.getStoreFileList(this.families).size());
        LOG.info("-- Verifying edits from secondary");
        TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
        this.putDataWithFlushes(this.primaryRegion, 100, 300, 0);
        numRows = 300;
        this.secondaryRegion.refreshStoreFiles();
        this.assertPathListsEqual(this.primaryRegion.getStoreFileList(this.families), this.secondaryRegion.getStoreFileList(this.families));
        Assert.assertEquals((long)(this.families.length * 4), (long)this.secondaryRegion.getStoreFileList(this.families).size());
        LOG.info("-- Verifying edits from secondary");
        TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
        if (FSUtils.WINDOWS) {
            return;
        }
        this.primaryRegion.compactStores();
        ArrayList<HRegion> regions = new ArrayList<HRegion>();
        regions.add(this.primaryRegion);
        ((RegionServerServices)Mockito.doReturn(regions).when((Object)this.rss)).getRegions();
        CompactedHFilesDischarger cleaner = new CompactedHFilesDischarger(100, null, this.rss, false);
        cleaner.chore();
        this.secondaryRegion.refreshStoreFiles();
        this.assertPathListsEqual(this.primaryRegion.getStoreFileList(this.families), this.secondaryRegion.getStoreFileList(this.families));
        Assert.assertEquals((long)this.families.length, (long)this.secondaryRegion.getStoreFileList(this.families).size());
        LOG.info("-- Verifying edits from secondary");
        TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
        LOG.info("-- Replaying edits in secondary");
        Assert.assertTrue((this.secondaryRegion.getMemStoreSize() == 0L ? 1 : 0) != 0);
        this.putDataWithFlushes(this.primaryRegion, 400, 400, 0);
        numRows = 400;
        this.reader = this.createWALReaderForPrimary();
        while ((entry = this.reader.next()) != null) {
            WALProtos.FlushDescriptor flush = WALEdit.getFlushDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)));
            if (flush != null) continue;
            TestHRegionReplayEvents.replayEdit(this.secondaryRegion, entry);
        }
        Assert.assertTrue((this.secondaryRegion.getMemStoreSize() > 0L ? 1 : 0) != 0);
        this.secondaryRegion.refreshStoreFiles();
        Assert.assertTrue((this.secondaryRegion.getMemStoreSize() == 0L ? 1 : 0) != 0);
        LOG.info("-- Verifying edits from primary");
        TestHRegion.verifyData(this.primaryRegion, 0, numRows, this.cq, this.families);
        LOG.info("-- Verifying edits from secondary");
        TestHRegion.verifyData(this.secondaryRegion, 0, numRows, this.cq, this.families);
    }

    private void assertPathListsEqual(List<String> list1, List<String> list2) {
        ArrayList<Path> l1 = new ArrayList<Path>(list1.size());
        for (String path : list1) {
            l1.add(Path.getPathWithoutSchemeAndAuthority((Path)new Path(path)));
        }
        ArrayList<Path> l2 = new ArrayList<Path>(list2.size());
        for (String path : list2) {
            l2.add(Path.getPathWithoutSchemeAndAuthority((Path)new Path(path)));
        }
        Assert.assertEquals(l1, l2);
    }

    private void disableReads(HRegion region) {
        region.setReadsEnabled(false);
        try {
            TestHRegion.verifyData(region, 0, 1, this.cq, this.families);
            Assert.fail((String)"Should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void replay(HRegion region, Put put, long replaySeqId) throws IOException {
        put.setDurability(Durability.SKIP_WAL);
        WALSplitter.MutationReplay mutation = new WALSplitter.MutationReplay(ClientProtos.MutationProto.MutationType.PUT, (Mutation)put, 0L, 0L);
        region.batchReplay(new WALSplitter.MutationReplay[]{mutation}, replaySeqId);
    }

    @Test
    public void testReplayBulkLoadEvent() throws IOException {
        WAL.Entry entry;
        LOG.info("testReplayBulkLoadEvent starts");
        this.putDataWithFlushes(this.primaryRegion, 100, 0, 100);
        this.primaryRegion.close();
        this.primaryRegion = HRegion.openHRegion((Path)this.rootDir, (RegionInfo)this.primaryHri, (TableDescriptor)this.htd, (WAL)this.walPrimary, (Configuration)CONF, (RegionServerServices)this.rss, null);
        Random random = new Random();
        byte[] randomValues = new byte[20];
        random.nextBytes(randomValues);
        Path testPath = TEST_UTIL.getDataTestDirOnTestFS();
        ArrayList<Pair> familyPaths = new ArrayList<Pair>();
        int expectedLoadFileCount = 0;
        for (byte[] family : this.families) {
            familyPaths.add(new Pair((Object)family, (Object)this.createHFileForFamilies(testPath, family, randomValues)));
            ++expectedLoadFileCount;
        }
        this.primaryRegion.bulkLoadHFiles(familyPaths, false, null);
        this.reader = this.createWALReaderForPrimary();
        LOG.info("-- Replaying edits and region events in secondary");
        WALProtos.BulkLoadDescriptor bulkloadEvent = null;
        while ((entry = this.reader.next()) != null && (bulkloadEvent = WALEdit.getBulkLoadDescriptor((Cell)((Cell)entry.getEdit().getCells().get(0)))) == null) {
        }
        Assert.assertTrue((bulkloadEvent != null ? 1 : 0) != 0);
        Assert.assertEquals((long)expectedLoadFileCount, (long)bulkloadEvent.getStoresCount());
        this.secondaryRegion.replayWALBulkLoadEventMarker(bulkloadEvent);
        ArrayList storeFileName = new ArrayList();
        for (WALProtos.StoreDescriptor storeDesc : bulkloadEvent.getStoresList()) {
            storeFileName.addAll(storeDesc.getStoreFileList());
        }
        for (HStore s : this.secondaryRegion.getStores()) {
            for (HStoreFile sf : s.getStorefiles()) {
                storeFileName.remove(sf.getPath().getName());
            }
        }
        Assert.assertTrue((String)("Found some store file isn't loaded:" + storeFileName), (boolean)storeFileName.isEmpty());
        LOG.info("-- Verifying edits from secondary");
        for (Object family : (Object)this.families) {
            TestHRegion.assertGet(this.secondaryRegion, (byte[])family, randomValues);
        }
    }

    @Test
    public void testReplayingFlushCommitWithFileAlreadyDeleted() throws IOException {
        this.secondaryRegion.replayWALFlushCommitMarker(WALProtos.FlushDescriptor.newBuilder().setFlushSequenceNumber(Long.MAX_VALUE).setTableName(UnsafeByteOperations.unsafeWrap((byte[])this.primaryRegion.getTableDescriptor().getTableName().getName())).setAction(WALProtos.FlushDescriptor.FlushAction.COMMIT_FLUSH).setEncodedRegionName(UnsafeByteOperations.unsafeWrap((byte[])this.primaryRegion.getRegionInfo().getEncodedNameAsBytes())).setRegionName(UnsafeByteOperations.unsafeWrap((byte[])this.primaryRegion.getRegionInfo().getRegionName())).addStoreFlushes(WALProtos.FlushDescriptor.StoreFlushDescriptor.newBuilder().setFamilyName(UnsafeByteOperations.unsafeWrap((byte[])this.families[0])).setStoreHomeDir("/store_home_dir").addFlushOutput("/foo/baz/bar").build()).build());
    }

    @Test
    public void testReplayingCompactionWithFileAlreadyDeleted() throws IOException {
        this.secondaryRegion.replayWALCompactionMarker(WALProtos.CompactionDescriptor.newBuilder().setTableName(UnsafeByteOperations.unsafeWrap((byte[])this.primaryRegion.getTableDescriptor().getTableName().getName())).setEncodedRegionName(UnsafeByteOperations.unsafeWrap((byte[])this.primaryRegion.getRegionInfo().getEncodedNameAsBytes())).setFamilyName(UnsafeByteOperations.unsafeWrap((byte[])this.families[0])).addCompactionInput("/foo").addCompactionOutput("/bar").setStoreHomeDir("/store_home_dir").setRegionName(UnsafeByteOperations.unsafeWrap((byte[])this.primaryRegion.getRegionInfo().getRegionName())).build(), true, true, Long.MAX_VALUE);
    }

    @Test
    public void testReplayingRegionOpenEventWithFileAlreadyDeleted() throws IOException {
        this.secondaryRegion.replayWALRegionEventMarker(WALProtos.RegionEventDescriptor.newBuilder().setTableName(UnsafeByteOperations.unsafeWrap((byte[])this.primaryRegion.getTableDescriptor().getTableName().getName())).setEncodedRegionName(UnsafeByteOperations.unsafeWrap((byte[])this.primaryRegion.getRegionInfo().getEncodedNameAsBytes())).setRegionName(UnsafeByteOperations.unsafeWrap((byte[])this.primaryRegion.getRegionInfo().getRegionName())).setEventType(WALProtos.RegionEventDescriptor.EventType.REGION_OPEN).setServer(ProtobufUtil.toServerName((ServerName)ServerName.valueOf((String)"foo", (int)1, (long)1L))).setLogSequenceNumber(Long.MAX_VALUE).addStores(WALProtos.StoreDescriptor.newBuilder().setFamilyName(UnsafeByteOperations.unsafeWrap((byte[])this.families[0])).setStoreHomeDir("/store_home_dir").addStoreFile("/foo").build()).build());
    }

    @Test
    public void testReplayingBulkLoadEventWithFileAlreadyDeleted() throws IOException {
        this.secondaryRegion.replayWALBulkLoadEventMarker(WALProtos.BulkLoadDescriptor.newBuilder().setTableName(ProtobufUtil.toProtoTableName((TableName)this.primaryRegion.getTableDescriptor().getTableName())).setEncodedRegionName(UnsafeByteOperations.unsafeWrap((byte[])this.primaryRegion.getRegionInfo().getEncodedNameAsBytes())).setBulkloadSeqNum(Long.MAX_VALUE).addStores(WALProtos.StoreDescriptor.newBuilder().setFamilyName(UnsafeByteOperations.unsafeWrap((byte[])this.families[0])).setStoreHomeDir("/store_home_dir").addStoreFile("/foo").build()).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createHFileForFamilies(Path testPath, byte[] family, byte[] valueBytes) throws IOException {
        HFile.WriterFactory hFileFactory = HFile.getWriterFactoryNoCache((Configuration)TEST_UTIL.getConfiguration());
        Path testFile = new Path(testPath, UUID.randomUUID().toString());
        try (FSDataOutputStream out = TEST_UTIL.getTestFileSystem().create(testFile);){
            hFileFactory.withOutputStream(out);
            hFileFactory.withFileContext(new HFileContext());
            try (HFile.Writer writer = hFileFactory.create();){
                writer.append((Cell)new KeyValue(CellUtil.createCell((byte[])valueBytes, (byte[])family, (byte[])valueBytes, (long)0L, (byte)KeyValue.Type.Put.getCode(), (byte[])valueBytes)));
            }
        }
        return testFile.toString();
    }

    private void putDataWithFlushes(HRegion region, int flushInterval, int numRows, int numRowsAfterFlush) throws IOException {
        int start;
        for (start = 0; start < numRows; start += flushInterval) {
            LOG.info("-- Writing some data to primary from " + start + " to " + (start + flushInterval));
            TestHRegion.putData(region, Durability.SYNC_WAL, start, flushInterval, this.cq, this.families);
            LOG.info("-- Flushing primary, creating 3 files for 3 stores");
            region.flush(true);
        }
        LOG.info("-- Writing some more data to primary, not flushing");
        TestHRegion.putData(region, Durability.SYNC_WAL, start, numRowsAfterFlush, this.cq, this.families);
    }

    private void putDataByReplay(HRegion region, int startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        for (int i = startRow; i < startRow + numRows; ++i) {
            Put put = new Put(Bytes.toBytes((String)("" + i)));
            put.setDurability(Durability.SKIP_WAL);
            for (byte[] family : families) {
                put.addColumn(family, qf, EnvironmentEdgeManager.currentTime(), null);
            }
            this.replay(region, put, i + 1);
        }
    }

    private static HRegion initHRegion(byte[] tableName, String callingMethod, byte[] ... families) throws IOException {
        return TestHRegionReplayEvents.initHRegion(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, callingMethod, TEST_UTIL.getConfiguration(), false, Durability.SYNC_WAL, null, families);
    }

    private static HRegion initHRegion(byte[] tableName, byte[] startKey, byte[] stopKey, String callingMethod, Configuration conf, boolean isReadOnly, Durability durability, WAL wal, byte[] ... families) throws IOException {
        return TEST_UTIL.createLocalHRegion(tableName, startKey, stopKey, callingMethod, conf, isReadOnly, durability, wal, families);
    }
}

