/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestJoinedScanners {
    private static final Logger LOG = LoggerFactory.getLogger(TestJoinedScanners.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String DIR = TEST_UTIL.getDataTestDir("TestJoinedScanners").toString();
    private static final byte[] cf_essential = Bytes.toBytes((String)"essential");
    private static final byte[] cf_joined = Bytes.toBytes((String)"joined");
    private static final byte[] col_name = Bytes.toBytes((String)"a");
    private static final byte[] flag_yes = Bytes.toBytes((String)"Y");
    private static final byte[] flag_no = Bytes.toBytes((String)"N");
    private static DataBlockEncoding blockEncoding = DataBlockEncoding.FAST_DIFF;
    private static int selectionRatio = 30;
    private static int valueWidth = 131072;
    @Rule
    public TestName name = new TestName();
    private static Options options = new Options();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinedScanners() throws Exception {
        String[] dataNodeHosts = new String[]{"host1", "host2", "host3"};
        int regionServersCount = 3;
        HBaseTestingUtility htu = new HBaseTestingUtility();
        int DEFAULT_BLOCK_SIZE = 0x100000;
        htu.getConfiguration().setLong("dfs.blocksize", 0x100000L);
        htu.getConfiguration().setInt("dfs.replication", 1);
        htu.getConfiguration().setLong("hbase.hregion.max.filesize", 0x4B00000000L);
        MiniHBaseCluster cluster = null;
        try {
            cluster = htu.startMiniCluster(1, regionServersCount, dataNodeHosts);
            byte[][] families = new byte[][]{cf_essential, cf_joined};
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            HTableDescriptor desc = new HTableDescriptor(tableName);
            for (byte[] family : families) {
                HColumnDescriptor hcd = new HColumnDescriptor(family);
                hcd.setDataBlockEncoding(blockEncoding);
                desc.addFamily(hcd);
            }
            htu.getAdmin().createTable((TableDescriptor)desc);
            Table ht = htu.getConnection().getTable(tableName);
            long rows_to_insert = 1000L;
            int insert_batch = 20;
            long time = System.nanoTime();
            Random rand = new Random(time);
            LOG.info("Make " + Long.toString(rows_to_insert) + " rows, total size = " + Float.toString(rows_to_insert * (long)valueWidth / 1024L / 1024L) + " MB");
            byte[] val_large = new byte[valueWidth];
            ArrayList<Put> puts = new ArrayList<Put>();
            for (long i = 0L; i < rows_to_insert; ++i) {
                Put put = new Put(Bytes.toBytes((String)Long.toString(i)));
                if (rand.nextInt(100) <= selectionRatio) {
                    put.addColumn(cf_essential, col_name, flag_yes);
                } else {
                    put.addColumn(cf_essential, col_name, flag_no);
                }
                put.addColumn(cf_joined, col_name, val_large);
                puts.add(put);
                if (puts.size() < insert_batch) continue;
                ht.put(puts);
                puts.clear();
            }
            if (!puts.isEmpty()) {
                ht.put(puts);
                puts.clear();
            }
            LOG.info("Data generated in " + Double.toString((double)(System.nanoTime() - time) / 1.0E9) + " seconds");
            boolean slow = true;
            for (int i = 0; i < 10; ++i) {
                this.runScanner(ht, slow);
                slow = !slow;
            }
            ht.close();
        }
        finally {
            if (cluster != null) {
                htu.shutdownMiniCluster();
            }
        }
    }

    private void runScanner(Table table, boolean slow) throws Exception {
        Result res;
        long time = System.nanoTime();
        Scan scan = new Scan();
        scan.addColumn(cf_essential, col_name);
        scan.addColumn(cf_joined, col_name);
        SingleColumnValueFilter filter = new SingleColumnValueFilter(cf_essential, col_name, CompareFilter.CompareOp.EQUAL, flag_yes);
        filter.setFilterIfMissing(true);
        scan.setFilter((Filter)filter);
        scan.setLoadColumnFamiliesOnDemand(!slow);
        ResultScanner result_scanner = table.getScanner(scan);
        long rows_count = 0L;
        while ((res = result_scanner.next()) != null) {
            ++rows_count;
        }
        double timeSec = (double)(System.nanoTime() - time) / 1.0E9;
        result_scanner.close();
        LOG.info((slow ? "Slow" : "Joined") + " scanner finished in " + Double.toString(timeSec) + " seconds, got " + Long.toString(rows_count / 2L) + " rows");
    }

    public static void main(String[] args) throws Exception {
        Option encodingOption = new Option("e", "blockEncoding", true, "Data block encoding; Default: FAST_DIFF");
        encodingOption.setRequired(false);
        options.addOption(encodingOption);
        Option ratioOption = new Option("r", "selectionRatio", true, "Ratio of selected rows using essential column family");
        ratioOption.setRequired(false);
        options.addOption(ratioOption);
        Option widthOption = new Option("w", "valueWidth", true, "Width of value for non-essential column family");
        widthOption.setRequired(false);
        options.addOption(widthOption);
        GnuParser parser = new GnuParser();
        CommandLine cmd = parser.parse(options, args);
        if (args.length < 1) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("TestJoinedScanners", options, true);
        }
        if (cmd.hasOption("e")) {
            blockEncoding = DataBlockEncoding.valueOf((String)cmd.getOptionValue("e"));
        }
        if (cmd.hasOption("r")) {
            selectionRatio = Integer.parseInt(cmd.getOptionValue("r"));
        }
        if (cmd.hasOption("w")) {
            valueWidth = Integer.parseInt(cmd.getOptionValue("w"));
        }
        TestJoinedScanners test = new TestJoinedScanners();
        test.testJoinedScanners();
    }
}

