/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestNewVersionBehaviorFromClientSide {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] ROW = Bytes.toBytes((String)"r1");
    private static final byte[] ROW2 = Bytes.toBytes((String)"r2");
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");
    private static final byte[] value = Bytes.toBytes((String)"value");
    private static final byte[] col1 = Bytes.toBytes((String)"col1");
    private static final byte[] col2 = Bytes.toBytes((String)"col2");
    private static final byte[] col3 = Bytes.toBytes((String)"col3");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void setDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private Table createTable() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor table = new HTableDescriptor(tableName);
        HColumnDescriptor fam = new HColumnDescriptor(FAMILY);
        fam.setNewVersionBehavior(true);
        fam.setMaxVersions(3);
        table.addFamily(fam);
        TEST_UTIL.getHBaseAdmin().createTable((TableDescriptor)table);
        return TEST_UTIL.getConnection().getTable(tableName);
    }

    @Test
    public void testPutAndDeleteVersions() throws IOException {
        try (Table t = this.createTable();){
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000001L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000002L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000003L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000004L, value));
            t.delete(new Delete(ROW).addColumns(FAMILY, col1, 2000000L));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000000L, value));
            TEST_UTIL.getAdmin().flush(t.getName());
            Result r = t.get(new Get(ROW).setMaxVersions(3));
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertEquals((long)1000000L, (long)r.rawCells()[0].getTimestamp());
        }
    }

    @Test
    public void testPutMasked() throws IOException {
        try (Table t = this.createTable();){
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000001L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000002L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000003L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000004L, value));
            t.delete(new Delete(ROW).addColumn(FAMILY, col1, 1000003L));
            Result r = t.get(new Get(ROW).setMaxVersions(3));
            Assert.assertEquals((long)2L, (long)r.size());
            Assert.assertEquals((long)1000004L, (long)r.rawCells()[0].getTimestamp());
            Assert.assertEquals((long)1000002L, (long)r.rawCells()[1].getTimestamp());
            TEST_UTIL.getAdmin().flush(t.getName());
            r = t.get(new Get(ROW).setMaxVersions(3));
            Assert.assertEquals((long)2L, (long)r.size());
            Assert.assertEquals((long)1000004L, (long)r.rawCells()[0].getTimestamp());
            Assert.assertEquals((long)1000002L, (long)r.rawCells()[1].getTimestamp());
        }
    }

    @Test
    public void testPutMasked2() throws IOException {
        try (Table t = this.createTable();){
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000001L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000002L, value));
            t.delete(new Delete(ROW).addColumn(FAMILY, col1, 1000003L));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000003L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000004L, value));
            Result r = t.get(new Get(ROW).setMaxVersions(3));
            Assert.assertEquals((long)3L, (long)r.size());
            Assert.assertEquals((long)1000004L, (long)r.rawCells()[0].getTimestamp());
            Assert.assertEquals((long)1000003L, (long)r.rawCells()[1].getTimestamp());
            Assert.assertEquals((long)1000002L, (long)r.rawCells()[2].getTimestamp());
            TEST_UTIL.getAdmin().flush(t.getName());
            r = t.get(new Get(ROW).setMaxVersions(3));
            Assert.assertEquals((long)3L, (long)r.size());
            Assert.assertEquals((long)1000004L, (long)r.rawCells()[0].getTimestamp());
            Assert.assertEquals((long)1000003L, (long)r.rawCells()[1].getTimestamp());
            Assert.assertEquals((long)1000002L, (long)r.rawCells()[2].getTimestamp());
        }
    }

    @Test
    public void testPutMaskedAndUserMaxVersion() throws IOException {
        try (Table t = this.createTable();){
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000001L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000002L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000003L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000004L, value));
            t.delete(new Delete(ROW).addColumn(FAMILY, col1, 1000004L));
            t.delete(new Delete(ROW).addColumn(FAMILY, col1, 1000003L));
            Result r = t.get(new Get(ROW).setMaxVersions(1));
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertEquals((long)1000002L, (long)r.rawCells()[0].getTimestamp());
            TEST_UTIL.getAdmin().flush(t.getName());
            r = t.get(new Get(ROW).setMaxVersions(1));
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertEquals((long)1000002L, (long)r.rawCells()[0].getTimestamp());
        }
    }

    @Test
    public void testSameTs() throws IOException {
        try (Table t = this.createTable();){
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000001L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000002L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000003L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000003L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000003L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000004L, value));
            Result r = t.get(new Get(ROW).setMaxVersions(3));
            Assert.assertEquals((long)3L, (long)r.size());
            Assert.assertEquals((long)1000004L, (long)r.rawCells()[0].getTimestamp());
            Assert.assertEquals((long)1000003L, (long)r.rawCells()[1].getTimestamp());
            Assert.assertEquals((long)1000002L, (long)r.rawCells()[2].getTimestamp());
            TEST_UTIL.getAdmin().flush(t.getName());
            r = t.get(new Get(ROW).setMaxVersions(3));
            Assert.assertEquals((long)3L, (long)r.size());
            Assert.assertEquals((long)1000004L, (long)r.rawCells()[0].getTimestamp());
            Assert.assertEquals((long)1000003L, (long)r.rawCells()[1].getTimestamp());
            Assert.assertEquals((long)1000002L, (long)r.rawCells()[2].getTimestamp());
        }
    }

    @Test
    public void testSameTsAndDelete() throws IOException {
        try (Table t = this.createTable();){
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000001L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000002L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000003L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000003L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000003L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000003L, value));
            t.delete(new Delete(ROW).addColumn(FAMILY, col1, 1000003L));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000004L, value));
            Result r = t.get(new Get(ROW).setMaxVersions(3));
            Assert.assertEquals((long)3L, (long)r.size());
            Assert.assertEquals((long)1000004L, (long)r.rawCells()[0].getTimestamp());
            Assert.assertEquals((long)1000002L, (long)r.rawCells()[1].getTimestamp());
            Assert.assertEquals((long)1000001L, (long)r.rawCells()[2].getTimestamp());
            TEST_UTIL.getAdmin().flush(t.getName());
            r = t.get(new Get(ROW).setMaxVersions(3));
            Assert.assertEquals((long)3L, (long)r.size());
            Assert.assertEquals((long)1000004L, (long)r.rawCells()[0].getTimestamp());
            Assert.assertEquals((long)1000002L, (long)r.rawCells()[1].getTimestamp());
            Assert.assertEquals((long)1000001L, (long)r.rawCells()[2].getTimestamp());
        }
    }

    @Test
    public void testDeleteFamily() throws IOException {
        try (Table t = this.createTable();){
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000001L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000002L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col2, 1000002L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col3, 1000001L, value));
            t.delete(new Delete(ROW).addFamily(FAMILY, 2000000L));
            t.put(new Put(ROW).addColumn(FAMILY, col3, 1500002L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col2, 1500001L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1500001L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1500002L, value));
            TEST_UTIL.getAdmin().flush(t.getName());
            Result r = t.get(new Get(ROW).setMaxVersions(3));
            Assert.assertEquals((long)4L, (long)r.size());
            Assert.assertEquals((long)1500002L, (long)r.rawCells()[0].getTimestamp());
            Assert.assertEquals((long)1500001L, (long)r.rawCells()[1].getTimestamp());
            Assert.assertEquals((long)1500001L, (long)r.rawCells()[2].getTimestamp());
            Assert.assertEquals((long)1500002L, (long)r.rawCells()[3].getTimestamp());
            t.delete(new Delete(ROW).addFamilyVersion(FAMILY, 1500001L));
            r = t.get(new Get(ROW).setMaxVersions(3));
            Assert.assertEquals((long)2L, (long)r.size());
            Assert.assertEquals((long)1500002L, (long)r.rawCells()[0].getTimestamp());
            Assert.assertEquals((long)1500002L, (long)r.rawCells()[1].getTimestamp());
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000001L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000002L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col2, 1000002L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col3, 1000001L, value));
            TEST_UTIL.getAdmin().flush(t.getName());
            r = t.get(new Get(ROW).setMaxVersions(3));
            Assert.assertEquals((long)6L, (long)r.size());
            Assert.assertEquals((long)1500002L, (long)r.rawCells()[0].getTimestamp());
            Assert.assertEquals((long)1000002L, (long)r.rawCells()[1].getTimestamp());
            Assert.assertEquals((long)1000001L, (long)r.rawCells()[2].getTimestamp());
            Assert.assertEquals((long)1000002L, (long)r.rawCells()[3].getTimestamp());
            Assert.assertEquals((long)1500002L, (long)r.rawCells()[4].getTimestamp());
            Assert.assertEquals((long)1000001L, (long)r.rawCells()[5].getTimestamp());
        }
    }

    @Test
    public void testTimeRange() throws IOException {
        try (Table t = this.createTable();){
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000001L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000002L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000003L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000004L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000005L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000006L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000007L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000008L, value));
            Result r = t.get(new Get(ROW).setMaxVersions(3).setTimeRange(0L, 1000005L));
            Assert.assertEquals((long)0L, (long)r.size());
            TEST_UTIL.getAdmin().flush(t.getName());
            r = t.get(new Get(ROW).setMaxVersions(3).setTimeRange(0L, 1000005L));
            Assert.assertEquals((long)0L, (long)r.size());
        }
    }

    @Test
    public void testExplicitColum() throws IOException {
        try (Table t = this.createTable();){
            t.put(new Put(ROW).addColumn(FAMILY, col1, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, value));
            t.put(new Put(ROW).addColumn(FAMILY, col2, value));
            t.put(new Put(ROW).addColumn(FAMILY, col2, value));
            t.put(new Put(ROW).addColumn(FAMILY, col2, value));
            t.put(new Put(ROW).addColumn(FAMILY, col2, value));
            t.put(new Put(ROW).addColumn(FAMILY, col3, value));
            t.put(new Put(ROW).addColumn(FAMILY, col3, value));
            t.put(new Put(ROW).addColumn(FAMILY, col3, value));
            t.put(new Put(ROW).addColumn(FAMILY, col3, value));
            Result r = t.get(new Get(ROW).setMaxVersions(3).addColumn(FAMILY, col2));
            Assert.assertEquals((long)3L, (long)r.size());
            TEST_UTIL.getAdmin().flush(t.getName());
            r = t.get(new Get(ROW).setMaxVersions(3).addColumn(FAMILY, col2));
            Assert.assertEquals((long)3L, (long)r.size());
            TEST_UTIL.getAdmin().flush(t.getName());
        }
    }

    @Test
    public void testgetColumnHint() throws IOException {
        try (Table t = this.createTable();){
            t.setOperationTimeout(10000);
            t.setRpcTimeout(10000);
            t.put(new Put(ROW).addColumn(FAMILY, col1, 100L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 101L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 102L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 103L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 104L, value));
            t.put(new Put(ROW2).addColumn(FAMILY, col1, 104L, value));
            TEST_UTIL.getAdmin().flush(t.getName());
            t.delete(new Delete(ROW).addColumn(FAMILY, col1));
        }
    }

    @Test
    public void testRawScanAndMajorCompaction() throws IOException {
        try (Table t = this.createTable();){
            Result r;
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000001L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000002L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000003L, value));
            t.put(new Put(ROW).addColumn(FAMILY, col1, 1000004L, value));
            t.delete(new Delete(ROW).addColumn(FAMILY, col1, 1000004L));
            t.delete(new Delete(ROW).addColumn(FAMILY, col1, 1000003L));
            try (ResultScanner scannner = t.getScanner(new Scan().setRaw(true).setMaxVersions());){
                r = scannner.next();
                Assert.assertNull((Object)scannner.next());
                Assert.assertEquals((long)6L, (long)r.size());
            }
            TEST_UTIL.getAdmin().flush(t.getName());
            scannner = t.getScanner(new Scan().setRaw(true).setMaxVersions());
            var4_6 = null;
            try {
                r = scannner.next();
                Assert.assertNull((Object)scannner.next());
                Assert.assertEquals((long)6L, (long)r.size());
            }
            catch (Throwable r2) {
                var4_6 = r2;
                throw r2;
            }
            finally {
                if (scannner != null) {
                    if (var4_6 != null) {
                        try {
                            scannner.close();
                        }
                        catch (Throwable r2) {
                            var4_6.addSuppressed(r2);
                        }
                    } else {
                        scannner.close();
                    }
                }
            }
            TEST_UTIL.getAdmin().majorCompact(t.getName());
            Threads.sleep((long)5000L);
            scannner = t.getScanner(new Scan().setRaw(true).setMaxVersions());
            var4_6 = null;
            try {
                r = scannner.next();
                Assert.assertNull((Object)scannner.next());
                Assert.assertEquals((long)1L, (long)r.size());
                Assert.assertEquals((long)1000002L, (long)r.rawCells()[0].getTimestamp());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (scannner != null) {
                    if (var4_6 != null) {
                        try {
                            scannner.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        scannner.close();
                    }
                }
            }
        }
    }
}

