/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServer;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapperStub;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapperStub;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestRSStatusServlet {
    private static final Logger LOG = LoggerFactory.getLogger(TestRSStatusServlet.class);
    private HRegionServer rs;
    private RSRpcServices rpcServices;
    private RpcServerInterface rpcServer;
    static final int FAKE_IPC_PORT = 1585;
    static final int FAKE_WEB_PORT = 1586;
    private final ServerName fakeServerName = ServerName.valueOf((String)"localhost", (int)1585, (long)11111L);
    private final AdminProtos.GetServerInfoResponse fakeResponse = ResponseConverter.buildGetServerInfoResponse((ServerName)this.fakeServerName, (int)1586);
    private final ServerName fakeMasterAddress = ServerName.valueOf((String)"localhost", (int)60010, (long)1212121212L);
    @Rule
    public TestName name = new TestName();

    @Before
    public void setupBasicMocks() throws IOException, ServiceException {
        this.rs = (HRegionServer)Mockito.mock(HRegionServer.class);
        this.rpcServices = (RSRpcServices)Mockito.mock(RSRpcServices.class);
        this.rpcServer = (RpcServerInterface)Mockito.mock(RpcServerInterface.class);
        ((HRegionServer)Mockito.doReturn((Object)HBaseConfiguration.create()).when((Object)this.rs)).getConfiguration();
        ((HRegionServer)Mockito.doReturn((Object)this.rpcServices).when((Object)this.rs)).getRSRpcServices();
        ((HRegionServer)Mockito.doReturn((Object)this.rpcServer).when((Object)this.rs)).getRpcServer();
        ((RSRpcServices)Mockito.doReturn((Object)this.fakeResponse).when((Object)this.rpcServices)).getServerInfo((RpcController)Mockito.any(), (AdminProtos.GetServerInfoRequest)Mockito.any());
        ZKWatcher zkw = (ZKWatcher)Mockito.mock(ZKWatcher.class);
        ((ZKWatcher)Mockito.doReturn((Object)"fakequorum").when((Object)zkw)).getQuorum();
        ((HRegionServer)Mockito.doReturn((Object)zkw).when((Object)this.rs)).getZooKeeper();
        LOG.warn("The hfile.block.cache.size is set to 0");
        CacheConfig cacheConf = (CacheConfig)Mockito.mock(CacheConfig.class);
        ((CacheConfig)Mockito.doReturn(null).when((Object)cacheConf)).getBlockCache();
        ((HRegionServer)Mockito.doReturn((Object)cacheConf).when((Object)this.rs)).getCacheConfig();
        MasterAddressTracker mat = (MasterAddressTracker)Mockito.mock(MasterAddressTracker.class);
        ((MasterAddressTracker)Mockito.doReturn((Object)this.fakeMasterAddress).when((Object)mat)).getMasterAddress();
        ((HRegionServer)Mockito.doReturn((Object)mat).when((Object)this.rs)).getMasterAddressTracker();
        MetricsRegionServer rms = (MetricsRegionServer)Mockito.mock(MetricsRegionServer.class);
        ((MetricsRegionServer)Mockito.doReturn((Object)new MetricsRegionServerWrapperStub()).when((Object)rms)).getRegionServerWrapper();
        ((HRegionServer)Mockito.doReturn((Object)rms).when((Object)this.rs)).getRegionServerMetrics();
        MetricsHBaseServer ms = (MetricsHBaseServer)Mockito.mock(MetricsHBaseServer.class);
        ((MetricsHBaseServer)Mockito.doReturn((Object)new MetricsHBaseServerWrapperStub()).when((Object)ms)).getHBaseServerWrapper();
        ((RpcServerInterface)Mockito.doReturn((Object)ms).when((Object)this.rpcServer)).getMetrics();
    }

    @Test
    public void testBasic() throws IOException, ServiceException {
        new RSStatusTmpl().render((Writer)new StringWriter(), this.rs);
    }

    @Test
    public void testWithRegions() throws IOException, ServiceException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        ArrayList regions = Lists.newArrayList((Object[])new RegionInfo[]{RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).setStartKey(Bytes.toBytes((String)"a")).setEndKey(Bytes.toBytes((String)"d")).build(), RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).setStartKey(Bytes.toBytes((String)"d")).setEndKey(Bytes.toBytes((String)"z")).build()});
        ((RSRpcServices)Mockito.doReturn((Object)ResponseConverter.buildGetOnlineRegionResponse((List)regions)).when((Object)this.rpcServices)).getOnlineRegion((RpcController)Mockito.any(), (AdminProtos.GetOnlineRegionRequest)Mockito.any());
        new RSStatusTmpl().render((Writer)new StringWriter(), this.rs);
    }
}

