/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestSplitWalDataLoss {
    private static final Logger LOG = LoggerFactory.getLogger(TestSplitWalDataLoss.class);
    private final HBaseTestingUtility testUtil = new HBaseTestingUtility();
    private NamespaceDescriptor namespace = NamespaceDescriptor.create((String)this.getClass().getSimpleName()).build();
    private TableName tableName = TableName.valueOf((String)this.namespace.getName(), (String)"dataloss");
    private byte[] family = Bytes.toBytes((String)"f");
    private byte[] qualifier = Bytes.toBytes((String)"q");

    @Before
    public void setUp() throws Exception {
        this.testUtil.getConfiguration().setInt("hbase.regionserver.msginterval", 30000);
        this.testUtil.startMiniCluster(2);
        Admin admin = this.testUtil.getAdmin();
        admin.createNamespace(this.namespace);
        admin.createTable(TableDescriptorBuilder.newBuilder((TableName)this.tableName).addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])this.family)).build());
        this.testUtil.waitTableAvailable(this.tableName);
    }

    @After
    public void tearDown() throws Exception {
        this.testUtil.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws IOException, InterruptedException {
        final HRegionServer rs = this.testUtil.getRSForFirstRegionInTable(this.tableName);
        final HRegion region = (HRegion)rs.getRegions(this.tableName).get(0);
        HRegion spiedRegion = (HRegion)Mockito.spy((Object)region);
        final MutableBoolean flushed = new MutableBoolean(false);
        final MutableBoolean reported = new MutableBoolean(false);
        ((HRegion)Mockito.doAnswer((Answer)new Answer<HRegion.FlushResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public HRegion.FlushResult answer(InvocationOnMock invocation) throws Throwable {
                MutableBoolean mutableBoolean = flushed;
                synchronized (mutableBoolean) {
                    flushed.setValue(true);
                    flushed.notifyAll();
                }
                mutableBoolean = reported;
                synchronized (mutableBoolean) {
                    while (!reported.booleanValue()) {
                        reported.wait();
                    }
                }
                rs.getWAL(region.getRegionInfo()).abortCacheFlush(region.getRegionInfo().getEncodedNameAsBytes());
                throw new DroppedSnapshotException("testcase");
            }
        }).when((Object)spiedRegion)).internalFlushCacheAndCommit((WAL)Matchers.any(), (MonitoredTask)Matchers.any(), (HRegion.PrepareFlushResult)Matchers.any(), (Collection)Matchers.any());
        String key = null;
        for (Map.Entry entry : rs.onlineRegions.entrySet()) {
            if (!((HRegion)entry.getValue()).getRegionInfo().getTable().equals((Object)this.tableName)) continue;
            key = (String)entry.getKey();
            break;
        }
        rs.onlineRegions.put(key, spiedRegion);
        Connection conn = this.testUtil.getConnection();
        try (Table table = conn.getTable(this.tableName);){
            table.put(new Put(Bytes.toBytes((String)"row0")).addColumn(this.family, this.qualifier, Bytes.toBytes((String)"val0")));
        }
        long oldestSeqIdOfStore = region.getOldestSeqIdOfStore(this.family);
        LOG.info("CHANGE OLDEST " + oldestSeqIdOfStore);
        Assert.assertTrue((oldestSeqIdOfStore > -1L ? 1 : 0) != 0);
        rs.cacheFlusher.requestFlush(spiedRegion, false, FlushLifeCycleTracker.DUMMY);
        MutableBoolean mutableBoolean = flushed;
        synchronized (mutableBoolean) {
            while (!flushed.booleanValue()) {
                flushed.wait();
            }
        }
        try (Table table = conn.getTable(this.tableName);){
            table.put(new Put(Bytes.toBytes((String)"row1")).addColumn(this.family, this.qualifier, Bytes.toBytes((String)"val1")));
        }
        long now = EnvironmentEdgeManager.currentTime();
        rs.tryRegionServerReport(now - 500L, now);
        MutableBoolean mutableBoolean2 = reported;
        synchronized (mutableBoolean2) {
            reported.setValue(true);
            reported.notifyAll();
        }
        while (this.testUtil.getRSForFirstRegionInTable(this.tableName) == rs) {
            Thread.sleep(100L);
        }
        try (Table table = conn.getTable(this.tableName);){
            Result result = table.get(new Get(Bytes.toBytes((String)"row0")));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"val0"), (byte[])result.getValue(this.family, this.qualifier));
        }
    }
}

