/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestTimestampFilterSeekHint {
    private static final HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();
    private static final String RK = "myRK";
    private static final byte[] RK_BYTES = Bytes.toBytes((String)"myRK");
    private static final String FAMILY = "D";
    private static final byte[] FAMILY_BYTES = Bytes.toBytes((String)"D");
    private static final String QUAL = "0";
    private static final byte[] QUAL_BYTES = Bytes.toBytes((String)"0");
    public static final int MAX_VERSIONS = 50000;
    private HRegion region;
    private int regionCount = 0;

    @Test
    public void testGetSeek() throws IOException {
        StoreFileScanner.instrument();
        this.prepareRegion();
        Get g = new Get(RK_BYTES);
        TimestampsFilter timestampsFilter = new TimestampsFilter((List)ImmutableList.of((Object)5L), true);
        g.setFilter((Filter)timestampsFilter);
        long initialSeekCount = StoreFileScanner.getSeekCount();
        this.region.get(g);
        long finalSeekCount = StoreFileScanner.getSeekCount();
        Assert.assertTrue((finalSeekCount >= initialSeekCount + 3L ? 1 : 0) != 0);
    }

    @Test
    public void testGetDoesntSeekWithNoHint() throws IOException {
        StoreFileScanner.instrument();
        this.prepareRegion();
        Get g = new Get(RK_BYTES);
        g.setFilter((Filter)new TimestampsFilter((List)ImmutableList.of((Object)5L)));
        long initialSeekCount = StoreFileScanner.getSeekCount();
        this.region.get(g);
        long finalSeekCount = StoreFileScanner.getSeekCount();
        Assert.assertTrue((finalSeekCount >= initialSeekCount ? 1 : 0) != 0);
        Assert.assertTrue((finalSeekCount < initialSeekCount + 3L ? 1 : 0) != 0);
    }

    @Before
    public void prepareRegion() throws IOException {
        this.region = TEST_UTIL.createTestRegion("TestTimestampFilterSeekHint" + this.regionCount++, (ColumnFamilyDescriptor)new HColumnDescriptor(FAMILY).setBlocksize(1024).setMaxVersions(50000));
        for (long i = 0L; i < 49998L; ++i) {
            Put p = new Put(RK_BYTES, i);
            p.addColumn(FAMILY_BYTES, QUAL_BYTES, Bytes.toBytes((String)RandomStringUtils.randomAlphabetic((int)255)));
            this.region.put(p);
        }
        this.region.flush(true);
    }
}

