/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.CellArrayImmutableSegment;
import org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hadoop.hbase.regionserver.DefaultMemStore;
import org.apache.hadoop.hbase.regionserver.FlushNonSloppyStoresFirstPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestWalAndCompactingMemStoreFlush {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Path DIR = TEST_UTIL.getDataTestDir("TestHRegion");
    public static final TableName TABLENAME = TableName.valueOf((String)"TestWalAndCompactingMemStoreFlush", (String)"t1");
    public static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"f2"), Bytes.toBytes((String)"f3"), Bytes.toBytes((String)"f4"), Bytes.toBytes((String)"f5")};
    public static final byte[] FAMILY1 = FAMILIES[0];
    public static final byte[] FAMILY2 = FAMILIES[1];
    public static final byte[] FAMILY3 = FAMILIES[2];

    private HRegion initHRegion(String callingMethod, Configuration conf) throws IOException {
        int i = 0;
        HTableDescriptor htd = new HTableDescriptor(TABLENAME);
        for (byte[] family : FAMILIES) {
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            if (i % 2 == 0) {
                hcd.setInMemoryCompaction(MemoryCompactionPolicy.valueOf((String)conf.get("hbase.hregion.compacting.memstore.type")));
            } else {
                hcd.setInMemoryCompaction(MemoryCompactionPolicy.NONE);
            }
            htd.addFamily(hcd);
            ++i;
        }
        HRegionInfo info = new HRegionInfo(TABLENAME, null, null, false);
        Path path = new Path(DIR, callingMethod);
        return HBaseTestingUtility.createRegionAndWAL((RegionInfo)info, path, conf, (TableDescriptor)htd);
    }

    private Put createPut(int familyNum, int putNum) {
        byte[] qf = Bytes.toBytes((String)("q" + familyNum));
        byte[] row = Bytes.toBytes((String)("row" + familyNum + "-" + putNum));
        byte[] val = Bytes.toBytes((String)("val" + familyNum + "-" + putNum));
        Put p = new Put(row);
        p.addColumn(FAMILIES[familyNum - 1], qf, val);
        return p;
    }

    private Put createDoublePut(int familyNum, int putNum) {
        byte[] qf = Bytes.toBytes((String)("q" + familyNum));
        byte[] row = Bytes.toBytes((String)("row" + familyNum + "-" + putNum));
        byte[] val = Bytes.toBytes((String)("val" + familyNum + "-" + putNum));
        Put p = new Put(row);
        p.addColumn(FAMILIES[familyNum - 1], qf, 10L, val);
        p.addColumn(FAMILIES[familyNum - 1], qf, 20L, val);
        return p;
    }

    private Get createGet(int familyNum, int putNum) {
        byte[] row = Bytes.toBytes((String)("row" + familyNum + "-" + putNum));
        return new Get(row);
    }

    private void verifyInMemoryFlushSize(Region region) {
        Assert.assertEquals((long)((CompactingMemStore)((HStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY1)).memstore).getInmemoryFlushSize(), (long)((CompactingMemStore)((HStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY3)).memstore).getInmemoryFlushSize());
    }

    void verifyEdit(int familyNum, int putNum, Table table) throws IOException {
        Result r = table.get(this.createGet(familyNum, putNum));
        byte[] family = FAMILIES[familyNum - 1];
        byte[] qf = Bytes.toBytes((String)("q" + familyNum));
        byte[] val = Bytes.toBytes((String)("val" + familyNum + "-" + putNum));
        Assert.assertNotNull((String)("Missing Put#" + putNum + " for CF# " + familyNum), (Object)r.getFamilyMap(family));
        Assert.assertNotNull((String)("Missing Put#" + putNum + " for CF# " + familyNum), r.getFamilyMap(family).get(qf));
        Assert.assertTrue((String)("Incorrect value for Put#" + putNum + " for CF# " + familyNum), (boolean)Arrays.equals((byte[])r.getFamilyMap(family).get(qf), val));
    }

    @Test(timeout=180000L)
    public void testSelectiveFlushWithEager() throws IOException {
        int i;
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.hregion.memstore.flush.size", 307200L);
        conf.set("hbase.regionserver.flush.policy", FlushNonSloppyStoresFirstPolicy.class.getName());
        conf.setLong("hbase.hregion.percolumnfamilyflush.size.lower.bound.min", 76800L);
        conf.setDouble("hbase.memstore.inmemoryflush.threshold.factor", 0.5);
        conf.set("hbase.hregion.compacting.memstore.type", String.valueOf(MemoryCompactionPolicy.EAGER));
        HRegion region = this.initHRegion("testSelectiveFlushWithEager", conf);
        this.verifyInMemoryFlushSize((Region)region);
        for (i = 1; i <= 1200; ++i) {
            region.put(this.createPut(1, i));
            if (i > 100) continue;
            region.put(this.createPut(2, i));
            if (i > 50) continue;
            region.put(this.createDoublePut(3, i));
        }
        for (i = 100; i < 2000; ++i) {
            region.put(this.createPut(2, i));
        }
        long totalMemstoreSize = region.getMemStoreSize();
        long smallestSeqCF1PhaseI = region.getOldestSeqIdOfStore(FAMILY1);
        long smallestSeqCF2PhaseI = region.getOldestSeqIdOfStore(FAMILY2);
        long smallestSeqCF3PhaseI = region.getOldestSeqIdOfStore(FAMILY3);
        MemStoreSize cf1MemstoreSizePhaseI = region.getStore(FAMILY1).getMemStoreSize();
        MemStoreSize cf2MemstoreSizePhaseI = region.getStore(FAMILY2).getMemStoreSize();
        MemStoreSize cf3MemstoreSizePhaseI = region.getStore(FAMILY3).getMemStoreSize();
        long smallestSeqInRegionCurrentMemstorePhaseI = this.getWAL((Region)region).getEarliestMemStoreSeqNum(region.getRegionInfo().getEncodedNameAsBytes());
        String s = "\n\n----------------------------------\nUpon initial insert and before any flush, size of CF1 is:" + cf1MemstoreSizePhaseI + ", is CF1 compacted memstore?:" + region.getStore(FAMILY1).isSloppyMemStore() + ". Size of CF2 is:" + cf2MemstoreSizePhaseI + ", is CF2 compacted memstore?:" + region.getStore(FAMILY2).isSloppyMemStore() + ". Size of CF3 is:" + cf3MemstoreSizePhaseI + ", is CF3 compacted memstore?:" + region.getStore(FAMILY3).isSloppyMemStore() + "\n";
        Assert.assertEquals((long)smallestSeqCF1PhaseI, (long)smallestSeqInRegionCurrentMemstorePhaseI);
        Assert.assertTrue((smallestSeqCF1PhaseI < smallestSeqCF2PhaseI ? 1 : 0) != 0);
        Assert.assertTrue((smallestSeqCF2PhaseI < smallestSeqCF3PhaseI ? 1 : 0) != 0);
        Assert.assertTrue((cf1MemstoreSizePhaseI.getDataSize() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((cf2MemstoreSizePhaseI.getDataSize() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((cf3MemstoreSizePhaseI.getDataSize() > 0L ? 1 : 0) != 0);
        String msg = "totalMemstoreSize=" + totalMemstoreSize + " cf1MemstoreSizePhaseI=" + cf1MemstoreSizePhaseI + " cf2MemstoreSizePhaseI=" + cf2MemstoreSizePhaseI + " cf3MemstoreSizePhaseI=" + cf3MemstoreSizePhaseI;
        Assert.assertEquals((String)msg, (long)totalMemstoreSize, (long)(cf1MemstoreSizePhaseI.getDataSize() + cf2MemstoreSizePhaseI.getDataSize() + cf3MemstoreSizePhaseI.getDataSize()));
        CompactingMemStore cms1 = (CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY1).memstore;
        CompactingMemStore cms3 = (CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY3).memstore;
        cms1.flushInMemory();
        cms3.flushInMemory();
        region.flush(false);
        MemStoreSize cf1MemstoreSizePhaseII = region.getStore(FAMILY1).getMemStoreSize();
        MemStoreSize cf2MemstoreSizePhaseII = region.getStore(FAMILY2).getMemStoreSize();
        MemStoreSize cf3MemstoreSizePhaseII = region.getStore(FAMILY3).getMemStoreSize();
        long smallestSeqInRegionCurrentMemstorePhaseII = this.getWAL((Region)region).getEarliestMemStoreSeqNum(region.getRegionInfo().getEncodedNameAsBytes());
        long smallestSeqCF1PhaseII = region.getOldestSeqIdOfStore(FAMILY1);
        long smallestSeqCF2PhaseII = region.getOldestSeqIdOfStore(FAMILY2);
        long smallestSeqCF3PhaseII = region.getOldestSeqIdOfStore(FAMILY3);
        s = s + "\n----After first flush! CF1 should be flushed to memory, but not compacted.---\nSize of CF1 is:" + cf1MemstoreSizePhaseII + ", size of CF2 is:" + cf2MemstoreSizePhaseII + ", size of CF3 is:" + cf3MemstoreSizePhaseII + "\n";
        Assert.assertTrue((cf1MemstoreSizePhaseII.getDataSize() == cf1MemstoreSizePhaseI.getDataSize() ? 1 : 0) != 0);
        Assert.assertTrue((cf1MemstoreSizePhaseII.getHeapSize() < cf1MemstoreSizePhaseI.getHeapSize() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)cf2MemstoreSizePhaseII.getDataSize());
        Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)cf2MemstoreSizePhaseII.getHeapSize());
        Assert.assertTrue((cf3MemstoreSizePhaseI.getDataSize() > cf3MemstoreSizePhaseII.getDataSize() ? 1 : 0) != 0);
        Assert.assertTrue((cf3MemstoreSizePhaseI.getHeapSize() / 2L > cf3MemstoreSizePhaseII.getHeapSize() ? 1 : 0) != 0);
        Assert.assertEquals((long)smallestSeqInRegionCurrentMemstorePhaseII, (long)smallestSeqCF1PhaseI);
        for (int i2 = 1200; i2 < 3000; ++i2) {
            region.put(this.createPut(1, i2));
        }
        s = s + "The smallest sequence in region WAL is: " + smallestSeqInRegionCurrentMemstorePhaseII + ", the smallest sequence in CF1:" + smallestSeqCF1PhaseII + ", the smallest sequence in CF2:" + smallestSeqCF2PhaseII + ", the smallest sequence in CF3:" + smallestSeqCF3PhaseII + "\n";
        MemStoreSize cf1MemstoreSizePhaseIII = region.getStore(FAMILY1).getMemStoreSize();
        long smallestSeqCF1PhaseIII = region.getOldestSeqIdOfStore(FAMILY1);
        s = s + "----After more puts into CF1 its size is:" + cf1MemstoreSizePhaseIII + ", and its sequence is:" + smallestSeqCF1PhaseIII + " ----\n";
        region.flush(false);
        MemStoreSize cf1MemstoreSizePhaseIV = region.getStore(FAMILY1).getMemStoreSize();
        MemStoreSize cf2MemstoreSizePhaseIV = region.getStore(FAMILY2).getMemStoreSize();
        MemStoreSize cf3MemstoreSizePhaseIV = region.getStore(FAMILY3).getMemStoreSize();
        long smallestSeqInRegionCurrentMemstorePhaseIV = this.getWAL((Region)region).getEarliestMemStoreSeqNum(region.getRegionInfo().getEncodedNameAsBytes());
        long smallestSeqCF1PhaseIV = region.getOldestSeqIdOfStore(FAMILY1);
        long smallestSeqCF2PhaseIV = region.getOldestSeqIdOfStore(FAMILY2);
        long smallestSeqCF3PhaseIV = region.getOldestSeqIdOfStore(FAMILY3);
        s = s + "----After SECOND FLUSH, CF1 size is:" + cf1MemstoreSizePhaseIV + ", CF2 size is:" + cf2MemstoreSizePhaseIV + " and CF3 size is:" + cf3MemstoreSizePhaseIV + "\n";
        s = s + "The smallest sequence in region WAL is: " + smallestSeqInRegionCurrentMemstorePhaseIV + ", the smallest sequence in CF1:" + smallestSeqCF1PhaseIV + ", the smallest sequence in CF2:" + smallestSeqCF2PhaseIV + ", the smallest sequence in CF3:" + smallestSeqCF3PhaseIV + "\n";
        Assert.assertTrue((cf1MemstoreSizePhaseIII.getDataSize() > cf1MemstoreSizePhaseIV.getDataSize() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)cf2MemstoreSizePhaseIV.getDataSize());
        Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)cf2MemstoreSizePhaseIV.getHeapSize());
        Assert.assertEquals((Object)cf3MemstoreSizePhaseIV, (Object)cf3MemstoreSizePhaseII);
        Assert.assertEquals((long)smallestSeqCF3PhaseII, (long)smallestSeqCF3PhaseIV);
        Assert.assertEquals((String)s, (long)smallestSeqInRegionCurrentMemstorePhaseIV, (long)smallestSeqCF3PhaseIV);
        region.flush(true);
        MemStoreSize cf1MemstoreSizePhaseV = region.getStore(FAMILY1).getMemStoreSize();
        MemStoreSize cf2MemstoreSizePhaseV = region.getStore(FAMILY2).getMemStoreSize();
        MemStoreSize cf3MemstoreSizePhaseV = region.getStore(FAMILY3).getMemStoreSize();
        long smallestSeqInRegionCurrentMemstorePhaseV = this.getWAL((Region)region).getEarliestMemStoreSeqNum(region.getRegionInfo().getEncodedNameAsBytes());
        Assert.assertEquals((long)0L, (long)cf1MemstoreSizePhaseV.getDataSize());
        Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)cf1MemstoreSizePhaseV.getHeapSize());
        Assert.assertEquals((long)0L, (long)cf2MemstoreSizePhaseV.getDataSize());
        Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)cf2MemstoreSizePhaseV.getHeapSize());
        Assert.assertEquals((long)0L, (long)cf3MemstoreSizePhaseV.getDataSize());
        Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)cf3MemstoreSizePhaseV.getHeapSize());
        for (int i3 = 1; i3 <= 300; ++i3) {
            region.put(this.createPut(1, i3));
            region.put(this.createPut(2, i3));
            region.put(this.createPut(3, i3));
            region.put(this.createPut(4, i3));
            region.put(this.createPut(5, i3));
        }
        region.flush(false);
        s = s + "----AFTER THIRD AND FORTH FLUSH, The smallest sequence in region WAL is: " + smallestSeqInRegionCurrentMemstorePhaseV + ". After additional inserts and last flush, the entire region size is:" + region.getMemStoreSize() + "\n----------------------------------\n";
        Assert.assertEquals((long)0L, (long)region.getMemStoreSize());
        System.out.println(s);
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    @Test(timeout=180000L)
    public void testSelectiveFlushWithIndexCompaction() throws IOException {
        int i;
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.hregion.memstore.flush.size", 307200L);
        conf.set("hbase.regionserver.flush.policy", FlushNonSloppyStoresFirstPolicy.class.getName());
        conf.setLong("hbase.hregion.percolumnfamilyflush.size.lower.bound.min", 76800L);
        conf.setDouble("hbase.memstore.inmemoryflush.threshold.factor", 0.5);
        conf.set("hbase.hregion.compacting.memstore.type", String.valueOf(MemoryCompactionPolicy.BASIC));
        HRegion region = this.initHRegion("testSelectiveFlushWithIndexCompaction", conf);
        this.verifyInMemoryFlushSize((Region)region);
        for (i = 1; i <= 1200; ++i) {
            region.put(this.createPut(1, i));
            if (i > 100) continue;
            region.put(this.createPut(2, i));
            if (i > 50) continue;
            region.put(this.createDoublePut(3, i));
        }
        for (i = 100; i < 2000; ++i) {
            region.put(this.createPut(2, i));
        }
        long totalMemstoreSizePhaseI = region.getMemStoreSize();
        long smallestSeqCF1PhaseI = region.getOldestSeqIdOfStore(FAMILY1);
        long smallestSeqCF2PhaseI = region.getOldestSeqIdOfStore(FAMILY2);
        long smallestSeqCF3PhaseI = region.getOldestSeqIdOfStore(FAMILY3);
        MemStoreSize cf1MemstoreSizePhaseI = region.getStore(FAMILY1).getMemStoreSize();
        MemStoreSize cf2MemstoreSizePhaseI = region.getStore(FAMILY2).getMemStoreSize();
        MemStoreSize cf3MemstoreSizePhaseI = region.getStore(FAMILY3).getMemStoreSize();
        long smallestSeqInRegionCurrentMemstorePhaseI = this.getWAL((Region)region).getEarliestMemStoreSeqNum(region.getRegionInfo().getEncodedNameAsBytes());
        Assert.assertEquals((long)smallestSeqCF1PhaseI, (long)smallestSeqInRegionCurrentMemstorePhaseI);
        Assert.assertTrue((smallestSeqCF1PhaseI < smallestSeqCF2PhaseI ? 1 : 0) != 0);
        Assert.assertTrue((smallestSeqCF2PhaseI < smallestSeqCF3PhaseI ? 1 : 0) != 0);
        Assert.assertTrue((cf1MemstoreSizePhaseI.getDataSize() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((cf2MemstoreSizePhaseI.getDataSize() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((cf3MemstoreSizePhaseI.getDataSize() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)totalMemstoreSizePhaseI, (long)(cf1MemstoreSizePhaseI.getDataSize() + cf2MemstoreSizePhaseI.getDataSize() + cf3MemstoreSizePhaseI.getDataSize()));
        region.flush(false);
        CompactingMemStore cms1 = (CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY1).memstore;
        CompactingMemStore cms3 = (CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY3).memstore;
        cms1.flushInMemory();
        cms3.flushInMemory();
        while (((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY1).memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        while (((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY3).memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        MemStoreSize cf1MemstoreSizePhaseII = region.getStore(FAMILY1).getMemStoreSize();
        MemStoreSize cf2MemstoreSizePhaseII = region.getStore(FAMILY2).getMemStoreSize();
        MemStoreSize cf3MemstoreSizePhaseII = region.getStore(FAMILY3).getMemStoreSize();
        long smallestSeqInRegionCurrentMemstorePhaseII = this.getWAL((Region)region).getEarliestMemStoreSeqNum(region.getRegionInfo().getEncodedNameAsBytes());
        long smallestSeqCF3PhaseII = region.getOldestSeqIdOfStore(FAMILY3);
        long totalMemstoreSizePhaseII = region.getMemStoreSize();
        Assert.assertEquals((long)cf1MemstoreSizePhaseII.getDataSize(), (long)cf1MemstoreSizePhaseI.getDataSize());
        Assert.assertTrue((cf1MemstoreSizePhaseII.getHeapSize() < cf1MemstoreSizePhaseI.getHeapSize() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)cf2MemstoreSizePhaseII.getDataSize());
        Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)cf2MemstoreSizePhaseII.getHeapSize());
        Assert.assertEquals((long)cf3MemstoreSizePhaseII.getDataSize(), (long)cf3MemstoreSizePhaseI.getDataSize());
        Assert.assertTrue((cf3MemstoreSizePhaseI.getHeapSize() / 2L < cf3MemstoreSizePhaseII.getHeapSize() ? 1 : 0) != 0);
        Assert.assertEquals((long)smallestSeqInRegionCurrentMemstorePhaseII, (long)smallestSeqCF1PhaseI);
        Assert.assertEquals((long)totalMemstoreSizePhaseII, (long)(cf1MemstoreSizePhaseII.getDataSize() + cf2MemstoreSizePhaseII.getDataSize() + cf3MemstoreSizePhaseII.getDataSize()));
        for (int i2 = 1200; i2 < 8000; ++i2) {
            region.put(this.createPut(1, i2));
        }
        while (((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY1).memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        MemStoreSize cf1MemstoreSizePhaseIII = region.getStore(FAMILY1).getMemStoreSize();
        long totalMemstoreSizePhaseIII = region.getMemStoreSize();
        Assert.assertEquals((long)totalMemstoreSizePhaseIII, (long)(cf1MemstoreSizePhaseIII.getDataSize() + cf2MemstoreSizePhaseII.getDataSize() + cf3MemstoreSizePhaseII.getDataSize()));
        region.flush(false);
        MemStoreSize cf1MemstoreSizePhaseIV = region.getStore(FAMILY1).getMemStoreSize();
        MemStoreSize cf2MemstoreSizePhaseIV = region.getStore(FAMILY2).getMemStoreSize();
        MemStoreSize cf3MemstoreSizePhaseIV = region.getStore(FAMILY3).getMemStoreSize();
        long smallestSeqInRegionCurrentMemstorePhaseIV = this.getWAL((Region)region).getEarliestMemStoreSeqNum(region.getRegionInfo().getEncodedNameAsBytes());
        long smallestSeqCF3PhaseIV = region.getOldestSeqIdOfStore(FAMILY3);
        Assert.assertTrue((cf1MemstoreSizePhaseIII.getDataSize() > cf1MemstoreSizePhaseIV.getDataSize() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)cf2MemstoreSizePhaseIV.getDataSize());
        Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)cf2MemstoreSizePhaseIV.getHeapSize());
        Assert.assertEquals((Object)cf3MemstoreSizePhaseIV, (Object)cf3MemstoreSizePhaseII);
        Assert.assertEquals((long)smallestSeqCF3PhaseII, (long)smallestSeqCF3PhaseIV);
        Assert.assertEquals((long)smallestSeqInRegionCurrentMemstorePhaseIV, (long)smallestSeqCF3PhaseIV);
        region.flush(true);
        MemStoreSize cf1MemstoreSizePhaseV = region.getStore(FAMILY1).getMemStoreSize();
        MemStoreSize cf2MemstoreSizePhaseV = region.getStore(FAMILY2).getMemStoreSize();
        MemStoreSize cf3MemstoreSizePhaseV = region.getStore(FAMILY3).getMemStoreSize();
        long smallestSeqInRegionCurrentMemstorePhaseV = this.getWAL((Region)region).getEarliestMemStoreSeqNum(region.getRegionInfo().getEncodedNameAsBytes());
        long totalMemstoreSizePhaseV = region.getMemStoreSize();
        Assert.assertEquals((long)0L, (long)cf1MemstoreSizePhaseV.getDataSize());
        Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)cf1MemstoreSizePhaseV.getHeapSize());
        Assert.assertEquals((long)0L, (long)cf2MemstoreSizePhaseV.getDataSize());
        Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)cf2MemstoreSizePhaseV.getHeapSize());
        Assert.assertEquals((long)0L, (long)cf3MemstoreSizePhaseV.getDataSize());
        Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)cf3MemstoreSizePhaseV.getHeapSize());
        Assert.assertEquals((long)0L, (long)totalMemstoreSizePhaseV);
        Assert.assertEquals((long)smallestSeqInRegionCurrentMemstorePhaseV, (long)-1L);
        for (int i3 = 1; i3 <= 300; ++i3) {
            region.put(this.createPut(1, i3));
            region.put(this.createPut(2, i3));
            region.put(this.createPut(3, i3));
            region.put(this.createPut(4, i3));
            region.put(this.createPut(5, i3));
        }
        MemStoreSize cf1ActiveSizePhaseVI = region.getStore(FAMILY1).getMemStoreSize();
        MemStoreSize cf3ActiveSizePhaseVI = region.getStore(FAMILY3).getMemStoreSize();
        MemStoreSize cf5ActiveSizePhaseVI = region.getStore(FAMILIES[4]).getMemStoreSize();
        region.flush(false);
        MemStoreSize cf1ActiveSizePhaseVII = region.getStore(FAMILY1).getMemStoreSize();
        MemStoreSize cf3ActiveSizePhaseVII = region.getStore(FAMILY3).getMemStoreSize();
        MemStoreSize cf5ActiveSizePhaseVII = region.getStore(FAMILIES[4]).getMemStoreSize();
        Assert.assertTrue((cf1ActiveSizePhaseVII.getDataSize() < cf1ActiveSizePhaseVI.getDataSize() ? 1 : 0) != 0);
        Assert.assertTrue((cf3ActiveSizePhaseVII.getDataSize() < cf3ActiveSizePhaseVI.getDataSize() ? 1 : 0) != 0);
        Assert.assertTrue((cf5ActiveSizePhaseVII.getDataSize() < cf5ActiveSizePhaseVI.getDataSize() ? 1 : 0) != 0);
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    @Test(timeout=180000L)
    public void testSelectiveFlushAndWALinDataCompaction() throws IOException {
        int i;
        int i2;
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.hregion.memstore.flush.size", 307200L);
        conf.set("hbase.regionserver.flush.policy", FlushNonSloppyStoresFirstPolicy.class.getName());
        conf.setLong("hbase.hregion.percolumnfamilyflush.size.lower.bound.min", 76800L);
        conf.setDouble("hbase.memstore.inmemoryflush.threshold.factor", 0.5);
        conf.set("hbase.hregion.compacting.memstore.type", String.valueOf(MemoryCompactionPolicy.EAGER));
        HRegion region = this.initHRegion("testSelectiveFlushAndWALinDataCompaction", conf);
        this.verifyInMemoryFlushSize((Region)region);
        for (i2 = 1; i2 <= 1200; ++i2) {
            region.put(this.createPut(1, i2));
            if (i2 > 100) continue;
            region.put(this.createPut(2, i2));
            if (i2 > 50) continue;
            region.put(this.createPut(3, i2));
        }
        for (i2 = 100; i2 < 2000; ++i2) {
            region.put(this.createPut(2, i2));
        }
        ((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY1).memstore).setCompositeSnapshot(false);
        ((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY3).memstore).setCompositeSnapshot(false);
        long totalMemstoreSize = region.getMemStoreSize();
        MemStoreSize cf1MemstoreSizePhaseI = region.getStore(FAMILY1).getMemStoreSize();
        MemStoreSize cf2MemstoreSizePhaseI = region.getStore(FAMILY2).getMemStoreSize();
        MemStoreSize cf3MemstoreSizePhaseI = region.getStore(FAMILY3).getMemStoreSize();
        Assert.assertTrue((cf1MemstoreSizePhaseI.getDataSize() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((cf2MemstoreSizePhaseI.getDataSize() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((cf3MemstoreSizePhaseI.getDataSize() > 0L ? 1 : 0) != 0);
        String msg = "totalMemstoreSize=" + totalMemstoreSize + " DefaultMemStore.DEEP_OVERHEAD=" + DefaultMemStore.DEEP_OVERHEAD + " cf1MemstoreSizePhaseI=" + cf1MemstoreSizePhaseI + " cf2MemstoreSizePhaseI=" + cf2MemstoreSizePhaseI + " cf3MemstoreSizePhaseI=" + cf3MemstoreSizePhaseI;
        Assert.assertEquals((String)msg, (long)totalMemstoreSize, (long)(cf1MemstoreSizePhaseI.getDataSize() + cf2MemstoreSizePhaseI.getDataSize() + cf3MemstoreSizePhaseI.getDataSize()));
        CompactingMemStore cms1 = (CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY1).memstore;
        CompactingMemStore cms3 = (CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY3).memstore;
        cms1.flushInMemory();
        cms3.flushInMemory();
        region.flush(false);
        MemStoreSize cf2MemstoreSizePhaseII = region.getStore(FAMILY2).getMemStoreSize();
        long smallestSeqInRegionCurrentMemstorePhaseII = region.getWAL().getEarliestMemStoreSeqNum(region.getRegionInfo().getEncodedNameAsBytes());
        long smallestSeqCF1PhaseII = region.getOldestSeqIdOfStore(FAMILY1);
        long smallestSeqCF2PhaseII = region.getOldestSeqIdOfStore(FAMILY2);
        long smallestSeqCF3PhaseII = region.getOldestSeqIdOfStore(FAMILY3);
        Assert.assertEquals((long)0L, (long)cf2MemstoreSizePhaseII.getDataSize());
        Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)cf2MemstoreSizePhaseII.getHeapSize());
        String s = "\n\n----------------------------------\nUpon initial insert and flush, LSN of CF1 is:" + smallestSeqCF1PhaseII + ". LSN of CF2 is:" + smallestSeqCF2PhaseII + ". LSN of CF3 is:" + smallestSeqCF3PhaseII + ", smallestSeqInRegionCurrentMemstore:" + smallestSeqInRegionCurrentMemstorePhaseII + "\n";
        for (i = 1; i <= 1200; ++i) {
            region.put(this.createPut(1, i));
            if (i > 100) continue;
            region.put(this.createPut(2, i));
            if (i > 50) continue;
            region.put(this.createPut(3, i));
        }
        for (i = 100; i < 2000; ++i) {
            region.put(this.createPut(2, i));
        }
        long smallestSeqInRegionCurrentMemstorePhaseIII = region.getWAL().getEarliestMemStoreSeqNum(region.getRegionInfo().getEncodedNameAsBytes());
        long smallestSeqCF1PhaseIII = region.getOldestSeqIdOfStore(FAMILY1);
        long smallestSeqCF2PhaseIII = region.getOldestSeqIdOfStore(FAMILY2);
        long smallestSeqCF3PhaseIII = region.getOldestSeqIdOfStore(FAMILY3);
        s = s + "The smallest sequence in region WAL is: " + smallestSeqInRegionCurrentMemstorePhaseIII + ", the smallest sequence in CF1:" + smallestSeqCF1PhaseIII + ", the smallest sequence in CF2:" + smallestSeqCF2PhaseIII + ", the smallest sequence in CF3:" + smallestSeqCF3PhaseIII + "\n";
        cms1 = (CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY1).memstore;
        cms3 = (CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY3).memstore;
        cms1.flushInMemory();
        cms3.flushInMemory();
        region.flush(false);
        long smallestSeqInRegionCurrentMemstorePhaseIV = region.getWAL().getEarliestMemStoreSeqNum(region.getRegionInfo().getEncodedNameAsBytes());
        long smallestSeqCF1PhaseIV = region.getOldestSeqIdOfStore(FAMILY1);
        long smallestSeqCF2PhaseIV = region.getOldestSeqIdOfStore(FAMILY2);
        long smallestSeqCF3PhaseIV = region.getOldestSeqIdOfStore(FAMILY3);
        s = s + "The smallest sequence in region WAL is: " + smallestSeqInRegionCurrentMemstorePhaseIV + ", the smallest sequence in CF1:" + smallestSeqCF1PhaseIV + ", the smallest sequence in CF2:" + smallestSeqCF2PhaseIV + ", the smallest sequence in CF3:" + smallestSeqCF3PhaseIV + "\n";
        Assert.assertTrue((String)s, (smallestSeqInRegionCurrentMemstorePhaseIV > smallestSeqInRegionCurrentMemstorePhaseIII ? 1 : 0) != 0);
        Assert.assertTrue((smallestSeqCF1PhaseIV > smallestSeqCF1PhaseIII ? 1 : 0) != 0);
        Assert.assertTrue((smallestSeqCF3PhaseIV > smallestSeqCF3PhaseIII ? 1 : 0) != 0);
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    @Test(timeout=180000L)
    public void testSelectiveFlushWithBasicAndMerge() throws IOException {
        int i;
        int i2;
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.hregion.memstore.flush.size", 307200L);
        conf.set("hbase.regionserver.flush.policy", FlushNonSloppyStoresFirstPolicy.class.getName());
        conf.setLong("hbase.hregion.percolumnfamilyflush.size.lower.bound.min", 76800L);
        conf.setDouble("hbase.memstore.inmemoryflush.threshold.factor", 0.8);
        conf.set("hbase.hregion.compacting.memstore.type", String.valueOf(MemoryCompactionPolicy.BASIC));
        conf.setInt("hbase.hregion.compacting.pipeline.segments.limit", 1);
        HRegion region = this.initHRegion("testSelectiveFlushWithBasicAndMerge", conf);
        this.verifyInMemoryFlushSize((Region)region);
        for (i2 = 1; i2 <= 1200; ++i2) {
            region.put(this.createPut(1, i2));
            if (i2 > 100) continue;
            region.put(this.createPut(2, i2));
            if (i2 > 50) continue;
            region.put(this.createPut(3, i2));
        }
        for (i2 = 100; i2 < 2000; ++i2) {
            region.put(this.createPut(2, i2));
        }
        long totalMemstoreSize = region.getMemStoreSize();
        ((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY1).memstore).setIndexType(CompactingMemStore.IndexType.ARRAY_MAP);
        ((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY3).memstore).setIndexType(CompactingMemStore.IndexType.ARRAY_MAP);
        MemStoreSize cf1MemstoreSizePhaseI = region.getStore(FAMILY1).getMemStoreSize();
        MemStoreSize cf2MemstoreSizePhaseI = region.getStore(FAMILY2).getMemStoreSize();
        MemStoreSize cf3MemstoreSizePhaseI = region.getStore(FAMILY3).getMemStoreSize();
        Assert.assertTrue((cf1MemstoreSizePhaseI.getDataSize() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((cf2MemstoreSizePhaseI.getDataSize() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((cf3MemstoreSizePhaseI.getDataSize() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)totalMemstoreSize, (long)(cf1MemstoreSizePhaseI.getDataSize() + cf2MemstoreSizePhaseI.getDataSize() + cf3MemstoreSizePhaseI.getDataSize()));
        ((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY1).memstore).flushInMemory();
        ((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY3).memstore).flushInMemory();
        while (((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY1).memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        while (((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY3).memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        region.flush(false);
        MemStoreSize cf1MemstoreSizePhaseII = region.getStore(FAMILY1).getMemStoreSize();
        MemStoreSize cf2MemstoreSizePhaseII = region.getStore(FAMILY2).getMemStoreSize();
        MemStoreSize cf3MemstoreSizePhaseII = region.getStore(FAMILY3).getMemStoreSize();
        Assert.assertTrue((cf1MemstoreSizePhaseI.getHeapSize() > cf1MemstoreSizePhaseII.getHeapSize() ? 1 : 0) != 0);
        Assert.assertEquals((long)cf1MemstoreSizePhaseI.getDataSize(), (long)cf1MemstoreSizePhaseII.getDataSize());
        Assert.assertEquals((long)0L, (long)cf2MemstoreSizePhaseII.getDataSize());
        for (i = 1; i <= 1200; ++i) {
            region.put(this.createPut(1, i));
            if (i > 100) continue;
            region.put(this.createPut(2, i));
            if (i > 50) continue;
            region.put(this.createPut(3, i));
        }
        for (i = 100; i < 2000; ++i) {
            region.put(this.createPut(2, i));
        }
        MemStoreSize cf1MemstoreSizePhaseIII = region.getStore(FAMILY1).getMemStoreSize();
        ((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY1).memstore).flushInMemory();
        ((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY3).memstore).flushInMemory();
        while (((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY1).memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        while (((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY3).memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        region.flush(false);
        MemStoreSize cf1MemstoreSizePhaseIV = region.getStore(FAMILY1).getMemStoreSize();
        MemStoreSize cf2MemstoreSizePhaseIV = region.getStore(FAMILY2).getMemStoreSize();
        Assert.assertEquals((long)(2L * cf1MemstoreSizePhaseI.getDataSize()), (long)cf1MemstoreSizePhaseIV.getDataSize());
        Assert.assertEquals((long)(cf1MemstoreSizePhaseI.getHeapSize() - cf1MemstoreSizePhaseII.getHeapSize()), (long)(cf1MemstoreSizePhaseIII.getHeapSize() - cf1MemstoreSizePhaseIV.getHeapSize() - CellArrayImmutableSegment.DEEP_OVERHEAD_CAM));
        Assert.assertEquals((long)3L, (long)((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY1).memstore).getSegments().size());
        Assert.assertEquals((String)("\n<<< DEBUG: The data--heap sizes of stores before/after first flushes, CF1: " + cf1MemstoreSizePhaseI.getDataSize() + "/" + cf1MemstoreSizePhaseII.getDataSize() + "--" + cf1MemstoreSizePhaseI.getHeapSize() + "/" + cf1MemstoreSizePhaseII.getHeapSize() + ", CF2: " + cf2MemstoreSizePhaseI.getDataSize() + "/" + cf2MemstoreSizePhaseII.getDataSize() + "--" + cf2MemstoreSizePhaseI.getHeapSize() + "/" + cf2MemstoreSizePhaseII.getHeapSize() + ", CF3: " + cf3MemstoreSizePhaseI.getDataSize() + "/" + cf3MemstoreSizePhaseII.getDataSize() + "--" + cf3MemstoreSizePhaseI.getHeapSize() + "/" + cf3MemstoreSizePhaseII.getHeapSize() + "\n<<< AND before/after second flushes  CF1: " + cf1MemstoreSizePhaseIII.getDataSize() + "/" + cf1MemstoreSizePhaseIV.getDataSize() + "--" + cf1MemstoreSizePhaseIII.getHeapSize() + "/" + cf1MemstoreSizePhaseIV.getHeapSize() + "\n"), (long)0L, (long)cf2MemstoreSizePhaseIV.getDataSize());
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    @Test(timeout=300000L)
    public void testStressFlushAndWALinIndexCompaction() throws IOException {
        int i;
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.hregion.memstore.flush.size", 614400L);
        conf.set("hbase.regionserver.flush.policy", FlushNonSloppyStoresFirstPolicy.class.getName());
        conf.setLong("hbase.hregion.percolumnfamilyflush.size.lower.bound.min", 204800L);
        conf.setDouble("hbase.memstore.inmemoryflush.threshold.factor", 0.5);
        conf.set("hbase.hregion.compacting.memstore.type", String.valueOf(MemoryCompactionPolicy.BASIC));
        HRegion region = this.initHRegion("testSelectiveFlushAndWALinDataCompaction", conf);
        this.verifyInMemoryFlushSize((Region)region);
        Thread[] threads = new Thread[25];
        for (i = 0; i < threads.length; ++i) {
            int id = i * 10000;
            ConcurrentPutRunnable runnable = new ConcurrentPutRunnable(region, id);
            threads[i] = new Thread(runnable);
            threads[i].start();
        }
        Threads.sleep((long)10000L);
        region.flush(true);
        Threads.sleep((long)10000L);
        region.flush(true);
        ((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY1).memstore).flushInMemory();
        ((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY3).memstore).flushInMemory();
        while (((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY1).memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        while (((CompactingMemStore)region.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY3).memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private WAL getWAL(Region region) {
        return ((HRegion)region).getWAL();
    }

    private class ConcurrentPutRunnable
    implements Runnable {
        private final HRegion stressedRegion;
        private final int startNumber;

        ConcurrentPutRunnable(HRegion r, int i) {
            this.stressedRegion = r;
            this.startNumber = i;
        }

        @Override
        public void run() {
            block11: {
                try {
                    int i;
                    int dummy = this.startNumber / 10000;
                    System.out.print("Thread " + dummy + " with start number " + this.startNumber + " starts\n");
                    for (i = this.startNumber; i <= this.startNumber + 3000; ++i) {
                        this.stressedRegion.put(TestWalAndCompactingMemStoreFlush.this.createPut(1, i));
                        if (i > this.startNumber + 2000) continue;
                        this.stressedRegion.put(TestWalAndCompactingMemStoreFlush.this.createPut(2, i));
                        if (i > this.startNumber + 1000) continue;
                        this.stressedRegion.put(TestWalAndCompactingMemStoreFlush.this.createPut(3, i));
                    }
                    System.out.print("Thread with start number " + this.startNumber + " continues to more puts\n");
                    for (i = this.startNumber + 3000; i < this.startNumber + 5000; ++i) {
                        this.stressedRegion.put(TestWalAndCompactingMemStoreFlush.this.createPut(2, i));
                    }
                    for (i = this.startNumber + 5000; i < this.startNumber + 7000; ++i) {
                        this.stressedRegion.put(TestWalAndCompactingMemStoreFlush.this.createPut(1, i));
                    }
                    System.out.print("Thread with start number " + this.startNumber + " flushes\n");
                    if (this.startNumber == 0) {
                        ((CompactingMemStore)this.stressedRegion.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY1).memstore).flushInMemory();
                        while (((CompactingMemStore)this.stressedRegion.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY1).memstore).isMemStoreFlushingInMemory()) {
                            Threads.sleep((long)10L);
                        }
                    }
                    if (this.startNumber == 10000) {
                        ((CompactingMemStore)this.stressedRegion.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY2).memstore).flushInMemory();
                        while (((CompactingMemStore)this.stressedRegion.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY2).memstore).isMemStoreFlushingInMemory()) {
                            Threads.sleep((long)10L);
                        }
                    }
                    if (this.startNumber == 20000) {
                        ((CompactingMemStore)this.stressedRegion.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY3).memstore).flushInMemory();
                        while (((CompactingMemStore)this.stressedRegion.getStore((byte[])TestWalAndCompactingMemStoreFlush.FAMILY3).memstore).isMemStoreFlushingInMemory()) {
                            Threads.sleep((long)10L);
                        }
                    }
                    System.out.print("Thread with start number " + this.startNumber + " finishes\n");
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block11;
                    throw new AssertionError();
                }
            }
        }
    }
}

