/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.querymatcher.AbstractTestScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.CompactionScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestCompactionScanQueryMatcher
extends AbstractTestScanQueryMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(TestCompactionScanQueryMatcher.class);

    @Test
    public void testMatch_PartialRangeDropDeletes() throws Exception {
        this.testDropDeletes(this.row2, this.row3, new byte[][]{this.row1, this.row2, this.row2, this.row3}, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.INCLUDE);
        this.testDropDeletes(this.row2, this.row3, new byte[][]{this.row1, this.row1, this.row2}, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SKIP);
        this.testDropDeletes(this.row2, this.row3, new byte[][]{this.row2, this.row3, this.row3}, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE);
        this.testDropDeletes(this.row1, this.row3, new byte[][]{this.row1, this.row2, this.row3}, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.INCLUDE);
        this.testDropDeletes(HConstants.EMPTY_START_ROW, this.row3, new byte[][]{this.row1, this.row2, this.row3}, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.INCLUDE);
        this.testDropDeletes(this.row2, HConstants.EMPTY_END_ROW, new byte[][]{this.row1, this.row2, this.row3}, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP);
        this.testDropDeletes(HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, new byte[][]{this.row1, this.row2, this.row3, this.row3}, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP);
        this.testDropDeletes(this.row2, this.row3, new byte[][]{this.row1, this.row1, this.row3}, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE);
        this.testDropDeletes(this.row2, this.row3, new byte[][]{this.row3, this.row3}, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE);
        this.testDropDeletes(this.row2, this.row3, new byte[][]{this.row1, this.row1}, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE);
    }

    private void testDropDeletes(byte[] from, byte[] to, byte[][] rows, ScanQueryMatcher.MatchCode ... expected) throws IOException {
        long now = EnvironmentEdgeManager.currentTime();
        ScanInfo scanInfo = new ScanInfo(this.conf, this.fam2, 0, 1, this.ttl, KeepDeletedCells.FALSE, 65536L, -1L, this.rowComparator, false);
        CompactionScanQueryMatcher qm = CompactionScanQueryMatcher.create((ScanInfo)scanInfo, (ScanType)ScanType.COMPACT_RETAIN_DELETES, (long)Long.MAX_VALUE, (long)Long.MIN_VALUE, (long)Long.MIN_VALUE, (long)now, (byte[])from, (byte[])to, null);
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>(rows.length);
        byte[] prevRow = null;
        for (byte[] row : rows) {
            if (prevRow == null || !Bytes.equals(prevRow, (byte[])row)) {
                qm.setToNewRow((Cell)KeyValueUtil.createFirstOnRow((byte[])row));
                prevRow = row;
            }
            actual.add(qm.match((Cell)new KeyValue(row, this.fam2, null, now, KeyValue.Type.Delete)));
        }
        Assert.assertEquals((long)expected.length, (long)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            LOG.debug("expected " + expected[i] + ", actual " + actual.get(i));
            Assert.assertEquals((Object)expected[i], actual.get(i));
        }
    }
}

