/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.AbstractTestLogRolling;
import org.apache.hadoop.hbase.regionserver.wal.AsyncFSWAL;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.VerySlowRegionServerTests;
import org.apache.hadoop.hbase.wal.AsyncFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;

@Category(value={VerySlowRegionServerTests.class, LargeTests.class})
public class TestAsyncLogRolling
extends AbstractTestLogRolling {
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.wal.async.create.retries", 100);
        conf.set("hbase.wal.provider", "asyncfs");
        conf.set("hbase.wal.meta_provider", "asyncfs");
        AbstractTestLogRolling.setUpBeforeClass();
    }

    @Test(timeout=180000L)
    public void testLogRollOnDatanodeDeath() throws IOException, InterruptedException {
        this.dfsCluster.startDataNodes(TEST_UTIL.getConfiguration(), 3, true, null, null);
        this.tableName = this.getName();
        Table table = this.createTestTable(this.tableName);
        TEST_UTIL.waitUntilAllRegionsAssigned(table.getName());
        this.doPut(table, 1);
        this.server = TEST_UTIL.getRSForFirstRegionInTable(table.getName());
        RegionInfo hri = ((HRegion)this.server.getRegions(table.getName()).get(0)).getRegionInfo();
        AsyncFSWAL wal = (AsyncFSWAL)this.server.getWAL(hri);
        int numRolledLogFiles = AsyncFSWALProvider.getNumRolledLogFiles((WAL)wal);
        DatanodeInfo[] dnInfos = wal.getPipeline();
        MiniDFSCluster.DataNodeProperties dnProp = TEST_UTIL.getDFSCluster().stopDataNode(dnInfos[0].getName());
        TEST_UTIL.getDFSCluster().restartDataNode(dnProp);
        this.doPut(table, 2);
        Assert.assertEquals((long)(numRolledLogFiles + 1), (long)AsyncFSWALProvider.getNumRolledLogFiles((WAL)wal));
    }
}

