/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestReplicationDroppedTables
extends TestReplicationBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationDroppedTables.class);

    @Before
    public void setUp() throws Exception {
        for (JVMClusterUtil.RegionServerThread r : utility1.getHBaseCluster().getRegionServerThreads()) {
            utility1.getAdmin().rollWALWriter(r.getRegionServer().getServerName());
        }
        int rowCount = utility1.countRows(tableName);
        utility1.deleteTableData(tableName);
        Scan scan = new Scan();
        int lastCount = 0;
        for (int i = 0; i < 10; ++i) {
            if (i == 9) {
                Assert.fail((String)"Waited too much time for truncate");
            }
            ResultScanner scanner = htable2.getScanner(scan);
            Result[] res = scanner.next(rowCount);
            scanner.close();
            if (res.length == 0) break;
            if (res.length < lastCount) {
                --i;
            }
            lastCount = res.length;
            LOG.info("Still got " + res.length + " rows");
            Thread.sleep(500L);
        }
    }

    @Test(timeout=600000L)
    public void testEditsStuckBehindDroppedTable() throws Exception {
        this.testEditsBehindDroppedTable(false, "test_dropped");
    }

    @Test(timeout=600000L)
    public void testEditsDroppedWithDroppedTable() throws Exception {
        this.testEditsBehindDroppedTable(true, "test_dropped");
    }

    @Test(timeout=600000L)
    public void testEditsDroppedWithDroppedTableNS() throws Exception {
        Connection connection1 = ConnectionFactory.createConnection((Configuration)conf1);
        try (Admin admin1 = connection1.getAdmin();){
            admin1.createNamespace(NamespaceDescriptor.create((String)"NS").build());
        }
        Connection connection2 = ConnectionFactory.createConnection((Configuration)conf2);
        try (Admin admin2 = connection2.getAdmin();){
            admin2.createNamespace(NamespaceDescriptor.create((String)"NS").build());
        }
        this.testEditsBehindDroppedTable(true, "NS:test_dropped");
    }

    private void testEditsBehindDroppedTable(boolean allowProceeding, String tName) throws Exception {
        conf1.setBoolean("hbase.replication.drop.on.deleted.table", allowProceeding);
        conf1.setInt("hbase.replication.source.maxthreads", 1);
        utility1.shutdownMiniHBaseCluster();
        utility1.startMiniHBaseCluster(1, 1);
        TableName tablename = TableName.valueOf((String)tName);
        byte[] familyname = Bytes.toBytes((String)"fam");
        byte[] row = Bytes.toBytes((String)"row");
        HTableDescriptor table = new HTableDescriptor(tablename);
        HColumnDescriptor fam = new HColumnDescriptor(familyname);
        fam.setScope(1);
        table.addFamily(fam);
        Connection connection1 = ConnectionFactory.createConnection((Configuration)conf1);
        Connection connection2 = ConnectionFactory.createConnection((Configuration)conf2);
        try (Admin admin1 = connection1.getAdmin();){
            admin1.createTable((TableDescriptor)table);
        }
        var11_11 = null;
        try (Admin admin2 = connection2.getAdmin();){
            admin2.createTable((TableDescriptor)table);
        }
        catch (Throwable throwable) {
            var11_11 = throwable;
            throw throwable;
        }
        utility1.waitUntilAllRegionsAssigned(tablename);
        utility2.waitUntilAllRegionsAssigned(tablename);
        Table lHtable1 = utility1.getConnection().getTable(tablename);
        admin.disablePeer("2");
        byte[] rowkey = Bytes.toBytes((String)"0 put on table to be dropped");
        Put put = new Put(rowkey);
        put.addColumn(familyname, row, row);
        lHtable1.put(put);
        rowkey = Bytes.toBytes((String)"normal put");
        put = new Put(rowkey);
        put.addColumn(famName, row, row);
        htable1.put(put);
        try (Admin admin1 = connection1.getAdmin();){
            admin1.disableTable(tablename);
            admin1.deleteTable(tablename);
        }
        var14_20 = null;
        try (Admin admin2 = connection2.getAdmin();){
            admin2.disableTable(tablename);
            admin2.deleteTable(tablename);
        }
        catch (Throwable throwable) {
            var14_20 = throwable;
            throw throwable;
        }
        admin.enablePeer("2");
        if (allowProceeding) {
            this.verifyReplicationProceeded(rowkey);
        } else {
            this.verifyReplicationStuck(rowkey);
        }
        conf1.setBoolean("hbase.replication.drop.on.deleted.table", false);
    }

    @Test(timeout=600000L)
    public void testEditsBehindDroppedTableTiming() throws Exception {
        conf1.setBoolean("hbase.replication.drop.on.deleted.table", true);
        conf1.setInt("hbase.replication.source.maxthreads", 1);
        utility1.shutdownMiniHBaseCluster();
        utility1.startMiniHBaseCluster(1, 1);
        TableName tablename = TableName.valueOf((String)"testdroppedtimed");
        byte[] familyname = Bytes.toBytes((String)"fam");
        byte[] row = Bytes.toBytes((String)"row");
        HTableDescriptor table = new HTableDescriptor(tablename);
        HColumnDescriptor fam = new HColumnDescriptor(familyname);
        fam.setScope(1);
        table.addFamily(fam);
        Connection connection1 = ConnectionFactory.createConnection((Configuration)conf1);
        Connection connection2 = ConnectionFactory.createConnection((Configuration)conf2);
        try (Admin admin1 = connection1.getAdmin();){
            admin1.createTable((TableDescriptor)table);
        }
        var9_9 = null;
        try (Admin admin2 = connection2.getAdmin();){
            admin2.createTable((TableDescriptor)table);
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        utility1.waitUntilAllRegionsAssigned(tablename);
        utility2.waitUntilAllRegionsAssigned(tablename);
        Table lHtable1 = utility1.getConnection().getTable(tablename);
        admin.disablePeer("2");
        byte[] rowkey = Bytes.toBytes((String)"0 put on table to be dropped");
        Put put = new Put(rowkey);
        put.addColumn(familyname, row, row);
        lHtable1.put(put);
        rowkey = Bytes.toBytes((String)"normal put");
        put = new Put(rowkey);
        put.addColumn(famName, row, row);
        htable1.put(put);
        try (Admin admin2 = connection2.getAdmin();){
            admin2.disableTable(tablename);
            admin2.deleteTable(tablename);
        }
        admin.enablePeer("2");
        var12_18 = null;
        try (Admin admin1 = connection1.getAdmin();){
            this.verifyReplicationStuck(rowkey);
            admin1.disableTable(tablename);
            this.verifyReplicationStuck(rowkey);
            admin1.deleteTable(tablename);
            this.verifyReplicationProceeded(rowkey);
        }
        catch (Throwable throwable) {
            var12_18 = throwable;
            throw throwable;
        }
        conf1.setBoolean("hbase.replication.drop.on.deleted.table", false);
    }

    private void verifyReplicationProceeded(byte[] rowkey) throws Exception {
        Get get = new Get(rowkey);
        for (int i = 0; i < 10; ++i) {
            Result res;
            if (i == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res = htable2.get(get)).size() != 0) {
                Assert.assertArrayEquals((byte[])res.getRow(), (byte[])rowkey);
                break;
            }
            LOG.info("Row not available");
            Thread.sleep(500L);
        }
    }

    private void verifyReplicationStuck(byte[] rowkey) throws Exception {
        Get get = new Get(rowkey);
        for (int i = 0; i < 10; ++i) {
            Result res = htable2.get(get);
            if (res.size() >= 1) {
                Assert.fail((String)"Edit should have been stuck behind dropped tables");
                continue;
            }
            LOG.info("Row not replicated, let's wait a bit more...");
            Thread.sleep(500L);
        }
    }
}

