/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.util.List;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationQueuesArguments;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClientArguments;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClientZKImpl;
import org.apache.hadoop.hbase.replication.ReplicationSourceDummy;
import org.apache.hadoop.hbase.replication.regionserver.TestReplicationSourceManager;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestReplicationSourceManagerZkImpl
extends TestReplicationSourceManager {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = HBaseConfiguration.create();
        conf.set("replication.replicationsource.implementation", ReplicationSourceDummy.class.getCanonicalName());
        conf.setLong("replication.sleep.before.failover", 2000L);
        conf.setInt("replication.source.maxretriesmultiplier", 10);
        utility = new HBaseTestingUtility(conf);
        utility.startMiniZKCluster();
        TestReplicationSourceManagerZkImpl.setupZkAndReplication();
    }

    @Test
    public void testNodeFailoverDeadServerParsing() throws Exception {
        TestReplicationSourceManager.DummyServer server = new TestReplicationSourceManager.DummyServer("ec2-54-234-230-108.compute-1.amazonaws.com");
        ReplicationQueues repQueues = ReplicationFactory.getReplicationQueues((ReplicationQueuesArguments)new ReplicationQueuesArguments(conf, (Abortable)server, server.getZooKeeper()));
        repQueues.init(server.getServerName().toString());
        files.add("log1");
        files.add("log2");
        for (String file : files) {
            repQueues.addLog("1", file);
        }
        TestReplicationSourceManager.DummyServer s1 = new TestReplicationSourceManager.DummyServer("ip-10-8-101-114.ec2.internal");
        TestReplicationSourceManager.DummyServer s2 = new TestReplicationSourceManager.DummyServer("ec2-107-20-52-47.compute-1.amazonaws.com");
        TestReplicationSourceManager.DummyServer s3 = new TestReplicationSourceManager.DummyServer("ec2-23-20-187-167.compute-1.amazonaws.com");
        ReplicationQueues rq1 = ReplicationFactory.getReplicationQueues((ReplicationQueuesArguments)new ReplicationQueuesArguments(s1.getConfiguration(), (Abortable)s1, s1.getZooKeeper()));
        rq1.init(s1.getServerName().toString());
        String serverName = server.getServerName().getServerName();
        List unclaimed = rq1.getUnClaimedQueueIds(serverName);
        rq1.claimQueue(serverName, (String)unclaimed.get(0)).getSecond();
        rq1.removeReplicatorIfQueueIsEmpty((String)unclaimed.get(0));
        ReplicationQueues rq2 = ReplicationFactory.getReplicationQueues((ReplicationQueuesArguments)new ReplicationQueuesArguments(s2.getConfiguration(), (Abortable)s2, s2.getZooKeeper()));
        rq2.init(s2.getServerName().toString());
        serverName = s1.getServerName().getServerName();
        unclaimed = rq2.getUnClaimedQueueIds(serverName);
        rq2.claimQueue(serverName, (String)unclaimed.get(0)).getSecond();
        rq2.removeReplicatorIfQueueIsEmpty((String)unclaimed.get(0));
        ReplicationQueues rq3 = ReplicationFactory.getReplicationQueues((ReplicationQueuesArguments)new ReplicationQueuesArguments(s3.getConfiguration(), (Abortable)s3, s3.getZooKeeper()));
        rq3.init(s3.getServerName().toString());
        serverName = s2.getServerName().getServerName();
        unclaimed = rq3.getUnClaimedQueueIds(serverName);
        String queue3 = (String)rq3.claimQueue(serverName, (String)unclaimed.get(0)).getFirst();
        rq3.removeReplicatorIfQueueIsEmpty((String)unclaimed.get(0));
        ReplicationQueueInfo replicationQueueInfo = new ReplicationQueueInfo(queue3);
        List result = replicationQueueInfo.getDeadRegionServers();
        Assert.assertTrue((boolean)result.contains(server.getServerName()));
        Assert.assertTrue((boolean)result.contains(s1.getServerName()));
        Assert.assertTrue((boolean)result.contains(s2.getServerName()));
        server.stop("");
    }

    @Test
    public void testFailoverDeadServerCversionChange() throws Exception {
        TestReplicationSourceManager.DummyServer s0 = new TestReplicationSourceManager.DummyServer("cversion-change0.example.org");
        ReplicationQueues repQueues = ReplicationFactory.getReplicationQueues((ReplicationQueuesArguments)new ReplicationQueuesArguments(conf, (Abortable)s0, s0.getZooKeeper()));
        repQueues.init(s0.getServerName().toString());
        files.add("log1");
        files.add("log2");
        for (String file : files) {
            repQueues.addLog("1", file);
        }
        TestReplicationSourceManager.DummyServer s1 = new TestReplicationSourceManager.DummyServer("cversion-change1.example.org");
        ReplicationQueues rq1 = ReplicationFactory.getReplicationQueues((ReplicationQueuesArguments)new ReplicationQueuesArguments(s1.getConfiguration(), (Abortable)s1, s1.getZooKeeper()));
        rq1.init(s1.getServerName().toString());
        ReplicationQueuesClientZKImpl client = (ReplicationQueuesClientZKImpl)ReplicationFactory.getReplicationQueuesClient((ReplicationQueuesClientArguments)new ReplicationQueuesClientArguments(s1.getConfiguration(), (Abortable)s1, s1.getZooKeeper()));
        int v0 = client.getQueuesZNodeCversion();
        List queues = rq1.getUnClaimedQueueIds(s0.getServerName().getServerName());
        for (String queue : queues) {
            rq1.claimQueue(s0.getServerName().getServerName(), queue);
        }
        rq1.removeReplicatorIfQueueIsEmpty(s0.getServerName().getServerName());
        int v1 = client.getQueuesZNodeCversion();
        Assert.assertEquals((long)(v0 + 1), (long)v1);
        s0.stop("");
    }
}

