/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={SecurityTests.class, LargeTests.class})
public class TestAccessControlFilter
extends SecureTestUtil {
    @Rule
    public TestName name = new TestName();
    private static HBaseTestingUtility TEST_UTIL;
    private static User READER;
    private static User LIMITED;
    private static User DENIED;
    private static TableName TABLE;
    private static byte[] FAMILY;
    private static byte[] PRIVATE_COL;
    private static byte[] PUBLIC_COL;

    @Before
    public void setup() {
        TABLE = TableName.valueOf((String)this.name.getMethodName());
    }

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.regionserver.metahandler.count", 10);
        TestAccessControlFilter.enableSecurity(conf);
        TestAccessControlFilter.verifyConfiguration(conf);
        conf.setBoolean("hbase.security.access.early_out", false);
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.waitTableEnabled(AccessControlLists.ACL_TABLE_NAME.getName(), 50000L);
        READER = User.createUserForTesting((Configuration)conf, (String)"reader", (String[])new String[0]);
        LIMITED = User.createUserForTesting((Configuration)conf, (String)"limited", (String[])new String[0]);
        DENIED = User.createUserForTesting((Configuration)conf, (String)"denied", (String[])new String[0]);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=180000L)
    public void testQualifierAccess() throws Exception {
        try (Table table = TestAccessControlFilter.createTable(TEST_UTIL, TABLE, (byte[][])new byte[][]{FAMILY});){
            this.doQualifierAccess(table);
        }
    }

    private void doQualifierAccess(Table table) throws Exception {
        SecureTestUtil.grantOnTable(TEST_UTIL, READER.getShortName(), TABLE, null, null, Permission.Action.READ);
        SecureTestUtil.grantOnTable(TEST_UTIL, LIMITED.getShortName(), TABLE, FAMILY, PUBLIC_COL, Permission.Action.READ);
        ArrayList<Put> puts = new ArrayList<Put>(100);
        for (int i = 0; i < 100; ++i) {
            Put p = new Put(Bytes.toBytes((int)i));
            p.addColumn(FAMILY, PRIVATE_COL, Bytes.toBytes((String)("secret " + i)));
            p.addColumn(FAMILY, PUBLIC_COL, Bytes.toBytes((String)("info " + i)));
            puts.add(p);
        }
        table.put(puts);
        READER.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
                conf.set("testkey", UUID.randomUUID().toString());
                Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                Table t = connection.getTable(TABLE);
                try {
                    ResultScanner rs = t.getScanner(new Scan());
                    int rowcnt = 0;
                    for (Result r : rs) {
                        ++rowcnt;
                        int rownum = Bytes.toInt((byte[])r.getRow());
                        Assert.assertTrue((boolean)r.containsColumn(FAMILY, PRIVATE_COL));
                        Assert.assertEquals((Object)("secret " + rownum), (Object)Bytes.toString((byte[])r.getValue(FAMILY, PRIVATE_COL)));
                        Assert.assertTrue((boolean)r.containsColumn(FAMILY, PUBLIC_COL));
                        Assert.assertEquals((Object)("info " + rownum), (Object)Bytes.toString((byte[])r.getValue(FAMILY, PUBLIC_COL)));
                    }
                    Assert.assertEquals((String)"Expected 100 rows returned", (long)100L, (long)rowcnt);
                    Iterator iterator = null;
                    return iterator;
                }
                finally {
                    t.close();
                    connection.close();
                }
            }
        });
        LIMITED.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
                conf.set("testkey", UUID.randomUUID().toString());
                Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                Table t = connection.getTable(TABLE);
                try {
                    ResultScanner rs = t.getScanner(new Scan());
                    int rowcnt = 0;
                    for (Result r : rs) {
                        ++rowcnt;
                        int rownum = Bytes.toInt((byte[])r.getRow());
                        Assert.assertFalse((boolean)r.containsColumn(FAMILY, PRIVATE_COL));
                        Assert.assertTrue((boolean)r.containsColumn(FAMILY, PUBLIC_COL));
                        Assert.assertEquals((Object)("info " + rownum), (Object)Bytes.toString((byte[])r.getValue(FAMILY, PUBLIC_COL)));
                    }
                    Assert.assertEquals((String)"Expected 100 rows returned", (long)100L, (long)rowcnt);
                    Iterator iterator = null;
                    return iterator;
                }
                finally {
                    t.close();
                    connection.close();
                }
            }
        });
        DENIED.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
                conf.set("testkey", UUID.randomUUID().toString());
                Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                Table t = connection.getTable(TABLE);
                try {
                    ResultScanner rs = t.getScanner(new Scan());
                    int rowcnt = 0;
                    for (Result r : rs) {
                        ++rowcnt;
                        int rownum = Bytes.toInt((byte[])r.getRow());
                        Assert.assertFalse((boolean)r.containsColumn(FAMILY, PRIVATE_COL));
                        Assert.assertTrue((boolean)r.containsColumn(FAMILY, PUBLIC_COL));
                        Assert.assertEquals((Object)("info " + rownum), (Object)Bytes.toString((byte[])r.getValue(FAMILY, PUBLIC_COL)));
                    }
                    Assert.assertEquals((String)"Expected 0 rows returned", (long)0L, (long)rowcnt);
                    Iterator iterator = null;
                    return iterator;
                }
                finally {
                    t.close();
                    connection.close();
                }
            }
        });
    }

    static {
        FAMILY = Bytes.toBytes((String)"f1");
        PRIVATE_COL = Bytes.toBytes((String)"private");
        PUBLIC_COL = Bytes.toBytes((String)"public");
    }
}

