/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.security.token.AuthenticationKey;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import org.apache.hadoop.hbase.security.token.ZKSecretWatcher;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hadoop.io.Writable;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SecurityTests.class, SmallTests.class})
public class TestZKSecretWatcherRefreshKeys {
    private static final Logger LOG = LoggerFactory.getLogger(TestZKSecretWatcherRefreshKeys.class);
    private static HBaseTestingUtility TEST_UTIL;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    private static ZKWatcher newZK(Configuration conf, String name, Abortable abort) throws Exception {
        Configuration copy = HBaseConfiguration.create((Configuration)conf);
        ZKWatcher zk = new ZKWatcher(copy, name, abort);
        return zk;
    }

    @Test
    public void testRefreshKeys() throws Exception {
        Integer[] keys;
        Configuration conf = TEST_UTIL.getConfiguration();
        ZKWatcher zk = TestZKSecretWatcherRefreshKeys.newZK(conf, "127.0.0.1", new MockAbortable());
        AuthenticationTokenSecretManager keyManager = new AuthenticationTokenSecretManager(conf, zk, "127.0.0.1", 3600000L, 60000L);
        ZKSecretWatcher watcher = new ZKSecretWatcher(conf, zk, keyManager);
        ZKUtil.deleteChildrenRecursively((ZKWatcher)zk, (String)watcher.getKeysParentZNode());
        for (Integer key : keys = new Integer[]{1, 2, 3, 4, 5, 6}) {
            AuthenticationKey ak = new AuthenticationKey(key.intValue(), System.currentTimeMillis() + 600000L, null);
            ZKUtil.createWithParents((ZKWatcher)zk, (String)ZNodePaths.joinZNode((String)watcher.getKeysParentZNode(), (String)key.toString()), (byte[])Writables.getBytes((Writable)ak));
        }
        Assert.assertNull((Object)keyManager.getCurrentKey());
        watcher.refreshKeys();
        for (Integer key : keys) {
            Assert.assertNotNull((Object)keyManager.getKey(key.intValue()));
        }
    }

    private static class MockAbortable
    implements Abortable {
        private boolean abort;

        private MockAbortable() {
        }

        public void abort(String reason, Throwable e) {
            LOG.info("Aborting: " + reason, e);
            this.abort = true;
        }

        public boolean isAborted() {
            return this.abort;
        }
    }
}

